/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.surveillanceViews.SurveillanceViewConfiguration;
import org.opennms.netmgt.config.surveillanceViews.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurveillanceViewsFactory {
    private static SurveillanceViewsFactory m_instance;
    private static boolean m_loadedFromFile;
    protected boolean initialized = false;
    protected static long m_lastModified;
    protected static Map<String, View> m_viewsMap;
    private static SurveillanceViewConfiguration m_config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurveillanceViewsFactory(String configFile) throws MarshalException, ValidationException, IOException {
        InputStreamReader rdr = new InputStreamReader(new FileInputStream(configFile));
        try {
            this.initialize(rdr);
        }
        finally {
            rdr.close();
        }
    }

    public SurveillanceViewsFactory(Reader rdr) throws MarshalException, ValidationException {
        this.initialize(rdr);
    }

    private void initialize(Reader rdr) throws MarshalException, ValidationException {
        this.log().debug((Object)"initialize: initializing surveillance views factory.");
        m_config = (SurveillanceViewConfiguration)Unmarshaller.unmarshal(SurveillanceViewConfiguration.class, (Reader)rdr);
        m_viewsMap = new HashMap<String, View>();
        ArrayList viewList = m_config.getViews().getViewCollection();
        for (View view : viewList) {
            m_viewsMap.put(view.getName(), view);
        }
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (m_instance == null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SURVEILLANCE_VIEWS_FILE_NAME);
            m_instance = new SurveillanceViewsFactory(cfgFile.getPath());
            m_lastModified = cfgFile.lastModified();
            m_loadedFromFile = true;
        }
    }

    public static synchronized SurveillanceViewsFactory getInstance() {
        if (m_instance == null) {
            throw new IllegalStateException("You must call ViewDisplay.init() before calling getInstance().");
        }
        return m_instance;
    }

    public static synchronized void setInstance(SurveillanceViewsFactory instance) {
        m_instance = instance;
        m_loadedFromFile = false;
    }

    public synchronized void reload() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        m_instance = null;
        SurveillanceViewsFactory.init();
    }

    public View getView(String viewName) throws IOException, MarshalException, ValidationException {
        if (viewName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.updateFromFile();
        View view = m_viewsMap.get(viewName);
        return view;
    }

    protected void updateFromFile() throws IOException, MarshalException, ValidationException {
        File surveillanceViewsFile;
        if (m_loadedFromFile && m_lastModified != (surveillanceViewsFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SURVEILLANCE_VIEWS_FILE_NAME)).lastModified()) {
            this.reload();
        }
    }

    public static synchronized SurveillanceViewConfiguration getConfig() {
        return m_config;
    }

    public static synchronized void setConfig(SurveillanceViewConfiguration m_config) {
        SurveillanceViewsFactory.m_config = m_config;
    }

    public static synchronized Map<String, View> getViewsMap() {
        return m_viewsMap;
    }

    public static synchronized void setViewsMap(Map<String, View> map) {
        m_viewsMap = map;
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    static {
        m_loadedFromFile = false;
    }
}

