/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.IpListFromUrl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DefaultServiceMonitorLocator;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.ExcludeRange;
import org.opennms.netmgt.config.poller.IncludeRange;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.netmgt.dao.CastorDataAccessFailureException;
import org.opennms.netmgt.dao.CastorObjectRetrievalFailureException;
import org.opennms.netmgt.filter.Filter;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.ServiceSelector;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.ServiceMonitorLocator;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.springframework.dao.PermissionDeniedDataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PollerConfigManager
implements PollerConfig {
    private PollerConfiguration m_config;
    private Map<String, List<String>> m_urlIPMap;
    private Map<Package, List<String>> m_pkgIpMap;
    private Map<String, ServiceMonitor> m_svcMonitors = Collections.synchronizedMap(new TreeMap());
    private static boolean m_verifyServer;
    private static String m_localServer;

    public PollerConfigManager(Reader reader, String localServer, boolean verifyServer) throws MarshalException, ValidationException, IOException {
        m_localServer = localServer;
        m_verifyServer = verifyServer;
        this.reloadXML(reader);
    }

    @Override
    public abstract void update() throws IOException, MarshalException, ValidationException;

    protected abstract void saveXml(String var1) throws IOException;

    private void createUrlIpMap() {
        this.m_urlIPMap = new HashMap<String, List<String>>();
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            Enumeration urlEnum = pkg.enumerateIncludeUrl();
            while (urlEnum.hasMoreElements()) {
                String urlname = (String)urlEnum.nextElement();
                List iplist = IpListFromUrl.parse((String)urlname);
                if (iplist.size() <= 0) continue;
                this.m_urlIPMap.put(urlname, iplist);
            }
        }
    }

    protected synchronized void reloadXML(Reader reader) throws MarshalException, ValidationException, IOException {
        this.m_config = (PollerConfiguration)Unmarshaller.unmarshal(PollerConfiguration.class, (Reader)reader);
        this.createUrlIpMap();
        this.createPackageIpListMap();
        this.createServiceMonitors();
    }

    @Override
    public synchronized void save() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
        this.saveXml(stringWriter.toString());
        this.update();
    }

    @Override
    public synchronized PollerConfiguration getConfiguration() {
        return this.m_config;
    }

    @Override
    public synchronized Package getPackage(String name) {
        Enumeration packageEnum = this.m_config.enumeratePackage();
        while (packageEnum.hasMoreElements()) {
            Package thisPackage = (Package)packageEnum.nextElement();
            if (!thisPackage.getName().equals(name)) continue;
            return thisPackage;
        }
        return null;
    }

    @Override
    public ServiceSelector getServiceSelectorForPackage(Package pkg) {
        String filter = pkg.getFilter().getContent();
        LinkedList<String> svcNames = new LinkedList<String>();
        Enumeration pkgServices = pkg.enumerateService();
        while (pkgServices.hasMoreElements()) {
            svcNames.add(((Service)pkgServices.nextElement()).getName());
        }
        return new ServiceSelector(filter, svcNames);
    }

    @Override
    public synchronized void addPackage(Package pkg) {
        this.m_config.addPackage(pkg);
    }

    @Override
    public synchronized void addMonitor(String svcName, String className) {
        Monitor monitor = new Monitor();
        monitor.setService(svcName);
        monitor.setClassName(className);
        this.m_config.addMonitor(monitor);
    }

    private boolean interfaceInUrl(String addr, String url) {
        boolean bRet = false;
        List<String> iplist = this.m_urlIPMap.get(url);
        if (iplist != null && iplist.size() > 0) {
            bRet = iplist.contains(addr);
        }
        return bRet;
    }

    @Override
    public synchronized boolean getXmlrpc() {
        String flag = this.m_config.getXmlrpc();
        return flag.equals("true");
    }

    @Override
    public synchronized boolean pathOutageEnabled() {
        String flag = this.m_config.getPathOutageEnabled();
        return flag.equals("true");
    }

    @Override
    public synchronized String getCriticalService() {
        return this.m_config.getNodeOutage().getCriticalService().getName();
    }

    @Override
    public synchronized boolean pollAllIfNoCriticalServiceDefined() {
        String flag = this.m_config.getNodeOutage().getPollAllIfNoCriticalServiceDefined();
        return flag.equals("true");
    }

    @Override
    public synchronized boolean nodeOutageProcessingEnabled() {
        String status = this.m_config.getNodeOutage().getStatus();
        return status.equals("on");
    }

    @Override
    public synchronized boolean serviceUnresponsiveEnabled() {
        String enabled = this.m_config.getServiceUnresponsiveEnabled();
        return enabled.equals("true");
    }

    private void createPackageIpListMap() {
        this.m_pkgIpMap = new HashMap<Package, List<String>>();
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            try {
                List<String> ipList = this.getIpList(pkg);
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("createPackageIpMap: package " + pkg.getName() + ": ipList size =  " + ipList.size()));
                }
                if (ipList.size() <= 0) continue;
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("createPackageIpMap: package " + pkg.getName() + ". IpList size is " + ipList.size()));
                }
                this.m_pkgIpMap.put(pkg, ipList);
            }
            catch (Throwable t) {
                if (!this.log().isEnabledFor(Priority.ERROR)) continue;
                this.log().error((Object)("createPackageIpMap: failed to map package: " + pkg.getName() + " to an IP List"), t);
            }
        }
    }

    @Override
    public List<String> getIpList(Package pkg) {
        Filter filter = new Filter();
        StringBuffer filterRules = new StringBuffer(pkg.getFilter().getContent());
        if (m_verifyServer) {
            filterRules.append(" & (serverName == ");
            filterRules.append('\"');
            filterRules.append(m_localServer);
            filterRules.append('\"');
            filterRules.append(")");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("createPackageIpMap: package is " + pkg.getName() + ". filer rules are  " + filterRules.toString()));
        }
        List ipList = filter.getIPList(filterRules.toString());
        return ipList;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    @Override
    public synchronized void rebuildPackageIpListMap() {
        this.createPackageIpListMap();
    }

    @Override
    public synchronized boolean interfaceInPackage(String iface, Package pkg) {
        Category log = this.log();
        boolean filterPassed = false;
        List<String> ipList = this.m_pkgIpMap.get(pkg);
        if (ipList != null && ipList.size() > 0) {
            filterPassed = ipList.contains(iface);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("interfaceInPackage: Interface " + iface + " passed filter for package " + pkg.getName() + "?: " + filterPassed));
        }
        if (!filterPassed) {
            return false;
        }
        boolean has_specific = false;
        boolean has_range_include = false;
        boolean has_range_exclude = false;
        has_range_include = pkg.getIncludeRangeCount() == 0;
        long addr = IPSorter.convertToLong((String)iface);
        Enumeration eincs = pkg.enumerateIncludeRange();
        while (!has_range_include && eincs.hasMoreElements()) {
            IncludeRange rng = (IncludeRange)eincs.nextElement();
            long start = IPSorter.convertToLong((String)rng.getBegin());
            if (addr > start) {
                long end = IPSorter.convertToLong((String)rng.getEnd());
                if (addr > end) continue;
                has_range_include = true;
                continue;
            }
            if (addr != start) continue;
            has_range_include = true;
        }
        Enumeration espec = pkg.enumerateSpecific();
        while (!has_specific && espec.hasMoreElements()) {
            long speca = IPSorter.convertToLong((String)espec.nextElement().toString());
            if (speca != addr) continue;
            has_specific = true;
        }
        Enumeration eurl = pkg.enumerateIncludeUrl();
        while (!has_specific && eurl.hasMoreElements()) {
            has_specific = this.interfaceInUrl(iface, (String)eurl.nextElement());
        }
        Enumeration eex = pkg.enumerateExcludeRange();
        while (!has_range_exclude && !has_specific && eex.hasMoreElements()) {
            ExcludeRange rng = (ExcludeRange)eex.nextElement();
            long start = IPSorter.convertToLong((String)rng.getBegin());
            if (addr > start) {
                long end = IPSorter.convertToLong((String)rng.getEnd());
                if (addr > end) continue;
                has_range_exclude = true;
                continue;
            }
            if (addr != start) continue;
            has_range_exclude = true;
        }
        return has_specific || has_range_include && !has_range_exclude;
    }

    @Override
    public synchronized boolean serviceInPackageAndEnabled(String svcName, Package pkg) {
        Category log = this.log();
        if (pkg == null) {
            log.warn((Object)"serviceInPackageAndEnabled:  pkg argument is NULL!!");
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("serviceInPackageAndEnabled: svcName=" + svcName + " pkg=" + pkg.getName()));
        }
        boolean result = false;
        Enumeration esvcs = pkg.enumerateService();
        while (!result && esvcs.hasMoreElements()) {
            String status;
            Service tsvc = (Service)esvcs.nextElement();
            if (!tsvc.getName().equalsIgnoreCase(svcName) || (status = tsvc.getStatus()) != null && !status.equals("on")) continue;
            result = true;
        }
        return result;
    }

    @Override
    public synchronized Service getServiceInPackage(String svcName, Package pkg) {
        Enumeration e = pkg.enumerateService();
        while (e.hasMoreElements()) {
            Service svc = (Service)e.nextElement();
            if (!svcName.equals(svc.getName())) continue;
            return svc;
        }
        return null;
    }

    @Override
    public synchronized boolean serviceMonitored(String svcName) {
        boolean result = false;
        Enumeration monitorEnum = this.m_config.enumerateMonitor();
        while (monitorEnum.hasMoreElements()) {
            Monitor monitor = (Monitor)monitorEnum.nextElement();
            if (!monitor.getService().equals(svcName)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public synchronized Package getFirstPackageMatch(String ipaddr) {
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            boolean inPkg = this.interfaceInPackage(ipaddr, pkg);
            if (!inPkg) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public synchronized List<String> getAllPackageMatches(String ipaddr) {
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        ArrayList<String> matchingPkgs = new ArrayList<String>();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            String pkgName = pkg.getName();
            boolean inPkg = this.interfaceInPackage(ipaddr, pkg);
            if (!inPkg) continue;
            matchingPkgs.add(pkgName);
        }
        return matchingPkgs;
    }

    @Override
    public synchronized boolean isPolled(String ipaddr) {
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            boolean inPkg = this.interfaceInPackage(ipaddr, pkg);
            if (!inPkg) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isPolled(String svcName, Package pkg) {
        boolean svcInPkg = this.serviceInPackageAndEnabled(svcName, pkg);
        if (svcInPkg) {
            return this.serviceMonitored(svcName);
        }
        return false;
    }

    @Override
    public synchronized boolean isPolled(String ipaddr, String svcName) {
        if (!this.serviceMonitored(svcName)) {
            return false;
        }
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        while (pkgEnum.hasMoreElements()) {
            boolean svcInPkg;
            Package pkg = (Package)pkgEnum.nextElement();
            boolean ipInPkg = this.interfaceInPackage(ipaddr, pkg);
            if (!ipInPkg || !(svcInPkg = this.serviceInPackageAndEnabled(svcName, pkg))) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getStep(Package pkg) {
        return pkg.getRrd().getStep();
    }

    @Override
    public List getRRAList(Package pkg) {
        return pkg.getRrd().getRraCollection();
    }

    @Override
    public Enumeration enumeratePackage() {
        return this.getConfiguration().enumeratePackage();
    }

    public Enumeration enumerateMonitor() {
        return this.getConfiguration().enumerateMonitor();
    }

    @Override
    public int getThreads() {
        return this.getConfiguration().getThreads();
    }

    private synchronized void createServiceMonitors() {
        Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)"start: Loading monitors");
        Collection<ServiceMonitorLocator> locators = this.getServiceMonitorLocators(DistributionContext.DAEMON);
        for (ServiceMonitorLocator locator : locators) {
            try {
                this.m_svcMonitors.put(locator.getServiceName(), locator.getServiceMonitor());
            }
            catch (Throwable t) {
                if (!log.isEnabledFor((Priority)Level.WARN)) continue;
                log.warn((Object)("start: Failed to create monitor " + locator.getServiceLocatorKey() + " for service " + locator.getServiceName()), t);
            }
        }
    }

    @Override
    public synchronized Map getServiceMonitors() {
        return this.m_svcMonitors;
    }

    @Override
    public synchronized ServiceMonitor getServiceMonitor(String svcName) {
        return (ServiceMonitor)this.getServiceMonitors().get(svcName);
    }

    @Override
    public synchronized Collection<ServiceMonitorLocator> getServiceMonitorLocators(DistributionContext context) {
        ArrayList<ServiceMonitorLocator> locators = new ArrayList<ServiceMonitorLocator>();
        Enumeration monitors = this.enumerateMonitor();
        while (monitors.hasMoreElements()) {
            Monitor monitor = (Monitor)monitors.nextElement();
            try {
                Class<? extends ServiceMonitor> mc = this.findServiceMonitorClass(monitor);
                if (!this.isDistributableToContext(mc, context)) continue;
                DefaultServiceMonitorLocator locator = new DefaultServiceMonitorLocator(monitor.getService(), mc);
                locators.add(locator);
            }
            catch (ClassNotFoundException e) {
                this.log().warn((Object)("Unable to location monitor for service: " + monitor.getService() + " class-name: " + monitor.getClassName()), (Throwable)e);
            }
            catch (CastorObjectRetrievalFailureException e) {
                this.log().warn((Object)e.getMessage(), e.getRootCause());
            }
        }
        return locators;
    }

    private boolean isDistributableToContext(Class<? extends ServiceMonitor> mc, DistributionContext context) {
        List<DistributionContext> supportedContexts = this.getSupportedDistributionContexts(mc);
        return supportedContexts.contains((Object)context) || supportedContexts.contains((Object)DistributionContext.ALL);
    }

    private List<DistributionContext> getSupportedDistributionContexts(Class<? extends ServiceMonitor> mc) {
        Distributable distributable = mc.getAnnotation(Distributable.class);
        List<DistributionContext> declaredContexts = distributable == null ? Collections.singletonList(DistributionContext.DAEMON) : Arrays.asList(distributable.value());
        return declaredContexts;
    }

    private Class<? extends ServiceMonitor> findServiceMonitorClass(Monitor monitor) throws ClassNotFoundException {
        Class<?> mc = Class.forName(monitor.getClassName());
        if (!ServiceMonitor.class.isAssignableFrom(mc)) {
            throw new CastorDataAccessFailureException("The monitor for service: " + monitor.getService() + " class-name: " + monitor.getClassName() + " must implement ServiceMonitor");
        }
        return mc;
    }

    @Override
    public String getNextOutageIdSql() {
        return this.m_config.getNextOutageId();
    }

    @Override
    public void releaseAllServiceMonitors() {
        for (ServiceMonitor sm : this.getServiceMonitors().values()) {
            sm.release();
        }
    }

    @Override
    public void saveResponseTimeData(String locationMonitor, OnmsMonitoredService monSvc, long responseTime, Package pkg) {
        String svcName = monSvc.getServiceName();
        Service svc = this.getServiceInPackage(svcName, pkg);
        String dsName = this.getServiceParameter(svc, "ds-name");
        if (dsName == null) {
            return;
        }
        String rrdRepository = this.getServiceParameter(svc, "rrd-repository");
        if (rrdRepository == null) {
            return;
        }
        String rrdDir = rrdRepository + File.separatorChar + "distributed" + File.separatorChar + locationMonitor + File.separator + monSvc.getIpAddress();
        try {
            RrdUtils.initialize();
            File rrdFile = new File(rrdDir, dsName);
            if (!rrdFile.exists()) {
                RrdUtils.createRRD((String)locationMonitor, (String)rrdDir, (String)dsName, (int)this.getStep(pkg), (String)"GAUGE", (int)600, (String)"U", (String)"U", (List)this.getRRAList(pkg));
            }
            RrdUtils.updateRRD((String)locationMonitor, (String)rrdDir, (String)dsName, (long)System.currentTimeMillis(), (String)String.valueOf(responseTime));
        }
        catch (RrdException e) {
            throw new PermissionDeniedDataAccessException("Unable to store rrdData from " + locationMonitor + " for service " + monSvc, (Throwable)e);
        }
    }

    private String getServiceParameter(Service svc, String key) {
        Enumeration parms = svc.enumerateParameter();
        while (parms.hasMoreElements()) {
            Parameter parm = (Parameter)parms.nextElement();
            if (!key.equals(parm.getKey())) continue;
            if (parm.getValue() != null) {
                return parm.getValue();
            }
            if (parm.getAnyObject() == null) continue;
            return parm.getAnyObject().toString();
        }
        return null;
    }
}

