/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.config.NotificationManager;

public class NotificationFactory
extends NotificationManager {
    private static NotificationFactory instance;
    protected File m_notifConfFile;
    private static boolean initialized;
    private File m_noticeConfFile;
    private long m_lastModified;

    private NotificationFactory() {
        super(NotifdConfigFactory.getInstance(), DataSourceFactory.getInstance());
    }

    public static synchronized NotificationFactory getInstance() {
        if (!initialized) {
            return null;
        }
        return instance;
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException, ClassNotFoundException, SQLException, PropertyVetoException {
        if (!initialized) {
            DataSourceFactory.init();
            instance = new NotificationFactory();
            instance.reload();
            initialized = true;
        }
    }

    public synchronized void reload() throws IOException, MarshalException, ValidationException {
        this.m_noticeConfFile = ConfigFileConstants.getFile((int)ConfigFileConstants.NOTIFICATIONS_CONF_FILE_NAME);
        FileInputStream configIn = new FileInputStream(this.m_noticeConfFile);
        this.m_lastModified = this.m_noticeConfFile.lastModified();
        InputStreamReader reader = new InputStreamReader(configIn);
        this.parseXML(reader);
    }

    protected void saveXML(String xmlString) throws IOException {
        if (xmlString != null) {
            FileWriter fileWriter = new FileWriter(this.m_noticeConfFile);
            fileWriter.write(xmlString);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    protected void update() throws IOException, MarshalException, ValidationException {
        if (this.m_lastModified != this.m_noticeConfFile.lastModified()) {
            this.reload();
        }
    }

    static {
        initialized = false;
    }
}

