/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.linkd.ExcludeRange;
import org.opennms.netmgt.config.linkd.IncludeRange;
import org.opennms.netmgt.config.linkd.LinkdConfiguration;
import org.opennms.netmgt.config.linkd.Vendor;
import org.opennms.netmgt.linkd.LinkableNode;
import org.opennms.netmgt.linkd.SnmpCollection;
import org.opennms.protocols.snmp.SnmpObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkdConfigFactory {
    private static LinkdConfigFactory instance;
    protected static LinkdConfiguration m_linkdconfiguration;
    protected static InputStream configIn;
    private static boolean initialized;
    private static File m_linkdConfFile;
    private static HashMap<String, LinkableNode> snmpprimaryip2nodes;
    private static HashMap<String, SnmpCollection> snmpprimaryip2colls;
    private static HashMap<String, String> oidMask2className;
    private static boolean classNameLoaded;
    private static boolean hashLoaded;
    private static final String SQL_SELECT_SNMP_NODES = "SELECT node.nodeid, nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND issnmpprimary = 'P'";
    private static final String SQL_UPDATE_ATINTERFACE_D = "UPDATE atinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ";
    private static final String SQL_UPDATE_STPNODE_D = "UPDATE stpnode set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_STPINTERFACE_D = "UPDATE stpinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_IPROUTEINTERFACE_D = "UPDATE iprouteinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'";
    private static final String SQL_UPDATE_DATALINKINTERFACE_D = "UPDATE datalinkinterface set status = 'D' WHERE (nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) OR nodeparentid IN (SELECT nodeid from node WHERE nodetype = 'D' )) AND status <> 'D'";

    private LinkdConfigFactory() {
    }

    public static synchronized LinkdConfigFactory getInstance() {
        if (!initialized) {
            return null;
        }
        if (instance == null) {
            instance = new LinkdConfigFactory();
        }
        return instance;
    }

    public static synchronized void init() throws IOException, FileNotFoundException, MarshalException, ValidationException, ClassNotFoundException {
        snmpprimaryip2nodes = new HashMap();
        snmpprimaryip2colls = new HashMap();
        oidMask2className = new HashMap();
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
        ThreadCategory.getInstance(LinkdConfigFactory.class).debug((Object)("init: config file path: " + cfgFile.getPath()));
        if (!initialized) {
            LinkdConfigFactory.reload();
            initialized = true;
        }
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_linkdConfFile = ConfigFileConstants.getFile((int)ConfigFileConstants.LINKD_CONFIG_FILE_NAME);
        FileInputStream configIn = new FileInputStream(m_linkdConfFile);
        m_linkdconfiguration = (LinkdConfiguration)Unmarshaller.unmarshal(LinkdConfiguration.class, (Reader)new InputStreamReader(configIn));
    }

    public long getInitialSleepTime() throws IOException, MarshalException, ValidationException {
        LinkdConfigFactory.updateFromFile();
        long initialSleepTime = 1800000L;
        if (m_linkdconfiguration.hasInitial_sleep_time()) {
            initialSleepTime = m_linkdconfiguration.getInitial_sleep_time();
        }
        return initialSleepTime;
    }

    public long getSnmpPollInterval() throws IOException, MarshalException, ValidationException {
        LinkdConfigFactory.updateFromFile();
        long snmppollinterval = 900000L;
        if (m_linkdconfiguration.hasSnmp_poll_interval()) {
            snmppollinterval = m_linkdconfiguration.getSnmp_poll_interval();
        }
        return snmppollinterval;
    }

    public long getDiscoveryLinkInterval() throws IOException, MarshalException, ValidationException {
        LinkdConfigFactory.updateFromFile();
        long discoverylinkinterval = 3600000L;
        if (m_linkdconfiguration.hasSnmp_poll_interval()) {
            discoverylinkinterval = m_linkdconfiguration.getDiscovery_link_interval();
        }
        return discoverylinkinterval;
    }

    public int getThreads() throws IOException, MarshalException, ValidationException {
        LinkdConfigFactory.updateFromFile();
        int threads = 5;
        if (m_linkdconfiguration.hasThreads()) {
            threads = m_linkdconfiguration.getThreads();
        }
        return threads;
    }

    public boolean autoDiscovery() throws IOException, MarshalException, ValidationException {
        LinkdConfigFactory.updateFromFile();
        boolean autodiscovery = true;
        if (m_linkdconfiguration.hasAutoDiscovery()) {
            autodiscovery = m_linkdconfiguration.getAutoDiscovery();
        }
        return autodiscovery;
    }

    private boolean enableVlanDiscovery() throws IOException, MarshalException, ValidationException {
        LinkdConfigFactory.updateFromFile();
        boolean vlandiscovery = true;
        if (m_linkdconfiguration.hasEnableVlanDiscovery()) {
            vlandiscovery = m_linkdconfiguration.getEnableVlanDiscovery();
        }
        return vlandiscovery;
    }

    public HashMap<String, SnmpCollection> getSnmpColls(Connection dbConn) throws SQLException, UnknownHostException {
        if (!hashLoaded) {
            this.getNodesInfo(dbConn);
        }
        return snmpprimaryip2colls;
    }

    public HashMap<String, LinkableNode> getLinkableNodes(Connection dbConn) throws SQLException, UnknownHostException {
        if (!hashLoaded) {
            this.getNodesInfo(dbConn);
        }
        return snmpprimaryip2nodes;
    }

    public synchronized void saveCurrent() throws MarshalException, ValidationException, IOException, ClassNotFoundException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)m_linkdconfiguration, (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            FileWriter fileWriter = new FileWriter(m_linkdConfFile);
            fileWriter.write(stringWriter.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        LinkdConfigFactory.reload();
    }

    private static void updateFromFile() throws IOException, MarshalException, ValidationException {
        LinkdConfigFactory.reload();
    }

    private void getClassNames() throws IOException, MarshalException, ValidationException {
        Category log = ThreadCategory.getInstance(LinkdConfigFactory.class);
        if (classNameLoaded) {
            return;
        }
        LinkdConfigFactory.updateFromFile();
        oidMask2className.clear();
        ArrayList<String> excludedOids = new ArrayList<String>();
        Vendor[] vendors = m_linkdconfiguration.getVlans().getVendor();
        for (int i = 0; i < vendors.length; ++i) {
            SnmpObjectId curRootSysOid = new SnmpObjectId(vendors[i].getSysoidRootMask());
            String curClassName = vendors[i].getClassName();
            String[] specifics = vendors[i].getSpecific();
            for (int js = 0; js < specifics.length; ++js) {
                SnmpObjectId oidMask = new SnmpObjectId(specifics[js]);
                oidMask.prepend(curRootSysOid);
                oidMask2className.put(oidMask.toString(), curClassName);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("getClassNames:  adding class " + curClassName + " for oid " + oidMask.toString()));
            }
            ExcludeRange[] excludeds = vendors[i].getExcludeRange();
            for (int je = 0; je < excludeds.length; ++je) {
                SnmpObjectId snmpBeginOid = new SnmpObjectId(excludeds[je].getBegin());
                SnmpObjectId snmpEndOid = new SnmpObjectId(excludeds[je].getEnd());
                SnmpObjectId snmpRootOid = this.getRootOid(snmpBeginOid);
                if (snmpBeginOid.getLength() != snmpEndOid.getLength() || !snmpRootOid.isRootOf(snmpEndOid)) continue;
                SnmpObjectId snmpCurOid = new SnmpObjectId(snmpBeginOid);
                while (snmpCurOid.compare(snmpEndOid) <= 0) {
                    excludedOids.add(snmpCurOid.toString());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getClassNames:  signing excluded class " + curClassName + " for oid " + curRootSysOid.toString().concat(snmpCurOid.toString())));
                    }
                    int lastCurCipher = snmpCurOid.getLastIdentifier();
                    int[] identifiers = snmpCurOid.getIdentifiers();
                    identifiers[identifiers.length - 1] = ++lastCurCipher;
                    snmpCurOid.setIdentifiers(identifiers);
                }
            }
            IncludeRange[] includeds = vendors[i].getIncludeRange();
            for (int ji = 0; ji < includeds.length; ++ji) {
                SnmpObjectId snmpBeginOid = new SnmpObjectId(includeds[ji].getBegin());
                SnmpObjectId snmpEndOid = new SnmpObjectId(includeds[ji].getEnd());
                SnmpObjectId rootOid = this.getRootOid(snmpBeginOid);
                if (snmpBeginOid.getLength() != snmpEndOid.getLength() || !rootOid.isRootOf(snmpEndOid)) continue;
                SnmpObjectId snmpCurOid = new SnmpObjectId(snmpBeginOid);
                while (snmpCurOid.compare(snmpEndOid) <= 0) {
                    if (!excludedOids.contains(snmpBeginOid.toString())) {
                        SnmpObjectId oidMask = new SnmpObjectId(snmpBeginOid);
                        oidMask.prepend(curRootSysOid);
                        oidMask2className.put(oidMask.toString(), curClassName);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("getClassNames:  adding class " + curClassName + " for oid " + oidMask.toString()));
                        }
                    }
                    int lastCipher = snmpBeginOid.getLastIdentifier();
                    int[] identifiers = snmpBeginOid.getIdentifiers();
                    identifiers[identifiers.length - 1] = ++lastCipher;
                    snmpCurOid.setIdentifiers(identifiers);
                }
            }
        }
        classNameLoaded = true;
    }

    private void getNodesInfo(Connection dbConn) throws SQLException, UnknownHostException {
        Category log = ThreadCategory.getInstance(LinkdConfigFactory.class);
        snmpprimaryip2nodes.clear();
        snmpprimaryip2colls.clear();
        try {
            if (!classNameLoaded) {
                this.getClassNames();
            }
        }
        catch (Throwable t) {
            log.error((Object)("getNodesInfo: cannot find vlan hash class " + t));
        }
        PreparedStatement ps = dbConn.prepareStatement(SQL_SELECT_SNMP_NODES);
        ResultSet rs = ps.executeQuery();
        if (log.isDebugEnabled()) {
            log.debug((Object)"getNodesInfo: execute query: \" SELECT node.nodeid, nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE nodetype = 'A' AND issnmpprimary = 'P'\"");
        }
        while (rs.next()) {
            int nodeid = rs.getInt("nodeid");
            String ipaddr = rs.getString("ipaddr");
            String sysoid = rs.getString("nodesysoid");
            if (sysoid == null) {
                sysoid = "-1";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("getNodesInfo: found node element: nodeid " + nodeid + " ipaddr " + ipaddr + " sysoid " + sysoid));
            }
            LinkableNode node = new LinkableNode(nodeid, ipaddr);
            snmpprimaryip2nodes.put(ipaddr, node);
            SnmpCollection coll = new SnmpCollection(SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName(ipaddr)));
            try {
                if (this.enableVlanDiscovery() && this.hasClassName(sysoid)) {
                    coll.setVlanClass(this.getClassName(sysoid));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("getNodesInfo: found class to get Vlans: " + coll.getVlanClass()));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"getNodesInfo: no class found to get Vlans or VlanDiscoveryDisabled ");
                }
            }
            catch (Throwable t) {
                log.error((Object)("getNodesInfo: Failed to load vlan classes from linkd configuration file " + t));
            }
            snmpprimaryip2colls.put(ipaddr, coll);
        }
        rs.close();
        ps.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("getNodesInfo: found " + snmpprimaryip2nodes.size() + " snmp primary ip nodes"));
        }
        hashLoaded = true;
    }

    public SnmpCollection getSnmpCollection(Connection dbConn, int nodeid) throws SQLException, UnknownHostException {
        Category log = ThreadCategory.getInstance(this.getClass());
        try {
            if (!classNameLoaded) {
                this.getClassNames();
            }
        }
        catch (Throwable t) {
            log.error((Object)("getSnmpCollection: cannot find vlan hash class " + t));
        }
        SnmpCollection coll = null;
        String SQL_SELECT_SNMP_NODE = "SELECT nodesysoid, ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE node.nodeid = ? AND nodetype = 'A' AND issnmpprimary = 'P'";
        PreparedStatement stmt = dbConn.prepareStatement(SQL_SELECT_SNMP_NODE);
        stmt.setInt(1, nodeid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSnmpCollection: execute '" + SQL_SELECT_SNMP_NODE + "' with nodeid =" + nodeid));
        }
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            String sysoid = rs.getString("nodesysoid");
            if (sysoid == null) {
                sysoid = "-1";
            }
            String ipaddr = rs.getString("ipaddr");
            if (log.isDebugEnabled()) {
                log.debug((Object)("getSnmpCollection: found nodeid " + nodeid + " ipaddr " + ipaddr + " sysoid " + sysoid));
            }
            coll = new SnmpCollection(SnmpPeerFactory.getInstance().getAgentConfig(InetAddress.getByName(ipaddr)));
            try {
                if (this.enableVlanDiscovery() && this.hasClassName(sysoid)) {
                    coll.setVlanClass(this.getClassName(sysoid));
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("getSnmpCollection: found class to get Vlans: " + coll.getVlanClass()));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"getSnmpCollection: no class found to get Vlans");
            }
            catch (Throwable t) {
                log.error((Object)("getSnmpCollection: Failed to load vlan classes from linkd configuration file " + t));
            }
        }
        rs.close();
        stmt.close();
        return coll;
    }

    public InetAddress getSnmpPrimaryIp(Connection dbConn, int nodeid) throws SQLException, UnknownHostException {
        Category log = ThreadCategory.getInstance(this.getClass());
        String SQL_SELECT_SNMP_NODE = "SELECT ipaddr FROM node LEFT JOIN ipinterface ON node.nodeid = ipinterface.nodeid WHERE node.nodeid = ? AND issnmpprimary = 'P'";
        String ipaddr = null;
        PreparedStatement stmt = dbConn.prepareStatement(SQL_SELECT_SNMP_NODE);
        stmt.setInt(1, nodeid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getSnmpPrimaryIp: SQL statement = " + stmt.toString()));
        }
        ResultSet rs = stmt.executeQuery();
        while (rs.next()) {
            ipaddr = rs.getString("ipaddr");
            if (ipaddr == null) {
                return null;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("getSnmpPrimaryIp: found node element: nodeid " + nodeid + " ipaddr " + ipaddr));
        }
        rs.close();
        stmt.close();
        return InetAddress.getByName(ipaddr);
    }

    public void updateDeletedNodes(Connection dbConn) throws SQLException {
        Category log = ThreadCategory.getInstance(LinkdConfigFactory.class);
        int i = 0;
        PreparedStatement ps = dbConn.prepareStatement(SQL_UPDATE_ATINTERFACE_D);
        i = ps.executeUpdate();
        if (log.isInfoEnabled()) {
            log.info((Object)("updateDeletedNodes: execute 'UPDATE atinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D' ' updated rows: " + i));
        }
        ps = dbConn.prepareStatement(SQL_UPDATE_STPNODE_D);
        i = ps.executeUpdate();
        if (log.isInfoEnabled()) {
            log.info((Object)("updateDeletedNodes: execute 'UPDATE stpnode set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'' updated rows: " + i));
        }
        ps = dbConn.prepareStatement(SQL_UPDATE_STPINTERFACE_D);
        i = ps.executeUpdate();
        if (log.isInfoEnabled()) {
            log.info((Object)("updateDeletedNodes: execute 'UPDATE stpinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D'' updated rows: " + i));
        }
        ps = dbConn.prepareStatement(SQL_UPDATE_IPROUTEINTERFACE_D);
        i = ps.executeUpdate();
        if (log.isInfoEnabled()) {
            log.info((Object)("updateDeletedNodes: execute 'UPDATE iprouteinterface set status = 'D' WHERE nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) AND status <> 'D''updated rows: " + i));
        }
        ps = dbConn.prepareStatement(SQL_UPDATE_DATALINKINTERFACE_D);
        i = ps.executeUpdate();
        if (log.isInfoEnabled()) {
            log.info((Object)("updateDeletedNodes: execute 'UPDATE datalinkinterface set status = 'D' WHERE (nodeid IN (SELECT nodeid from node WHERE nodetype = 'D' ) OR nodeparentid IN (SELECT nodeid from node WHERE nodetype = 'D' )) AND status <> 'D'' updated rows: " + i));
        }
    }

    private String getClassName(String sysoid) {
        String defaultClassName = null;
        Set<String> ks = oidMask2className.keySet();
        for (String oidMask : ks) {
            if (!sysoid.startsWith(oidMask)) continue;
            return oidMask2className.get(oidMask);
        }
        return defaultClassName;
    }

    private boolean hasClassName(String sysoid) {
        Set<String> ks = oidMask2className.keySet();
        for (String oidMask : ks) {
            if (!sysoid.startsWith(oidMask)) continue;
            return true;
        }
        return false;
    }

    private SnmpObjectId getRootOid(SnmpObjectId snmpObj) {
        int[] identifiers = snmpObj.getIdentifiers();
        int[] rootIdentifiers = new int[identifiers.length - 1];
        for (int i = 0; i < identifiers.length - 1; ++i) {
            rootIdentifiers[i] = identifiers[i];
        }
        return new SnmpObjectId(rootIdentifiers);
    }

    static {
        initialized = false;
        classNameLoaded = false;
        hashLoaded = false;
    }
}

