/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.xml.eventconf.Event;
import org.opennms.netmgt.xml.eventconf.Events;
import org.opennms.netmgt.xml.eventconf.Global;
import org.opennms.netmgt.xml.eventconf.Mask;

public class EventconfFactory {
    private static EventconfFactory instance;
    private static List m_events;
    private static Global m_global;
    private static boolean initialized;

    private EventconfFactory() {
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (!initialized) {
            EventconfFactory.reload();
            initialized = true;
        }
    }

    public static synchronized EventconfFactory getInstance() {
        if (!initialized) {
            return null;
        }
        if (instance == null) {
            instance = new EventconfFactory();
        }
        return instance;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.EVENT_CONF_FILE_NAME);
        FileInputStream configIn = new FileInputStream(cfgFile);
        Events events = (Events)Unmarshaller.unmarshal(Events.class, (Reader)new InputStreamReader(configIn));
        ArrayList eventList = events.getEventCollection();
        m_events = new ArrayList();
        Iterator i = eventList.iterator();
        while (i.hasNext()) {
            m_events.add((Event)i.next());
        }
        Enumeration e = events.enumerateEventFile();
        while (e.hasMoreElements()) {
            String eventfile = (String)e.nextElement();
            FileInputStream fileIn = new FileInputStream(eventfile);
            if (fileIn == null) {
                throw new IOException("Eventconf: Failed to load/locate events file: " + eventfile);
            }
            InputStreamReader filerdr = new InputStreamReader(fileIn);
            Events filelevel = null;
            filelevel = (Events)Unmarshaller.unmarshal(Events.class, (Reader)filerdr);
            Enumeration efile = filelevel.enumerateEvent();
            while (efile.hasMoreElements()) {
                Event event = (Event)efile.nextElement();
                m_events.add(event);
            }
        }
        m_global = events.getGlobal();
        initialized = true;
    }

    public List getEvents(String uei) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (int i = 0; i < m_events.size(); ++i) {
            Event curEvent = (Event)m_events.get(i);
            if (!curEvent.getUei().equals(uei)) continue;
            events.add(curEvent);
        }
        if (events.size() > 0) {
            return events;
        }
        return null;
    }

    public Event getEvent(String uei, Mask mask) {
        List ueiMatches = this.getEvents(uei);
        Event curEvent = null;
        for (int i = 0; i < ueiMatches.size(); ++i) {
        }
        return curEvent;
    }

    public List getEventUEIs() {
        ArrayList<String> eventUEIs = new ArrayList<String>();
        for (int i = 0; i < m_events.size(); ++i) {
            Event curEvent = (Event)m_events.get(i);
            eventUEIs.add(curEvent.getUei());
        }
        return eventUEIs;
    }

    public Map getEventLabels() {
        TreeMap<String, String> eventLabels = new TreeMap<String, String>();
        for (int i = 0; i < m_events.size(); ++i) {
            Event curEvent = (Event)m_events.get(i);
            eventLabels.put(curEvent.getUei(), curEvent.getEventLabel());
        }
        return eventLabels;
    }

    public String getEventLabel(String uei) {
        System.out.println("looking for " + uei);
        for (int i = 0; i < m_events.size(); ++i) {
            Event curEvent = (Event)m_events.get(i);
            if (!curEvent.getUei().equals(uei)) continue;
            System.out.println("returning " + curEvent.getEventLabel());
            return curEvent.getEventLabel();
        }
        return "No label found for " + uei;
    }

    public synchronized void saveEvents(Collection eventsList) throws MarshalException, IOException, ValidationException {
        for (Event current : eventsList) {
            this.removeEvent(current.getUei(), current.getMask());
        }
        m_events.addAll(eventsList);
        this.saveCurrent();
    }

    public synchronized void removeEvents(String uei) throws MarshalException, ValidationException, IOException {
        List events = this.getEvents(uei);
        if (events == null) {
            return;
        }
        if (m_events.removeAll(events)) {
            // empty if block
        }
        this.saveCurrent();
    }

    public synchronized void removeEvent(String uei, Mask mask) throws MarshalException, IOException, ValidationException {
        List events = this.getEvents(uei);
        if (events == null) {
            return;
        }
        for (Event current : events) {
            if (current.getMask() != mask) continue;
            if (m_events.remove(current)) {
                // empty if block
            }
            this.saveCurrent();
            return;
        }
    }

    public synchronized void saveCurrent() throws MarshalException, IOException, ValidationException {
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.EVENT_CONF_FILE_NAME);
        Events newEvents = new Events();
        newEvents.setEventCollection(new ArrayList(m_events));
        newEvents.setGlobal(m_global);
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)newEvents, (Writer)stringWriter);
        if (stringWriter.toString() != null) {
            FileWriter fileWriter = new FileWriter(cfgFile);
            fileWriter.write(stringWriter.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        EventconfFactory.reload();
    }

    public List getEventsByLabel() {
        ArrayList list = new ArrayList(m_events);
        Collections.sort(list, new EventLabelComparator());
        return list;
    }

    static {
        initialized = false;
    }

    private static class EventLabelComparator
    implements Comparator {
        private EventLabelComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Event)o1).getEventLabel().compareToIgnoreCase(((Event)o2).getEventLabel());
        }
    }
}

