/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;

public final class DiscoveryConfigFactory {
    private static DiscoveryConfigFactory m_singleton = null;
    private DiscoveryConfiguration m_config;
    private static boolean m_loaded = false;

    private DiscoveryConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        this.m_config = (DiscoveryConfiguration)Unmarshaller.unmarshal(DiscoveryConfiguration.class, (Reader)new InputStreamReader(cfgIn));
        ((InputStream)cfgIn).close();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DISCOVERY_CONFIG_FILE_NAME);
        ThreadCategory.getInstance(DiscoveryConfigFactory.class).debug((Object)("init: config file path: " + cfgFile.getPath()));
        m_singleton = new DiscoveryConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        DiscoveryConfigFactory.init();
    }

    public static synchronized DiscoveryConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized DiscoveryConfiguration getConfiguration() {
        return this.m_config;
    }
}

