/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.IPSorter;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.capsd.Plugin;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.capsd.CapsdConfiguration;
import org.opennms.netmgt.config.capsd.IpManagement;
import org.opennms.netmgt.config.capsd.Property;
import org.opennms.netmgt.config.capsd.ProtocolConfiguration;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.capsd.SmbAuth;
import org.opennms.netmgt.config.capsd.SmbConfig;
import org.opennms.netmgt.config.common.Range;
import org.opennms.netmgt.config.poller.Package;

public abstract class CapsdConfigManager
implements CapsdConfig {
    private static final String COMMENT_STR = " #";
    private static final char COMMENT_CHAR = '#';
    private CapsdConfiguration m_config;
    private Map m_urlMap;
    static final String SQL_DB_RETRIEVE_IP_INTERFACE = "SELECT ip.nodeid, ip.ipaddr, ip.ismanaged FROM ipinterface as ip JOIN node as n ON ip.nodeid = n.nodeid WHERE ip.ipaddr!='0.0.0.0' AND ip.isManaged!='D' AND ip.isManaged!='F' AND n.foreignSource is null";
    static final String SQL_DB_RETRIEVE_IP_INTERFACE_IN_LOCAL_SERVER = "SELECT ip.nodeid, ip.ipaddr, ip.ismanaged FROM ipinterface as ip JOIN node as n ON n.nodeid = ip.nodeid JOIN servermap as s ON ip.ipaddr = s.ipaddr WHERE ip.ipaddr!='0.0.0.0' AND ip.isManaged!='D' AND ip.isManaged!='F' AND s.servername = ? AND n.foreignSource is null";
    private static String SQL_DB_RETRIEVE_SNMP_IP_INTERFACES = "SELECT DISTINCT ipinterface.nodeid,ipinterface.ipaddr,ipinterface.ifindex,ipinterface.issnmpprimary,snmpinterface.snmpiftype,snmpinterface.snmpifindex FROM ipinterface JOIN node ON node.nodeid = ipinterface.nodeid JOIN snmpinterface ON ipinterface.snmpinterfaceid = snmpinterface.id JOIN ifservices ON ifservices.ipinterfaceid = ipinterface.id JOIN service ON ifservices.serviceid = service.serviceid WHERE ipinterface.ismanaged!='D' AND ifservices.status != 'D' AND service.servicename='SNMP' AND node.foreignSource is null";
    private static String SQL_DB_UPDATE_SNMP_PRIMARY_STATE = "UPDATE ipinterface SET issnmpprimary=? WHERE nodeid=? AND ipaddr=? AND ismanaged!='D'";
    static final String SQL_DB_RETRIEVE_IF_SERVICES = "SELECT serviceid, status FROM ifservices WHERE nodeid=? AND ipaddr=? AND status!='D' AND status!='F'";
    static final String SQL_DB_UPDATE_IP_INTERFACE = "UPDATE ipinterface SET ismanaged=? WHERE nodeid=? AND ipaddr=? AND isManaged!='D' AND isManaged!='F'";
    static final String SQL_DB_UPDATE_ALL_SERVICES_FOR_NIP = "UPDATE ifservices SET status=? WHERE nodeid=? AND ipaddr=? AND status!='D' AND status!='F'";
    static final String SQL_DB_UPDATE_SERVICE_FOR_NIP = "UPDATE ifservices SET status=? WHERE nodeid=? AND ipaddr=? AND serviceid=? AND status!='D' AND status!='F'";
    private static final String RETRIEVE_IPADDR_SQL = "SELECT ip.ipaddr FROM ipinterface as ip JOIN node as n ON ip.nodeid = n.nodeid WHERE ip.ipaddr=? AND ip.ismanaged!='D'AND n.foreignSource is null";
    private static final String RETRIEVE_IPADDR_NODEID_SQL = "SELECT ip.nodeid FROM ipinterface as ip JOIN node as n ON ip.nodeid = n.nodeid WHERE ip.ipaddr=? AND ip.ismanaged!='D' AND n.foreignSource is null";
    private static final String SVCTBL_LOAD_SQL = "SELECT serviceID, serviceName FROM service";
    private static final String SVCTBL_ADD_SQL = "INSERT INTO service (serviceID, serviceName) VALUES (?,?)";
    private static final String NEXT_SVC_ID_SQL = "SELECT nextval('serviceNxtId')";
    private static String m_nextSvcIdSql;
    private static final String DELETE_IFSERVICES_SQL = "update ifservices    set status = 'D'  where serviceid = ?   and id in (   select svc.id     from ifservices as svc     join ipinterface as ip       on (ip.id = svc.ipinterfaceid)     join node as n       on (n.nodeid = ip.nodeid)    where n.foreignsource is null)";
    private static final Map m_serviceIds;
    private static final Map m_plugins;
    public static final Integer SCAN;
    public static final Integer SKIP;
    public static final Integer AUTO_SET;

    public CapsdConfigManager() {
    }

    public CapsdConfigManager(Reader rdr) throws MarshalException, ValidationException {
        this.loadXml(rdr);
    }

    protected abstract void saveXml(String var1) throws IOException;

    protected abstract void update() throws IOException, FileNotFoundException, MarshalException, ValidationException;

    protected void loadXml(Reader rdr) throws MarshalException, ValidationException {
        this.m_config = (CapsdConfiguration)Unmarshaller.unmarshal(CapsdConfiguration.class, (Reader)rdr);
        this.finishConstruction();
    }

    private void finishConstruction() {
        Enumeration eprotos = this.m_config.enumerateProtocolPlugin();
        while (eprotos.hasMoreElements()) {
            ProtocolPlugin plugin = (ProtocolPlugin)eprotos.nextElement();
            try {
                if (m_plugins.containsKey(plugin.getClassName())) {
                    Object oplugin = m_plugins.get(plugin.getClassName());
                    m_plugins.put(plugin.getProtocol(), oplugin);
                    continue;
                }
                Class<?> cplugin = Class.forName(plugin.getClassName());
                Object oplugin = cplugin.newInstance();
                m_plugins.put(plugin.getClassName(), oplugin);
                m_plugins.put(plugin.getProtocol(), oplugin);
            }
            catch (Throwable t) {
                this.log().error((Object)("CapsdConfigFactory: failed to load plugin for protocol " + plugin.getProtocol() + ", class-name = " + plugin.getClassName()), t);
            }
        }
        this.m_urlMap = new HashMap();
        Enumeration e = this.m_config.enumerateIpManagement();
        while (e.hasMoreElements()) {
            IpManagement mgt = (IpManagement)e.nextElement();
            Enumeration f = mgt.enumerateIncludeUrl();
            while (f.hasMoreElements()) {
                String url = f.nextElement().toString();
                if (this.m_urlMap.containsKey(url)) continue;
                this.m_urlMap.put(url, this.getAddressesFromURL(url));
            }
        }
        if (this.getNextSvcIdSql() == null) {
            this.setNextSvcIdSql(NEXT_SVC_ID_SQL);
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public synchronized void save() throws MarshalException, IOException, ValidationException {
        StringWriter stringWriter = new StringWriter();
        Marshaller.marshal((Object)this.m_config, (Writer)stringWriter);
        this.saveXml(stringWriter.toString());
        this.update();
    }

    public CapsdConfiguration getConfiguration() {
        return this.m_config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncServices(Connection conn) throws SQLException {
        Category log = ThreadCategory.getInstance();
        if (conn == null) {
            log.error((Object)"CapsdConfigFactory.syncServices: Sync failed...must have valid database connection.");
            return;
        }
        List serviceNames = this.syncServicesTable(conn);
        Statement delFromOutagesStmt = null;
        Statement delFromIfServicesStmt = null;
        try {
            List protocols = this.getConfiguredProtocols();
            for (String service : serviceNames) {
                if (protocols.contains(service)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("syncServices: service " + service + " exists in the database but not in the Capsd config file."));
                }
                Integer id = (Integer)m_serviceIds.get(service);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("syncServices: deleting all references to service id " + id + " from the IfServices table."));
                }
                delFromIfServicesStmt = conn.prepareStatement(DELETE_IFSERVICES_SQL);
                delFromIfServicesStmt.setInt(1, id);
                delFromIfServicesStmt.executeUpdate();
            }
        }
        finally {
            if (delFromOutagesStmt != null) {
                delFromOutagesStmt.close();
            }
            if (delFromIfServicesStmt != null) {
                delFromIfServicesStmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List syncServicesTable(Connection conn) throws SQLException {
        ArrayList<String> serviceNames;
        PreparedStatement insStmt = conn.prepareStatement(SVCTBL_ADD_SQL);
        PreparedStatement nxtStmt = conn.prepareStatement(this.getNextSvcIdSql());
        PreparedStatement loadStmt = conn.prepareStatement(SVCTBL_LOAD_SQL);
        try {
            serviceNames = new ArrayList<String>();
            ResultSet rs = loadStmt.executeQuery();
            while (rs.next()) {
                Integer id = new Integer(rs.getInt(1));
                String name = rs.getString(2);
                m_serviceIds.put(id, name);
                m_serviceIds.put(name, id);
                serviceNames.add(name);
            }
            rs.close();
            List protocols = this.getConfiguredProtocols();
            for (String protocol : protocols) {
                if (serviceNames.contains(protocol)) continue;
                int id = -1;
                rs = nxtStmt.executeQuery();
                rs.next();
                id = rs.getInt(1);
                rs.close();
                insStmt.setInt(1, id);
                insStmt.setString(2, protocol);
                insStmt.executeUpdate();
                Integer xid = new Integer(id);
                m_serviceIds.put(xid, protocol);
                m_serviceIds.put(protocol, xid);
                serviceNames.add(protocol);
            }
        }
        finally {
            if (insStmt != null) {
                insStmt.close();
            }
            if (nxtStmt != null) {
                nxtStmt.close();
            }
            if (loadStmt != null) {
                loadStmt.close();
            }
        }
        return serviceNames;
    }

    private List getConfiguredProtocols() {
        ArrayList<String> protocols = new ArrayList<String>();
        Enumeration eplugin = this.m_config.enumerateProtocolPlugin();
        while (eplugin.hasMoreElements()) {
            ProtocolPlugin plugin = (ProtocolPlugin)eplugin.nextElement();
            protocols.add(plugin.getProtocol());
        }
        return protocols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncManagementState(Connection conn) throws SQLException {
        boolean managed_by_default;
        Category log = ThreadCategory.getInstance();
        boolean verifyServer = OpennmsServerConfigFactory.getInstance().verifyServer();
        String localServer = OpennmsServerConfigFactory.getInstance().getServerName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("syncManagementState: local server: " + localServer + " verify server: " + verifyServer));
        }
        if (conn == null) {
            log.error((Object)"CapsdConfigFactory.syncManagementState: Sync failed...must have valid database connection.");
            return;
        }
        String temp = this.m_config.getManagementPolicy();
        boolean bl = managed_by_default = temp == null || temp.equalsIgnoreCase("managed");
        if (log.isDebugEnabled()) {
            log.debug((Object)("syncManagementState: managed_by_default: " + managed_by_default));
        }
        PreparedStatement ipRetStmt = null;
        if (verifyServer) {
            ipRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_IP_INTERFACE_IN_LOCAL_SERVER);
            ipRetStmt.setString(1, localServer);
        } else {
            ipRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_IP_INTERFACE);
        }
        ArrayList<LightWeightIfEntry> ifList = new ArrayList<LightWeightIfEntry>();
        ResultSet result = null;
        try {
            result = ipRetStmt.executeQuery();
            while (result.next()) {
                int nodeId = result.getInt(1);
                String address = result.getString(2);
                if (address == null) {
                    log.warn((Object)"invalid ipInterface table entry, no IP address, skipping...");
                    continue;
                }
                char managedState = ' ';
                String str = result.getString(3);
                if (str != null) {
                    managedState = str.charAt(0);
                }
                ifList.add(new LightWeightIfEntry(nodeId, -1, address, managedState, ' ', -1));
            }
        }
        finally {
            result.close();
            ipRetStmt.close();
        }
        PreparedStatement ifUpdateStmt = conn.prepareStatement(SQL_DB_UPDATE_IP_INTERFACE);
        PreparedStatement allSvcUpdateStmt = conn.prepareStatement(SQL_DB_UPDATE_ALL_SERVICES_FOR_NIP);
        PreparedStatement svcRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_IF_SERVICES);
        PreparedStatement svcUpdateStmt = conn.prepareStatement(SQL_DB_UPDATE_SERVICE_FOR_NIP);
        PollerConfig pollerCfgFactory = PollerConfigFactory.getInstance();
        try {
            for (LightWeightIfEntry ifEntry : ifList) {
                String ipaddress = ifEntry.getAddress();
                InetAddress ifAddress = null;
                try {
                    ifAddress = InetAddress.getByName(ipaddress);
                }
                catch (UnknownHostException uhE) {
                    log.warn((Object)("Failed converting ip address " + ipaddress + " to InetAddress."));
                    continue;
                }
                boolean address_is_unmanaged = this.isAddressUnmanaged(ifAddress);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("syncManagementState: " + ipaddress + " unmanaged based on capsd config?: " + address_is_unmanaged));
                }
                if (address_is_unmanaged) {
                    if (ifEntry.getManagementState() == 'U') continue;
                    ifUpdateStmt.setString(1, new String(new char[]{'U'}));
                    ifUpdateStmt.setInt(2, ifEntry.getNodeId());
                    ifUpdateStmt.setString(3, ipaddress);
                    ifUpdateStmt.executeUpdate();
                    allSvcUpdateStmt.setString(1, new String(new char[]{'U'}));
                    allSvcUpdateStmt.setInt(2, ifEntry.getNodeId());
                    allSvcUpdateStmt.setString(3, ipaddress);
                    allSvcUpdateStmt.executeUpdate();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("syncManagementState: update completed for node/interface: " + ifEntry.getNodeId() + "/" + ipaddress + " to unmanaged"));
                    continue;
                }
                Package ipPkg = pollerCfgFactory.getFirstPackageMatch(ipaddress);
                boolean ipToBePolled = false;
                if (ipPkg != null) {
                    ipToBePolled = true;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("syncManagementState: " + ipaddress + " to be polled based on poller config?: " + ipToBePolled));
                }
                if (ifEntry.getManagementState() == 'M' && ipToBePolled || ifEntry.getManagementState() == 'N' && !ipToBePolled) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("syncManagementState: " + ipaddress + " - no change in status"));
                    }
                } else {
                    if (ipToBePolled) {
                        ifUpdateStmt.setString(1, new String(new char[]{'M'}));
                    } else {
                        ifUpdateStmt.setString(1, new String(new char[]{'N'}));
                    }
                    ifUpdateStmt.setInt(2, ifEntry.getNodeId());
                    ifUpdateStmt.setString(3, ipaddress);
                    ifUpdateStmt.executeUpdate();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("syncManagementState: update completed for node/interface: " + ifEntry.getNodeId() + "/" + ipaddress));
                    }
                }
                svcRetStmt.setInt(1, ifEntry.getNodeId());
                svcRetStmt.setString(2, ipaddress);
                ResultSet svcRS = svcRetStmt.executeQuery();
                while (svcRS.next()) {
                    int svcId = svcRS.getInt(1);
                    char svcStatus = ' ';
                    String str = svcRS.getString(2);
                    if (str != null) {
                        svcStatus = str.charAt(0);
                    }
                    String svcName = (String)this.getServiceIdentifier(new Integer(svcId));
                    boolean svcToBePolled = false;
                    char oldStatus = svcStatus;
                    char newStatus = 'U';
                    if (ipPkg != null && !(svcToBePolled = pollerCfgFactory.isPolled(svcName, ipPkg))) {
                        svcToBePolled = pollerCfgFactory.isPolled(ipaddress, svcName);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("syncManagementState: " + ipaddress + "/" + svcName + " to be polled based on poller config?: " + svcToBePolled));
                    }
                    if (svcStatus == 'A' && svcToBePolled || svcStatus == 'N' && !ipToBePolled) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("syncManagementState: " + ifEntry.getNodeId() + "/" + ipaddress + "/" + svcName + " status = " + svcStatus + " - no change in status"));
                        continue;
                    }
                    if (svcStatus == 'S' && svcToBePolled) {
                        svcUpdateStmt.setString(1, new String(new char[]{'F'}));
                        newStatus = 'F';
                    } else if (svcToBePolled) {
                        svcUpdateStmt.setString(1, new String(new char[]{'A'}));
                        newStatus = 'A';
                    } else {
                        svcUpdateStmt.setString(1, new String(new char[]{'N'}));
                        newStatus = 'N';
                    }
                    svcUpdateStmt.setInt(2, ifEntry.getNodeId());
                    svcUpdateStmt.setString(3, ipaddress);
                    svcUpdateStmt.setInt(4, svcId);
                    svcUpdateStmt.executeUpdate();
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("syncManagementState: update completed for node/interface/svc: " + ifEntry.getNodeId() + "/" + ipaddress + "/" + svcName + " status changed from " + oldStatus + " to " + newStatus));
                }
            }
        }
        finally {
            block42: {
                try {
                    ifUpdateStmt.close();
                    allSvcUpdateStmt.close();
                    svcRetStmt.close();
                    svcUpdateStmt.close();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block42;
                    log.debug((Object)"Exception while closing prepared statements", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void syncSnmpPrimaryState(Connection conn) throws SQLException {
        Category log = ThreadCategory.getInstance();
        if (conn == null) {
            throw new IllegalArgumentException("Sync failed...must have valid database connection.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"syncSnmpPrimaryState: building map of nodes to interfaces...");
        }
        HashMap nodes = new HashMap();
        PreparedStatement ipRetStmt = conn.prepareStatement(SQL_DB_RETRIEVE_SNMP_IP_INTERFACES);
        ResultSet result = null;
        try {
            result = ipRetStmt.executeQuery();
            List<LightWeightIfEntry> ifList = new ArrayList();
            while (result.next()) {
                int nodeId = result.getInt(1);
                String address = result.getString(2);
                if (address == null) {
                    log.warn((Object)"invalid ipInterface table entry, no IP address, skipping...");
                    continue;
                }
                int ifIndex = result.getInt(6);
                if (result.wasNull()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("ipInterface table entry for address " + address + " does not have a valid ifIndex "));
                    }
                    ifIndex = -1;
                } else if (ifIndex < 1) {
                    if (ifIndex == -100) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Using ifIndex = -100 for address " + address));
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("ipInterface table entry for address " + address + " does not have a valid ifIndex "));
                        }
                        ifIndex = -1;
                    }
                }
                char primarySnmpState = ' ';
                String str = result.getString(4);
                if (str != null) {
                    primarySnmpState = str.charAt(0);
                }
                int ifType = result.getInt(5);
                if (result.wasNull()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("snmpInterface table entry for address " + address + " does not have a valid ifType"));
                    }
                    ifType = -1;
                }
                if ((ifList = (List)nodes.get(new Integer(nodeId))) == null) {
                    ifList = new ArrayList();
                    ifList.add(new LightWeightIfEntry(nodeId, ifIndex, address, ' ', primarySnmpState, ifType));
                    nodes.put(new Integer(nodeId), ifList);
                    continue;
                }
                ifList.add(new LightWeightIfEntry(nodeId, ifIndex, address, ' ', primarySnmpState, ifType));
            }
        }
        finally {
            try {
                result.close();
                ipRetStmt.close();
            }
            catch (Exception e) {}
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("syncSnmpPrimaryState: iterating over nodes in map and checking primary SNMP interface, node count: " + nodes.size()));
        }
        for (Integer nId : nodes.keySet()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("building SNMP address list for node " + nId));
            }
            List ifEntries = (List)nodes.get(nId);
            ArrayList<InetAddress> addressList = new ArrayList<InetAddress>();
            ArrayList<InetAddress> lbAddressList = new ArrayList<InetAddress>();
            for (LightWeightIfEntry lwIf : ifEntries) {
                if (lwIf.getIfIndex() == -1) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("skipping address " + lwIf.getAddress() + ": does not have a valid ifIndex."));
                    continue;
                }
                try {
                    InetAddress addr = InetAddress.getByName(lwIf.getAddress());
                    addressList.add(addr);
                    if (lwIf.getIfType() != 24) continue;
                    lbAddressList.add(addr);
                }
                catch (UnknownHostException uhe) {
                    log.warn((Object)("Unknown host exception for " + lwIf.getAddress()), (Throwable)uhe);
                }
            }
            boolean strict = true;
            InetAddress primarySnmpIf = null;
            String psiType = null;
            if (lbAddressList != null) {
                primarySnmpIf = this.determinePrimarySnmpInterface(lbAddressList, strict);
                psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " loopback addresses";
            }
            if (primarySnmpIf == null) {
                primarySnmpIf = this.determinePrimarySnmpInterface(addressList, strict);
                psiType = ConfigFileConstants.getFileName((int)ConfigFileConstants.COLLECTD_CONFIG_FILE_NAME) + " addresses";
            }
            strict = false;
            if (primarySnmpIf == null && lbAddressList != null) {
                primarySnmpIf = this.determinePrimarySnmpInterface(lbAddressList, strict);
                psiType = "DB loopback addresses";
            }
            if (primarySnmpIf == null) {
                primarySnmpIf = this.determinePrimarySnmpInterface(addressList, strict);
                psiType = "DB addresses";
            }
            if (log.isDebugEnabled()) {
                if (primarySnmpIf == null) {
                    log.debug((Object)("syncSnmpPrimaryState: No primary SNMP interface found for node " + nId));
                } else {
                    log.debug((Object)("syncSnmpPrimaryState: primary SNMP interface for node " + nId + " is: " + primarySnmpIf + ", selected from " + psiType));
                }
            }
            for (LightWeightIfEntry lwIf : ifEntries) {
                if (lwIf.getIfIndex() == -1) {
                    lwIf.setSnmpPrimaryState('N');
                } else if (primarySnmpIf == null || !lwIf.getAddress().equals(primarySnmpIf.getHostAddress())) {
                    if (CollectdConfigFactory.getInstance().isServiceCollectionEnabled(lwIf.getAddress(), "SNMP")) {
                        lwIf.setSnmpPrimaryState('S');
                    } else {
                        lwIf.setSnmpPrimaryState('N');
                    }
                } else {
                    lwIf.setSnmpPrimaryState('P');
                }
                if (!lwIf.hasSnmpPrimaryStateChanged()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("syncSnmpPrimaryState: updating " + lwIf.getNodeId() + "/" + lwIf.getAddress() + ", marking with state: " + lwIf.getSnmpPrimaryState()));
                }
                PreparedStatement updateStmt = conn.prepareStatement(SQL_DB_UPDATE_SNMP_PRIMARY_STATE);
                updateStmt.setString(1, new String(new char[]{lwIf.getSnmpPrimaryState()}));
                updateStmt.setInt(2, lwIf.getNodeId());
                updateStmt.setString(3, lwIf.getAddress());
                try {
                    updateStmt.executeUpdate();
                }
                finally {
                    try {
                        updateStmt.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"syncSnmpPrimaryState: sync completed.");
        }
    }

    public ProtocolInfo[] getProtocolSpecification(InetAddress address) {
        Category log = ThreadCategory.getInstance(CapsdConfigFactory.class);
        ArrayList<ProtocolInfo> lprotos = new ArrayList<ProtocolInfo>(this.m_config.getProtocolPluginCount());
        Enumeration eplugins = this.m_config.enumerateProtocolPlugin();
        block6: while (eplugins.hasMoreElements()) {
            ProtocolPlugin plugin = (ProtocolPlugin)eplugins.nextElement();
            boolean found = false;
            Enumeration epluginconf = plugin.enumerateProtocolConfiguration();
            while (epluginconf.hasMoreElements()) {
                Property p;
                ProtocolConfiguration pluginConf = (ProtocolConfiguration)epluginconf.nextElement();
                Enumeration espec = pluginConf.enumerateSpecific();
                while (espec.hasMoreElements() && !found) {
                    String saddr = (String)espec.nextElement();
                    try {
                        InetAddress taddr = InetAddress.getByName(saddr);
                        if (!taddr.equals(address)) continue;
                        found = true;
                    }
                    catch (UnknownHostException e) {
                        log.warn((Object)("CapsdConfigFactory: failed to convert address " + saddr + " to InetAddress"), (Throwable)e);
                    }
                }
                long laddr = IPSorter.convertToLong((byte[])address.getAddress());
                Enumeration erange = pluginConf.enumerateRange();
                while (erange.hasMoreElements() && !found) {
                    Range rng = (Range)erange.nextElement();
                    InetAddress start = null;
                    try {
                        start = InetAddress.getByName(rng.getBegin());
                    }
                    catch (UnknownHostException e) {
                        log.warn((Object)("CapsdConfigFactory: failed to convert address " + rng.getBegin() + " to InetAddress"), (Throwable)e);
                        continue;
                    }
                    InetAddress stop = null;
                    try {
                        stop = InetAddress.getByName(rng.getEnd());
                    }
                    catch (UnknownHostException e) {
                        log.warn((Object)("CapsdConfigFactory: failed to convert address " + rng.getEnd() + " to InetAddress"), (Throwable)e);
                        continue;
                    }
                    if (CapsdConfigManager.toLong(start) > laddr || laddr > CapsdConfigManager.toLong(stop)) continue;
                    found = true;
                }
                if (!found) continue;
                String scan = null;
                scan = pluginConf.getScan();
                if (scan != null) {
                    if (scan.equals("enable")) {
                        lprotos.add(new ProtocolInfo(plugin.getProtocol(), (Plugin)m_plugins.get(plugin.getProtocol()), null, AUTO_SET));
                        continue block6;
                    }
                    if (scan.equals("off")) {
                        continue block6;
                    }
                } else {
                    scan = plugin.getScan();
                    if (scan != null && scan.equals("off")) continue block6;
                }
                TreeMap<String, String> params = new TreeMap<String, String>();
                Enumeration eparams = plugin.enumerateProperty();
                while (eparams.hasMoreElements()) {
                    p = (Property)eparams.nextElement();
                    params.put(p.getKey(), p.getValue());
                }
                eparams = pluginConf.enumerateProperty();
                while (eparams.hasMoreElements()) {
                    p = (Property)eparams.nextElement();
                    params.put(p.getKey(), p.getValue());
                }
                lprotos.add(new ProtocolInfo(plugin.getProtocol(), (Plugin)m_plugins.get(plugin.getProtocol()), params, SCAN));
            }
            if (found) continue;
            String scan = null;
            scan = plugin.getScan();
            if (scan != null && scan.equals("off")) continue;
            TreeMap<String, String> params = new TreeMap<String, String>();
            Enumeration eparams = plugin.enumerateProperty();
            while (eparams.hasMoreElements()) {
                Property p = (Property)eparams.nextElement();
                params.put(p.getKey(), p.getValue());
            }
            lprotos.add(new ProtocolInfo(plugin.getProtocol(), (Plugin)m_plugins.get(plugin.getProtocol()), params, SCAN));
        }
        ProtocolInfo[] result = new ProtocolInfo[lprotos.size()];
        return lprotos.toArray(result);
    }

    public ProtocolPlugin getProtocolPlugin(String svcName) {
        Enumeration e = this.m_config.enumerateProtocolPlugin();
        while (e.hasMoreElements()) {
            ProtocolPlugin plugin = (ProtocolPlugin)e.nextElement();
            if (!plugin.getProtocol().equals(svcName)) continue;
            return plugin;
        }
        return null;
    }

    public void addProtocolPlugin(ProtocolPlugin plugin) {
        this.m_config.addProtocolPlugin(plugin);
    }

    public Object getServiceIdentifier(Object key) {
        return m_serviceIds.get(key);
    }

    public SmbAuth getSmbAuth(String target) {
        SmbConfig cfg = this.m_config.getSmbConfig();
        if (cfg != null) {
            Enumeration es = cfg.enumerateSmbAuth();
            while (es.hasMoreElements()) {
                SmbAuth a = (SmbAuth)es.nextElement();
                if (a.getContent() == null || !a.getContent().equalsIgnoreCase(target)) continue;
                return a;
            }
        }
        return null;
    }

    public boolean isAddressUnmanaged(InetAddress target) {
        boolean result;
        Category log = ThreadCategory.getInstance(CapsdConfigFactory.class);
        String temp = this.m_config.getManagementPolicy();
        boolean managed_by_default = temp == null || temp.equalsIgnoreCase("managed");
        boolean found_denial = false;
        boolean found_accept = false;
        Enumeration e = this.m_config.enumerateIpManagement();
        while (e.hasMoreElements() && !found_denial) {
            IpManagement mgt = (IpManagement)e.nextElement();
            Enumeration f = mgt.enumerateSpecific();
            while (f.hasMoreElements()) {
                String saddr = f.nextElement().toString();
                try {
                    InetAddress addr = InetAddress.getByName(saddr);
                    if (!addr.equals(target)) continue;
                    if (mgt.getPolicy() == null || mgt.getPolicy().equalsIgnoreCase("managed")) {
                        found_accept = true;
                        break;
                    }
                    found_denial = true;
                    break;
                }
                catch (UnknownHostException ex) {
                    log.info((Object)("Failed to convert management address " + saddr + " to an InetAddress"), (Throwable)ex);
                }
            }
            f = mgt.enumerateRange();
            while (!found_denial && f.hasMoreElements()) {
                Range rng = (Range)f.nextElement();
                try {
                    InetAddress saddr = InetAddress.getByName(rng.getBegin());
                    InetAddress eaddr = InetAddress.getByName(rng.getEnd());
                    long start = CapsdConfigManager.toLong(saddr);
                    long stop = CapsdConfigManager.toLong(eaddr);
                    long tgt = CapsdConfigManager.toLong(target);
                    if (start > tgt || tgt > stop) continue;
                    if (mgt.getPolicy() == null || mgt.getPolicy().equalsIgnoreCase("managed")) {
                        found_accept = true;
                        break;
                    }
                    found_denial = true;
                    break;
                }
                catch (UnknownHostException ex) {
                    log.info((Object)("Failed to convert management addresses (" + rng.getBegin() + ", " + rng.getEnd() + ")"), (Throwable)ex);
                }
            }
            f = mgt.enumerateIncludeUrl();
            boolean match = false;
            block9: while (!found_denial && !match && f.hasMoreElements()) {
                String url = f.nextElement().toString();
                List addresses = (List)this.m_urlMap.get(url);
                for (String saddr : addresses) {
                    try {
                        InetAddress addr = InetAddress.getByName(saddr);
                        if (!addr.equals(target)) continue;
                        if (mgt.getPolicy() == null || mgt.getPolicy().equalsIgnoreCase("managed")) {
                            found_accept = true;
                        } else {
                            found_denial = true;
                        }
                        match = true;
                        continue block9;
                    }
                    catch (UnknownHostException ex) {
                        log.info((Object)("Failed to convert management address " + saddr + " to an InetAddress"), (Throwable)ex);
                    }
                }
            }
        }
        boolean bl = result = !managed_by_default;
        if (found_denial) {
            result = true;
        } else if (found_accept) {
            result = false;
        }
        return result;
    }

    private List getAddressesFromURL(String url) {
        ArrayList<String> addrList = new ArrayList<String>();
        try {
            URL fileURL = new URL(url);
            InputStream file = fileURL.openStream();
            if (file != null) {
                BufferedReader buffer = new BufferedReader(new InputStreamReader(file));
                String ipLine = null;
                String specIP = null;
                while ((ipLine = buffer.readLine()) != null) {
                    if ((ipLine = ipLine.trim()).length() == 0 || ipLine.charAt(0) == '#') continue;
                    int comIndex = ipLine.indexOf(COMMENT_STR);
                    if (comIndex == -1) {
                        specIP = ipLine;
                    } else {
                        specIP = ipLine.substring(0, comIndex);
                        ipLine = ipLine.trim();
                    }
                    addrList.add(specIP);
                    specIP = null;
                }
                buffer.close();
            } else {
                ThreadCategory.getInstance().warn((Object)("URL does not exist: " + url.toString()));
            }
        }
        catch (MalformedURLException e) {
            ThreadCategory.getInstance().error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        catch (FileNotFoundException e) {
            ThreadCategory.getInstance().error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        catch (IOException e) {
            ThreadCategory.getInstance().error((Object)("Error reading URL: " + url.toString() + ": " + e.getLocalizedMessage()));
        }
        return addrList;
    }

    public boolean isInterfaceInDB(Connection dbConn, InetAddress ifAddress) throws SQLException {
        Category log = ThreadCategory.getInstance(CapsdConfigFactory.class);
        boolean result = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("isInterfaceInDB: attempting to lookup interface " + ifAddress.getHostAddress() + " in the database."));
        }
        PreparedStatement s = dbConn.prepareStatement(RETRIEVE_IPADDR_SQL);
        s.setString(1, ifAddress.getHostAddress());
        ResultSet rs = s.executeQuery();
        if (rs.next()) {
            result = true;
        }
        rs.close();
        s.close();
        return result;
    }

    public int getInterfaceDbNodeId(Connection dbConn, InetAddress ifAddress, int ifIndex) throws SQLException {
        Category log = ThreadCategory.getInstance(CapsdConfigFactory.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getInterfaceDbNodeId: attempting to lookup interface " + ifAddress.getHostAddress() + "/ifindex: " + ifIndex + " in the database."));
        }
        StringBuffer qs = new StringBuffer(RETRIEVE_IPADDR_NODEID_SQL);
        if (ifIndex != -1) {
            qs.append(" AND ifindex=?");
        }
        PreparedStatement s = dbConn.prepareStatement(qs.toString());
        s.setString(1, ifAddress.getHostAddress());
        if (ifIndex != -1) {
            s.setInt(2, ifIndex);
        }
        ResultSet rs = s.executeQuery();
        int nodeid = -1;
        if (rs.next()) {
            nodeid = rs.getInt(1);
        }
        rs.close();
        s.close();
        return nodeid;
    }

    public long getRescanFrequency() {
        long frequency = -1L;
        if (this.m_config.hasRescanFrequency()) {
            frequency = this.m_config.getRescanFrequency();
        } else {
            ThreadCategory.getInstance(CapsdConfigFactory.class).warn((Object)"Capsd configuration file is missing rescan interval, defaulting to 24 hour interval.");
            frequency = 86400000L;
        }
        return frequency;
    }

    public long getInitialSleepTime() {
        long sleep = -1L;
        if (this.m_config.hasInitialSleepTime()) {
            sleep = this.m_config.getInitialSleepTime();
        } else {
            ThreadCategory.getInstance(CapsdConfigFactory.class).warn((Object)"Capsd configuration file is missing rescan interval, defaulting to 24 hour interval.");
            sleep = 300000L;
        }
        return sleep;
    }

    public int getMaxSuspectThreadPoolSize() {
        return this.m_config.getMaxSuspectThreadPoolSize();
    }

    public int getMaxRescanThreadPoolSize() {
        return this.m_config.getMaxRescanThreadPoolSize();
    }

    public boolean getAbortProtocolScansFlag() {
        boolean abortFlag = false;
        String abortProperty = this.m_config.getAbortProtocolScansIfNoRoute();
        if (abortProperty != null && abortProperty.equals("true")) {
            abortFlag = true;
        }
        return abortFlag;
    }

    public boolean getDeletePropagationEnabled() {
        boolean propagationEnabled = true;
        String propagationProperty = this.m_config.getDeletePropagationEnabled();
        if (propagationProperty != null && propagationProperty.equals("false")) {
            propagationEnabled = false;
        }
        return propagationEnabled;
    }

    public String getXmlrpc() {
        return this.m_config.getXmlrpc();
    }

    public void setNextSvcIdSql(String sql) {
        m_nextSvcIdSql = sql;
    }

    public String getNextSvcIdSql() {
        return m_nextSvcIdSql;
    }

    InetAddress compareAndSelectPrimaryCollectionInterface(CollectdConfigFactory x, String svcName, InetAddress currentIf, InetAddress oldPrimary, String method, boolean strict) {
        return this.compareAndSelectPrimaryCollectionInterface(svcName, currentIf, oldPrimary, method, strict);
    }

    InetAddress compareAndSelectPrimaryCollectionInterface(String svcName, InetAddress currentIf, InetAddress oldPrimary, String method, boolean strict) {
        InetAddress newPrimary = null;
        CollectdConfigFactory factory = CollectdConfigFactory.getInstance();
        if (oldPrimary == null && strict) {
            if (factory.isServiceCollectionEnabled(currentIf.getHostAddress(), svcName)) {
                return currentIf;
            }
            return oldPrimary;
        }
        if (oldPrimary == null) {
            return currentIf;
        }
        long current = IPSorter.convertToLong((byte[])currentIf.getAddress());
        long primary = IPSorter.convertToLong((byte[])oldPrimary.getAddress());
        if (method.equals("min")) {
            if (current < primary) {
                if (strict) {
                    if (factory.isServiceCollectionEnabled(currentIf.getHostAddress(), svcName)) {
                        newPrimary = currentIf;
                    }
                } else {
                    newPrimary = currentIf;
                }
            }
        } else if (current > primary) {
            if (strict) {
                if (factory.isServiceCollectionEnabled(currentIf.getHostAddress(), svcName)) {
                    newPrimary = currentIf;
                }
            } else {
                newPrimary = currentIf;
            }
        }
        if (newPrimary != null) {
            return newPrimary;
        }
        return oldPrimary;
    }

    public InetAddress determinePrimarySnmpInterface(List addressList, boolean strict) {
        InetAddress primaryIf = null;
        String method = "min";
        for (InetAddress ipAddr : addressList) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("determinePrimarySnmpIf: checking interface " + ipAddr.getHostAddress()));
            }
            primaryIf = this.compareAndSelectPrimaryCollectionInterface("SNMP", ipAddr, primaryIf, method, strict);
        }
        if (this.log().isDebugEnabled()) {
            if (primaryIf != null) {
                this.log().debug((Object)("determinePrimarySnmpInterface: candidate primary SNMP interface: " + primaryIf.getHostAddress()));
            } else {
                this.log().debug((Object)"determinePrimarySnmpInterface: no candidate primary SNMP interface found");
            }
        }
        return primaryIf;
    }

    static long toLong(InetAddress addr) {
        byte[] baddr = addr.getAddress();
        return ((long)baddr[0] & 0xFFL) << 24 | ((long)baddr[1] & 0xFFL) << 16 | ((long)baddr[2] & 0xFFL) << 8 | (long)baddr[3] & 0xFFL;
    }

    static {
        m_serviceIds = new HashMap();
        m_plugins = new TreeMap();
        SCAN = new Integer(0);
        SKIP = new Integer(1);
        AUTO_SET = new Integer(2);
    }

    protected static final class LightWeightIfEntry {
        static final int NULL_IFINDEX = -1;
        static final int NULL_IFTYPE = -1;
        static final int LOOPBACK_IFTYPE = 24;
        private int m_nodeId;
        private int m_ifIndex;
        private int m_ifType;
        private String m_address;
        private char m_managementState;
        private char m_snmpPrimaryState;
        private boolean m_primaryStateChanged;

        public LightWeightIfEntry(int nodeId, int ifIndex, String address, char managementState, char snmpPrimaryState, int ifType) {
            this.m_nodeId = nodeId;
            this.m_ifIndex = ifIndex;
            this.m_address = address;
            this.m_managementState = managementState;
            this.m_snmpPrimaryState = snmpPrimaryState;
            this.m_ifType = ifType;
            this.m_primaryStateChanged = false;
        }

        public String getAddress() {
            return this.m_address;
        }

        public int getNodeId() {
            return this.m_nodeId;
        }

        public int getIfIndex() {
            return this.m_ifIndex;
        }

        public int getIfType() {
            return this.m_ifType;
        }

        public char getManagementState() {
            return this.m_managementState;
        }

        public char getSnmpPrimaryState() {
            return this.m_snmpPrimaryState;
        }

        public void setSnmpPrimaryState(char state) {
            if (state != this.m_snmpPrimaryState) {
                this.m_snmpPrimaryState = state;
                this.m_primaryStateChanged = true;
            }
        }

        public boolean hasSnmpPrimaryStateChanged() {
            return this.m_primaryStateChanged;
        }
    }

    public static final class ProtocolInfo {
        private Plugin m_plugin;
        private String m_protocol;
        private Map m_parameters;
        private Integer m_action;

        public ProtocolInfo(String proto, Plugin plugin, Map params, Integer action) {
            this.m_plugin = plugin;
            this.m_protocol = proto;
            this.m_parameters = params;
            this.m_action = action;
        }

        public String getProtocol() {
            return this.m_protocol;
        }

        public Plugin getPlugin() {
            return this.m_plugin;
        }

        public Map getParameters() {
            return this.m_parameters;
        }

        public boolean autoEnabled() {
            return this.m_action == CapsdConfigFactory.AUTO_SET;
        }
    }
}

