/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigManager;

public final class CapsdConfigFactory
extends CapsdConfigManager {
    private static boolean m_loaded = false;
    private static CapsdConfig m_singleton = null;
    private long m_currentVersion = -1L;

    private CapsdConfigFactory() throws IOException, MarshalException, ValidationException {
        this.update();
    }

    protected synchronized void update() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME);
        if (this.m_currentVersion < configFile.lastModified()) {
            this.m_currentVersion = configFile.lastModified();
            ThreadCategory.getInstance(CapsdConfigFactory.class).debug((Object)("init: config file path: " + configFile.getPath()));
            FileReader rdr = new FileReader(configFile);
            this.loadXml(rdr);
            ((Reader)rdr).close();
        }
    }

    public CapsdConfigFactory(Reader rdr) throws IOException, MarshalException, ValidationException {
        super(rdr);
    }

    protected synchronized void saveXml(String xml) throws IOException {
        if (xml != null) {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME);
            FileWriter fileWriter = new FileWriter(cfgFile);
            fileWriter.write(xml);
            fileWriter.flush();
            fileWriter.close();
        }
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME);
        ThreadCategory.getInstance(CapsdConfigFactory.class).debug((Object)("init: config file path: " + cfgFile.getPath()));
        m_singleton = new CapsdConfigFactory();
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        CapsdConfigFactory.init();
    }

    public static synchronized CapsdConfig getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static synchronized void setInstance(CapsdConfig instance) {
        m_singleton = instance;
        m_loaded = true;
    }
}

