/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.actiond.ActiondConfiguration;

public final class ActiondConfigFactory {
    private static ActiondConfigFactory m_singleton = null;
    private ActiondConfiguration m_config;
    private static boolean m_loaded = false;

    private ActiondConfigFactory(String configFile) throws IOException, MarshalException, ValidationException {
        FileInputStream cfgIn = new FileInputStream(configFile);
        this.m_config = (ActiondConfiguration)Unmarshaller.unmarshal(ActiondConfiguration.class, (Reader)new InputStreamReader(cfgIn));
        ((InputStream)cfgIn).close();
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.ACTIOND_CONFIG_FILE_NAME);
        m_singleton = new ActiondConfigFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized void reload() throws IOException, MarshalException, ValidationException {
        m_singleton = null;
        m_loaded = false;
        ActiondConfigFactory.init();
    }

    public static synchronized ActiondConfigFactory getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public synchronized long getMaxProcessTime() {
        return this.m_config.getMaxProcessTime();
    }

    public synchronized int getMaxOutstandingActions() {
        return this.m_config.getMaxOutstandingActions();
    }
}

