/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.core.utils.StringUtils;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.ByNameComparator;
import org.opennms.netmgt.collectd.ResourceIdentifier;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;

public class PersistOperationBuilder {
    private RrdRepository m_repository;
    private String m_rrdName;
    private ResourceIdentifier m_resource;
    private Map<AttributeDefinition, String> m_declarations = new TreeMap<AttributeDefinition, String>(new ByNameComparator());
    static final String DST_GAUGE = "GAUGE";
    static final String DST_COUNTER = "COUNTER";
    public static final int MAX_DS_NAME_LENGTH = 19;

    public PersistOperationBuilder(RrdRepository repository, ResourceIdentifier resource, String rrdName) {
        this.m_repository = repository;
        this.m_resource = resource;
        this.m_rrdName = rrdName;
    }

    public RrdRepository getRepository() {
        return this.m_repository;
    }

    private File getResourceDir(ResourceIdentifier resource) {
        return resource.getResourceDir(this.getRepository());
    }

    public void declareAttribute(AttributeDefinition attrType) {
        this.m_declarations.put(attrType, "U");
    }

    public void setAttributeValue(AttributeDefinition attrType, String value) {
        this.m_declarations.put(attrType, value);
    }

    public static String mapType(String objectType) {
        if (objectType.toLowerCase().startsWith("counter")) {
            return DST_COUNTER;
        }
        return DST_GAUGE;
    }

    public void commit() throws RrdException {
        RrdUtils.createRRD((String)this.m_resource.getOwnerName(), (String)this.getResourceDir(this.m_resource).getAbsolutePath(), (String)this.m_rrdName, (int)this.getRepository().getStep(), (List)this.getDataSources(), (List)this.getRepository().getRraList());
        RrdUtils.updateRRD((String)this.m_resource.getOwnerName(), (String)this.getResourceDir(this.m_resource).getAbsolutePath(), (String)this.m_rrdName, (long)System.currentTimeMillis(), (String)this.getValues());
    }

    private String getValues() {
        boolean first = true;
        StringBuffer values = new StringBuffer();
        for (AttributeDefinition attrDef : this.m_declarations.keySet()) {
            String value = this.m_declarations.get(attrDef);
            if (!first) {
                values.append(':');
            } else {
                first = false;
            }
            values.append(value);
        }
        return values.toString();
    }

    private List getDataSources() {
        ArrayList<RrdDataSource> dataSources = new ArrayList<RrdDataSource>(this.m_declarations.size());
        for (AttributeDefinition attrDef : this.m_declarations.keySet()) {
            RrdDataSource rrdDataSource = new RrdDataSource(StringUtils.truncate((String)attrDef.getName(), (int)19), PersistOperationBuilder.mapType(attrDef.getType()), this.getRepository().getHeartBeat(), "U", "U");
            dataSources.add(rrdDataSource);
        }
        return dataSources;
    }

    public String getName() {
        return this.m_rrdName;
    }
}

