/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AttributeGroupType;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionSet;
import org.opennms.netmgt.collectd.GenericIndexResourceType;
import org.opennms.netmgt.collectd.IfAliasResourceType;
import org.opennms.netmgt.collectd.IfResourceType;
import org.opennms.netmgt.collectd.NodeResourceType;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.collectd.SnmpCollector;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.MibObject;
import org.opennms.netmgt.model.OnmsIpInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnmsSnmpCollection {
    private ServiceParameters m_params;
    private NodeResourceType m_nodeResourceType;
    private IfResourceType m_ifResourceType;
    private IfAliasResourceType m_ifAliasResourceType;
    private Map<String, ResourceType> m_genericIndexResourceTypes;
    private int m_maxVarsPerPdu;

    public OnmsSnmpCollection(CollectionAgent agent, ServiceParameters params) {
        this.m_params = params;
        this.m_maxVarsPerPdu = this.determineMaxVarsPerPdu(agent);
    }

    public String getName() {
        return this.m_params.getCollectionName();
    }

    public int getSnmpPort() {
        return this.m_params.getSnmpPort();
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    int getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu;
    }

    private int determineMaxVarsPerPdu(CollectionAgent agent) {
        int maxVarsPerPdu = DataCollectionConfigFactory.getInstance().getMaxVarsPerPdu(this.getName());
        if (maxVarsPerPdu == -1) {
            this.log().info((Object)("determineMaxVarsPerPdu: using agent's configured value: " + agent.getMaxVarsPerPdu()));
            maxVarsPerPdu = agent.getMaxVarsPerPdu();
        } else {
            this.log().info((Object)("determineMaxVarsPerPdu: using data collection configured value: " + maxVarsPerPdu));
        }
        return maxVarsPerPdu;
    }

    public String getStorageFlag() {
        String collectionName = this.getName();
        String storageFlag = DataCollectionConfigFactory.getInstance().getSnmpStorageFlag(collectionName);
        if (storageFlag == null) {
            if (this.log().isEnabledFor(Priority.WARN)) {
                this.log().warn((Object)("getStorageFlag: Configuration error, failed to retrieve SNMP storage flag for collection: " + collectionName));
            }
            storageFlag = SnmpCollector.SNMP_STORAGE_PRIMARY;
        }
        return storageFlag;
    }

    public String toString() {
        return this.getName();
    }

    public CollectionSet createCollectionSet(CollectionAgent agent) {
        return new CollectionSet(agent, this);
    }

    public Collection<AttributeType> getAttributeTypes(CollectionAgent agent, int ifType) {
        String sysObjectId = agent.getSysObjectId();
        String hostAddress = agent.getHostAddress();
        List oidList = DataCollectionConfigFactory.getInstance().getMibObjectList(this.getName(), sysObjectId, hostAddress, ifType);
        HashMap groupTypes = new HashMap();
        LinkedList<AttributeType> typeList = new LinkedList<AttributeType>();
        for (MibObject mibObject : oidList) {
            String instanceName = mibObject.getInstance();
            AttributeGroupType groupType = this.getGroup(groupTypes, mibObject);
            AttributeType attrType = AttributeType.create(this.getResourceType(agent, instanceName), this.getName(), mibObject, groupType);
            groupType.addAttributeType(attrType);
            typeList.add(attrType);
        }
        this.log().debug((Object)("getAttributeTypes(" + agent + ", " + ifType + "): " + typeList));
        return typeList;
    }

    private AttributeGroupType getGroup(Map groupTypes, MibObject mibObject) {
        AttributeGroupType groupType = (AttributeGroupType)groupTypes.get(mibObject.getGroupName());
        if (groupType == null) {
            groupType = new AttributeGroupType(mibObject.getGroupName(), mibObject.getGroupIfType());
            groupTypes.put(mibObject.getGroupName(), groupType);
        }
        return groupType;
    }

    public ResourceType getResourceType(CollectionAgent agent, String instanceName) {
        if ("ifIndex".equals(instanceName)) {
            return this.getIfResourceType(agent);
        }
        if (this.getGenericIndexResourceType(agent, instanceName) != null) {
            return this.getGenericIndexResourceType(agent, instanceName);
        }
        return this.getNodeResourceType(agent);
    }

    public NodeResourceType getNodeResourceType(CollectionAgent agent) {
        if (this.m_nodeResourceType == null) {
            this.m_nodeResourceType = new NodeResourceType(agent, this);
        }
        return this.m_nodeResourceType;
    }

    public IfResourceType getIfResourceType(CollectionAgent agent) {
        if (this.m_ifResourceType == null) {
            this.m_ifResourceType = new IfResourceType(agent, this);
        }
        return this.m_ifResourceType;
    }

    public IfAliasResourceType getIfAliasResourceType(CollectionAgent agent) {
        if (this.m_ifAliasResourceType == null) {
            this.m_ifAliasResourceType = new IfAliasResourceType(agent, this, this.m_params, this.getIfResourceType(agent));
        }
        return this.m_ifAliasResourceType;
    }

    private Map<String, ResourceType> getGenericIndexResourceTypes(CollectionAgent agent) {
        if (this.m_genericIndexResourceTypes == null) {
            Collection configuredResourceTypes = DataCollectionConfigFactory.getInstance().getConfiguredResourceTypes().values();
            HashMap<String, ResourceType> resourceTypes = new HashMap<String, ResourceType>();
            for (org.opennms.netmgt.config.datacollection.ResourceType configuredResourceType : configuredResourceTypes) {
                resourceTypes.put(configuredResourceType.getName(), new GenericIndexResourceType(agent, this, configuredResourceType));
            }
            this.m_genericIndexResourceTypes = resourceTypes;
        }
        return this.m_genericIndexResourceTypes;
    }

    private ResourceType getGenericIndexResourceType(CollectionAgent agent, String name) {
        return this.getGenericIndexResourceTypes(agent).get(name);
    }

    private Collection getResourceTypes(CollectionAgent agent) {
        HashSet<ResourceType> set = new HashSet<ResourceType>(3);
        set.add(this.getNodeResourceType(agent));
        set.add(this.getIfResourceType(agent));
        set.add(this.getIfAliasResourceType(agent));
        set.addAll(this.getGenericIndexResourceTypes(agent).values());
        return set;
    }

    public Collection getAttributeTypes(CollectionAgent agent) {
        HashSet<AttributeType> set = new HashSet<AttributeType>();
        for (ResourceType resourceType : this.getResourceTypes(agent)) {
            set.addAll(resourceType.getAttributeTypes());
        }
        return set;
    }

    public Collection getResources(CollectionAgent agent) {
        LinkedList resources = new LinkedList();
        for (ResourceType resourceType : this.getResourceTypes(agent)) {
            resources.addAll(resourceType.getResources());
        }
        return resources;
    }

    OnmsIpInterface.CollectionType getMinimumCollectionType() {
        if (this.getStorageFlag().equals(SnmpCollector.SNMP_STORAGE_PRIMARY)) {
            return OnmsIpInterface.CollectionType.PRIMARY;
        }
        if (this.getStorageFlag().equals(SnmpCollector.SNMP_STORAGE_SELECT)) {
            return OnmsIpInterface.CollectionType.COLLECT;
        }
        return OnmsIpInterface.CollectionType.NO_COLLECT;
    }
}

