/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AttributeDefinition;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.PersistOperationBuilder;
import org.opennms.netmgt.collectd.ResourceIdentifier;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.HttpCollectionConfigFactory;
import org.opennms.netmgt.config.datacollection.Attrib;
import org.opennms.netmgt.config.datacollection.HttpCollection;
import org.opennms.netmgt.config.datacollection.Uri;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.utils.EventProxy;
import org.opennms.netmgt.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpCollector
implements ServiceCollector {
    private static final int DEFAULT_RETRY_COUNT = 2;
    private static final String DEFAULT_SO_TIMEOUT = "3000";
    private final HashMap<Integer, String> m_scheduledNodes = new HashMap();

    @Override
    public int collect(CollectionAgent agent, EventProxy eproxy, Map<String, String> parameters) {
        HttpCollectionSet collectionSet = new HttpCollectionSet(agent, parameters);
        return collectionSet.collect();
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void doCollection(final HttpCollectionSet collectionSet) throws HttpCollectorException {
        HttpClient client = null;
        HttpMethod method = null;
        try {
            client = new HttpClient(this.buildParams(collectionSet));
            method = this.buildHttpMethod(collectionSet);
            this.log().info((Object)("doCollection: collecting for client: " + client + " using method: " + method));
            client.executeMethod(method);
            List<HttpCollectionAttribute> butes = this.processResponse(method.getResponseBodyAsString(), collectionSet);
            if (butes.isEmpty()) {
                this.log().warn((Object)"doCollection: no attributes defined for collection where found in response text.");
                throw new HttpCollectorException("No attributes specified were found: ", client);
            }
            String collectionName = collectionSet.getParameters().get("http-collection");
            RrdRepository rrdRepository = HttpCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
            ResourceIdentifier resource = new ResourceIdentifier(){

                public String getOwnerName() {
                    return collectionSet.getAgent().getHostAddress();
                }

                public File getResourceDir(RrdRepository repository) {
                    return new File(repository.getRrdBaseDir(), Integer.toString(collectionSet.getAgent().getNodeId()));
                }
            };
            this.log().info((Object)("doCollection: persisting " + butes.size() + " attributes"));
            for (HttpCollectionAttribute attribute : butes) {
                PersistOperationBuilder builder = new PersistOperationBuilder(rrdRepository, resource, attribute.getName());
                builder.declareAttribute(attribute);
                this.log().debug((Object)("doCollection: setting attribute: " + attribute));
                builder.setAttributeValue(attribute, attribute.getValue());
                builder.commit();
            }
        }
        catch (URIException e) {
            throw new HttpCollectorException("Error building HttpClient URI", client);
        }
        catch (HttpException e) {
            throw new HttpCollectorException("Error building HttpMethod", client);
        }
        catch (IOException e) {
            throw new HttpCollectorException("IO Error retrieving page", client);
        }
        catch (RrdException e) {
            throw new HttpCollectorException("Error writing RRD", client);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private List<HttpCollectionAttribute> processResponse(String responseBodyAsString, HttpCollectionSet collectionSet) {
        this.log().debug((Object)"processResponse: ");
        LinkedList<HttpCollectionAttribute> butes = new LinkedList<HttpCollectionAttribute>();
        Pattern p = Pattern.compile(collectionSet.getUriDef().getUrl().getMatches());
        Matcher m = p.matcher(responseBodyAsString);
        boolean matches = m.matches();
        if (matches) {
            this.log().debug((Object)("processResponse: found matching attributes: " + matches));
            ArrayList attribDefs = collectionSet.getUriDef().getAttributes().getAttribCollection();
            for (Attrib attribDef : attribDefs) {
                HttpCollectionAttribute bute = new HttpCollectionAttribute(attribDef.getAlias(), attribDef.getType(), m.group(attribDef.getMatchGroup()));
                this.log().debug((Object)("processResponse: adding found attribute: " + bute));
                butes.add(bute);
            }
        } else {
            this.log().debug((Object)("processResponse: found matching attributes: " + matches));
        }
        return butes;
    }

    private HttpClientParams buildParams(HttpCollectionSet collectionSet) {
        HttpClientParams params = new HttpClientParams(DefaultHttpParams.getDefaultParams());
        params.setVersion(this.computeVersion(collectionSet.getUriDef()));
        params.setSoTimeout(Integer.parseInt(ParameterMap.getKeyedString(collectionSet.getParameters(), "timeout", DEFAULT_SO_TIMEOUT)));
        params.setVirtualHost(collectionSet.getUriDef().getUrl().getVirtualHost());
        Integer retryCount = ParameterMap.getKeyedInteger(collectionSet.getParameters(), "retries", 2);
        params.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(retryCount.intValue(), false));
        return params;
    }

    private HttpVersion computeVersion(Uri uri) {
        return new HttpVersion(Integer.parseInt(uri.getUrl().getHttpVersion().substring(0, 1)), Integer.parseInt(uri.getUrl().getHttpVersion().substring(2)));
    }

    private HttpMethod buildHttpMethod(HttpCollectionSet collectionSet) throws URIException {
        Object method = "GET".equals(collectionSet.getUriDef().getUrl().getMethod()) ? new GetMethod() : new PostMethod();
        method.setURI(this.buildUri(collectionSet));
        return method;
    }

    private URI buildUri(HttpCollectionSet collectionSet) throws URIException {
        return new URI(collectionSet.getUriDef().getUrl().getScheme(), collectionSet.getUriDef().getUrl().getUserInfo(), this.determineHost(collectionSet.getAgent().getInetAddress(), collectionSet.getUriDef()), collectionSet.getUriDef().getUrl().getPort(), collectionSet.getUriDef().getUrl().getPath(), collectionSet.getUriDef().getUrl().getQuery(), collectionSet.getUriDef().getUrl().getFragment());
    }

    private String determineHost(InetAddress address, Uri uriDef) {
        String host = "${ipaddr}".equals(uriDef.getUrl().getHost()) ? address.getHostName() : uriDef.getUrl().getHost();
        this.log().debug((Object)("determineHost: host for URI is set to: " + host));
        return host;
    }

    @Override
    public void initialize(Map parameters) {
        this.log().debug((Object)"initialize: Initializing HttpCollector.");
        this.m_scheduledNodes.clear();
        this.initHttpCollecionConfig();
        this.initDatabaseConnectionFactory();
        this.initializeRrdRepository();
    }

    private void initHttpCollecionConfig() {
        try {
            this.log().debug((Object)("initialize: Initializing collector: " + this.getClass()));
            HttpCollectionConfigFactory.init();
        }
        catch (MarshalException e) {
            this.log().fatal((Object)"initialize: Error marshalling configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal((Object)"initialize: Error validating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (FileNotFoundException e) {
            this.log().fatal((Object)"initialize: Error locating configuration.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            this.log().fatal((Object)"initialize: Error reading configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    private void initializeRrdRepository() {
        this.log().debug((Object)"initializeRrdRepository: Initializing RRD repo from HttpCollector...");
        this.initializeRrdDirs();
        this.initializeRrdInterface();
    }

    private void initializeRrdDirs() {
        File f = new File(HttpCollectionConfigFactory.getInstance().getRrdPath());
        if (!f.isDirectory() && !f.mkdirs()) {
            StringBuffer sb = new StringBuffer();
            sb.append("initializeRrdDirs: Unable to create RRD file repository.  Path doesn't already exist and could not make directory: ");
            sb.append(HttpCollectionConfigFactory.getInstance().getRrdPath());
            this.log().error((Object)sb.toString());
            throw new RuntimeException(sb.toString());
        }
    }

    private void initializeRrdInterface() {
        try {
            RrdUtils.initialize();
        }
        catch (RrdException e) {
            this.log().error((Object)"initializeRrdInterface: Unable to initialize RrdUtils", (Throwable)e);
            throw new RuntimeException("Unable to initialize RrdUtils", e);
        }
    }

    private void initDatabaseConnectionFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (IOException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: IOException getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (MarshalException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Marshall Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Validation Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed getting connection to the database.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            this.log().fatal((Object)"initDatabaseConnectionFactory: Failed loading database driver.", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void initialize(CollectionAgent agent, Map parameters) {
        this.log().debug((Object)("initialize: Initializing HTTP collection for agent: " + agent));
        Integer scheduledNodeKey = new Integer(agent.getNode().getId());
        String scheduledAddress = this.m_scheduledNodes.get(scheduledNodeKey);
        if (scheduledAddress != null) {
            this.log().info((Object)("initialize: Not scheduling interface for collection: " + scheduledAddress));
            StringBuffer sb = new StringBuffer();
            sb.append("initialize service: ");
            sb.append(this.determineServiceName(parameters));
            sb.append(" for address: ");
            sb.append(scheduledAddress);
            sb.append(" already scheduled for collection on node: ");
            sb.append(agent.getNode().toString());
            this.log().debug((Object)sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        this.log().info((Object)("initialize: Scheduling interface for collection: " + scheduledAddress));
        this.m_scheduledNodes.put(scheduledNodeKey, scheduledAddress);
    }

    private String determineServiceName(Map parameters) {
        return ParameterMap.getKeyedString(parameters, "service-name", "HTTP");
    }

    @Override
    public void release() {
    }

    @Override
    public void release(CollectionAgent agent) {
    }

    public class HttpCollectorException
    extends RuntimeException {
        private static final long serialVersionUID = 7244720855059205687L;
        HttpClient m_client;

        HttpCollectorException(String message, HttpClient client) {
            super(message);
            this.m_client = client;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(super.toString());
            buffer.append(": client URL: ");
            HostConfiguration hostConfiguration = this.m_client.getHostConfiguration();
            buffer.append(hostConfiguration == null ? "null" : hostConfiguration.toString());
            return buffer.toString();
        }
    }

    class HttpCollectionAttribute
    implements AttributeDefinition {
        String m_alias;
        String m_type;
        String m_value;

        HttpCollectionAttribute(String alias, String type, String value) {
            this.m_alias = alias;
            this.m_type = type;
            this.m_value = value;
        }

        public String getName() {
            return this.m_alias;
        }

        public String getType() {
            return this.m_type;
        }

        public String getValue() {
            return this.m_value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof HttpCollectionAttribute) {
                HttpCollectionAttribute other = (HttpCollectionAttribute)obj;
                return this.getName().equals(other.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("HttpAttribute: ");
            buffer.append(this.getName());
            buffer.append(":");
            buffer.append(this.getType());
            buffer.append(":");
            buffer.append(this.getValue());
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class HttpCollectionSet {
        private CollectionAgent m_agent;
        private Map<String, String> m_parameters;
        private Uri m_uriDef;

        public Uri getUriDef() {
            return this.m_uriDef;
        }

        public void setUriDef(Uri uriDef) {
            this.m_uriDef = uriDef;
        }

        HttpCollectionSet(CollectionAgent agent, Map<String, String> parameters) {
            this.m_agent = agent;
            this.m_parameters = parameters;
        }

        public int collect() {
            HttpCollection collection = HttpCollectionConfigFactory.getInstance().getHttpCollection(this.m_parameters.get("http-collection"));
            ArrayList uriDefs = collection.getUris().getUriCollection();
            Iterator i$ = uriDefs.iterator();
            while (i$.hasNext()) {
                Uri uriDef;
                this.m_uriDef = uriDef = (Uri)i$.next();
                try {
                    HttpCollector.this.doCollection(this);
                }
                catch (HttpCollectorException e) {
                    HttpCollector.this.log().error((Object)"collect: http collection problem: ", (Throwable)e);
                    return 2;
                }
            }
            return 1;
        }

        public CollectionAgent getAgent() {
            return this.m_agent;
        }

        public void setAgent(CollectionAgent agent) {
            this.m_agent = agent;
        }

        public Map<String, String> getParameters() {
            return this.m_parameters;
        }

        public void setParameters(Map<String, String> parameters) {
            this.m_parameters = parameters;
        }
    }
}

