/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.GenericIndexResource;
import org.opennms.netmgt.collectd.OnmsSnmpCollection;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.config.StorageStrategy;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.springframework.orm.ObjectRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericIndexResourceType
extends ResourceType {
    private String m_name;
    private StorageStrategy m_storageStrategy;
    private Map<SnmpInstId, GenericIndexResource> m_resourceMap = new HashMap<SnmpInstId, GenericIndexResource>();

    public GenericIndexResourceType(CollectionAgent agent, OnmsSnmpCollection snmpCollection, org.opennms.netmgt.config.datacollection.ResourceType resourceType) {
        super(agent, snmpCollection);
        this.m_name = resourceType.getName();
        this.instantiatePersistenceSelectorStrategy(resourceType.getPersistenceSelectorStrategy().getClazz());
        this.instantiateStorageStrategy(resourceType.getStorageStrategy().getClazz());
    }

    private void instantiatePersistenceSelectorStrategy(String className) {
    }

    private void instantiateStorageStrategy(String className) {
        StorageStrategy storageStrategy;
        Class<?> cinst;
        try {
            cinst = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not load class", (Throwable)e);
        }
        try {
            storageStrategy = (StorageStrategy)cinst.newInstance();
        }
        catch (InstantiationException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectRetrievalFailureException(StorageStrategy.class, (Object)className, "Could not instantiate", (Throwable)e);
        }
        storageStrategy.setResourceTypeName(this.m_name);
    }

    @Override
    public CollectionResource findResource(SnmpInstId inst) {
        if (!this.m_resourceMap.containsKey(inst)) {
            this.m_resourceMap.put(inst, new GenericIndexResource(this, this.getName(), inst));
        }
        return this.m_resourceMap.get(inst);
    }

    @Override
    public CollectionResource findAliasedResource(SnmpInstId inst, String ifAlias) {
        this.log().debug((Object)"findAliasedResource: Should not get called from GenericIndexResourceType");
        return null;
    }

    @Override
    public Collection<AttributeType> getAttributeTypes() {
        return this.getCollection().getAttributeTypes(this.getAgent(), -2);
    }

    @Override
    public Collection<GenericIndexResource> getResources() {
        return this.m_resourceMap.values();
    }

    public String getName() {
        return this.m_name;
    }

    public StorageStrategy getStorageStrategy() {
        return this.m_storageStrategy;
    }
}

