/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.Collection;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionAgent;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.snmp.SnmpInstId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericIndexResource
extends CollectionResource {
    private SnmpInstId m_inst;
    private String m_name;

    public GenericIndexResource(ResourceType def, String name, SnmpInstId inst) {
        super(def);
        this.m_name = name;
        this.m_inst = inst;
    }

    @Override
    public Collection<AttributeType> getAttributeTypes() {
        return this.getResourceType().getAttributeTypes();
    }

    @Override
    public CollectionAgent getCollectionAgent() {
        return this.getResourceType().getAgent();
    }

    @Override
    public File getResourceDir(RrdRepository repository) {
        File rrdBaseDir = repository.getRrdBaseDir();
        File nodeDir = new File(rrdBaseDir, String.valueOf(this.getCollectionAgent().getNodeId()));
        File typeDir = new File(nodeDir, this.m_name);
        File instDir = new File(typeDir, this.m_inst.toString());
        this.log().debug((Object)("getResourceDir: " + instDir.toString()));
        return instDir;
    }

    public String toString() {
        return "Node[" + this.getCollectionAgent().getNodeId() + "]/type[" + this.m_name + "]/instance[" + this.m_inst + "]";
    }

    @Override
    protected int getType() {
        return -1;
    }

    @Override
    public boolean shouldPersist(ServiceParameters params) {
        return true;
    }
}

