/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.IPv4NetworkInterface;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

public class CollectionAgent
extends IPv4NetworkInterface {
    private static final long serialVersionUID = 6694654071513990997L;
    private OnmsIpInterface m_iface;
    private int m_maxVarsPerPdu = 0;
    private int m_ifCount = -1;

    public CollectionAgent(OnmsIpInterface iface) {
        super(iface.getInetAddress());
        this.m_iface = iface;
    }

    public OnmsIpInterface getIpInterface() {
        return this.m_iface;
    }

    public OnmsNode getNode() {
        return this.m_iface.getNode();
    }

    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this.m_maxVarsPerPdu = maxVarsPerPdu;
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("maxVarsPerPdu=" + maxVarsPerPdu));
        }
    }

    public int getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu;
    }

    public String getHostAddress() {
        return this.getInetAddress().getHostAddress();
    }

    public void setSavedIfCount(int ifCount) {
        this.m_ifCount = ifCount;
    }

    int getSavedIfCount() {
        return this.m_ifCount;
    }

    int getNodeId() {
        return this.getIpInterface().getNode().getId() == null ? -1 : this.getIpInterface().getNode().getId();
    }

    int getIfIndex() {
        return this.getIpInterface().getIfIndex() == null ? -1 : this.getIpInterface().getIfIndex();
    }

    public String getSysObjectId() {
        return this.getIpInterface().getNode().getSysObjectId();
    }

    private OnmsIpInterface.CollectionType getCollectionType() {
        return this.getIpInterface().getIsSnmpPrimary();
    }

    private void logCompletion() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: initialization completed: nodeid = " + this.getNodeId() + ", address = " + this.getHostAddress() + ", primaryIfIndex = " + this.getIfIndex() + ", isSnmpPrimary = " + this.getCollectionType() + ", sysoid = " + this.getSysObjectId()));
        }
    }

    private void validateSysObjId() {
        if (this.getSysObjectId() == null) {
            throw new RuntimeException("System Object ID for interface " + this.getHostAddress() + " does not exist in the database.");
        }
    }

    private void logCollectionParms() {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: db retrieval info: nodeid = " + this.getNodeId() + ", address = " + this.getHostAddress() + ", primaryIfIndex = " + this.getIfIndex() + ", isSnmpPrimary = " + this.getCollectionType() + ", sysoid = " + this.getSysObjectId()));
        }
    }

    private void validateIsSnmpPrimary() {
        if (!OnmsIpInterface.CollectionType.PRIMARY.equals((Object)this.getCollectionType())) {
            throw new RuntimeException("Interface " + this.getHostAddress() + " is not the primary SNMP interface for nodeid " + this.getNodeId());
        }
    }

    private void validatePrimaryIfIndex() {
        if (this.getIfIndex() == -1 && this.log().isDebugEnabled()) {
            this.log().debug((Object)("initialize: db retrieval info: node " + this.getNodeId() + " does not have a legitimate " + "primaryIfIndex.  Assume node does not " + "supply ipAddrTable and continue..."));
        }
    }

    public void validateAgent() {
        this.logCollectionParms();
        this.validateIsSnmpPrimary();
        this.validatePrimaryIfIndex();
        this.validateSysObjId();
        this.logCompletion();
    }

    public String toString() {
        return "Agent[nodeid = " + this.getNodeId() + " ipaddr= " + this.getHostAddress() + ']';
    }

    public SnmpAgentConfig getAgentConfig() {
        return SnmpPeerFactory.getInstance().getAgentConfig(this.getInetAddress());
    }
}

