/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.net.InetAddress;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.collectd.CollectableService;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.CollectorUpdates;
import org.opennms.netmgt.collectd.ServiceCollector;
import org.opennms.netmgt.config.CollectdConfig;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.CollectorConfigDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.eventd.EventIpcManager;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Scheduler;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Parms;
import org.opennms.netmgt.xml.event.Value;
import org.opennms.protocols.ip.IPv4Address;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Collectd
extends AbstractServiceDaemon
implements EventListener {
    private static final String LOG4J_CATEGORY = "OpenNMS.Collectd";
    private Map<String, ServiceCollector> m_collectors = new HashMap<String, ServiceCollector>(4);
    private List<CollectableService> m_collectableServices;
    private Scheduler m_scheduler;
    private CollectorConfigDao m_collectorConfigDao;
    private MonitoredServiceDao m_monSvcDao;
    private IpInterfaceDao m_ifSvcDao;
    private SchedulingCompletedFlag m_schedulingCompletedFlag = new SchedulingCompletedFlag();
    private EventIpcManager m_eventIpcManager;
    private TransactionTemplate m_transTemplate;
    private NodeDao m_nodeDao;

    public Collectd() {
        super(LOG4J_CATEGORY);
        this.m_collectableServices = Collections.synchronizedList(new LinkedList());
    }

    @Override
    protected void onInit() {
        this.log().debug((Object)"init: Initializing collection daemon");
        this.instantiateCollectors();
        this.getScheduler().schedule(0L, this.ifScheduler());
        this.installMessageSelectors();
    }

    private void installMessageSelectors() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/primarySnmpInterfaceChanged");
        ueiList.add("uei.opennms.org/nodes/reinitializePrimarySnmpInterface");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/duplicateNodeDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/nodes/serviceDeleted");
        ueiList.add("uei.opennms.org/internal/schedOutagesChanged");
        ueiList.add("uei.opennms.org/internal/configureSNMP");
        this.getEventIpcManager().addEventListener((EventListener)this, ueiList);
    }

    public void setEventIpcManager(EventIpcManager eventIpcManager) {
        this.m_eventIpcManager = eventIpcManager;
    }

    public EventIpcManager getEventIpcManager() {
        return this.m_eventIpcManager;
    }

    private ReadyRunnable ifScheduler() {
        ReadyRunnable interfaceScheduler = new ReadyRunnable(){

            public boolean isReady() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    ThreadCategory.setPrefix((String)Collectd.LOG4J_CATEGORY);
                    Collectd.this.scheduleExistingInterfaces();
                }
                catch (SQLException e) {
                    Collectd.this.log().error((Object)"start: Failed to schedule existing interfaces", (Throwable)e);
                }
                finally {
                    Collectd.this.setSchedulingCompleted(true);
                }
            }
        };
        return interfaceScheduler;
    }

    private void createScheduler() {
        try {
            this.log().debug((Object)"init: Creating collectd scheduler");
            this.setScheduler(new LegacyScheduler("Collectd", this.getCollectorConfigDao().getSchedulerThreads()));
        }
        catch (RuntimeException e) {
            this.log().fatal((Object)"init: Failed to create collectd scheduler", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void onStart() {
        try {
            this.log().debug((Object)"start: Starting collectd scheduler");
            this.getScheduler().start();
        }
        catch (RuntimeException e) {
            this.log().fatal((Object)"start: Failed to start scheduler", (Throwable)e);
            throw e;
        }
    }

    @Override
    protected void onStop() {
        this.getScheduler().stop();
        this.deinstallMessageSelectors();
        this.setScheduler(null);
    }

    @Override
    protected void onPause() {
        this.getScheduler().pause();
    }

    @Override
    protected void onResume() {
        this.getScheduler().resume();
    }

    private void scheduleExistingInterfaces() throws SQLException {
        this.m_transTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                Iterator<String> it = Collectd.this.getCollectorNames().iterator();
                while (it.hasNext()) {
                    Collectd.this.scheduleInterfacesWithService(it.next());
                }
                return null;
            }
        });
    }

    private void scheduleInterfacesWithService(String svcName) {
        this.log().info((Object)("scheduleInterfacesWithService: svcName = " + svcName));
        Collection ifsWithServices = this.getIpInterfaceDao().findHierarchyByServiceType(svcName);
        for (OnmsIpInterface iface : ifsWithServices) {
            this.scheduleInterface(iface, svcName, true);
        }
    }

    private void scheduleInterface(int nodeId, String ipAddress, String svcName, boolean existing) {
        OnmsIpInterface iface = this.getIpInterface(nodeId, ipAddress);
        if (iface == null) {
            this.log().error((Object)("Unable to find interface with address " + ipAddress + " on node " + nodeId));
            return;
        }
        OnmsMonitoredService svc = iface.getMonitoredServiceByServiceType(svcName);
        if (svc == null) {
            this.log().error((Object)("Unable to find service " + svcName + " on interface with address " + ipAddress + " on node " + nodeId));
            return;
        }
        this.scheduleInterface(iface, svc.getServiceType().getName(), existing);
    }

    private OnmsIpInterface getIpInterface(int nodeId, String ipAddress) {
        OnmsNode node = this.m_nodeDao.getHierarchy(Integer.valueOf(nodeId));
        OnmsIpInterface iface = node.getIpInterfaceByIpAddress(ipAddress);
        return iface;
    }

    private void scheduleInterface(OnmsIpInterface iface, String svcName, boolean existing) {
        StringBuffer sb;
        Collection<CollectionSpecification> matchingSpecs = this.getSpecificationsForInterface(iface, svcName);
        if (this.log().isDebugEnabled()) {
            sb = new StringBuffer();
            sb.append("scheduleInterface: found ");
            sb.append(Integer.toString(matchingSpecs.size()));
            sb.append(" matching specs for interface: ");
            sb.append(iface);
            this.log().debug((Object)sb.toString());
        }
        for (CollectionSpecification spec : matchingSpecs) {
            if (!existing && this.alreadyScheduled(iface, spec)) {
                if (!this.log().isDebugEnabled()) continue;
                sb = new StringBuffer();
                sb.append("scheduleInterface: svc/pkgName ");
                sb.append(iface);
                sb.append('/');
                sb.append(spec);
                sb.append(" already in collectable service list, skipping.");
                this.log().debug((Object)sb.toString());
                continue;
            }
            try {
                if (this.log().isDebugEnabled()) {
                    sb = new StringBuffer();
                    sb.append("scheduleInterface: now scheduling interface: ");
                    sb.append(iface);
                    sb.append('/');
                    sb.append(svcName);
                }
                CollectableService cSvc = null;
                cSvc = new CollectableService(iface, spec, this.getScheduler(), this.m_schedulingCompletedFlag, this.m_transTemplate);
                this.m_collectableServices.add(cSvc);
                this.getScheduler().schedule(0L, cSvc.getReadyRunnable());
                if (!this.log().isDebugEnabled()) continue;
                sb = new StringBuffer();
                sb.append("scheduleInterface: ");
                sb.append(iface);
                sb.append('/');
                sb.append(svcName);
                sb.append(" collection, scheduled");
                this.log().debug((Object)sb.toString());
            }
            catch (RuntimeException rE) {
                sb = new StringBuffer();
                sb.append("scheduleInterface: Unable to schedule ");
                sb.append(iface);
                sb.append('/');
                sb.append(svcName);
                sb.append(", reason: ");
                sb.append(rE);
                this.log().warn((Object)sb.toString(), (Throwable)rE);
            }
            catch (Throwable t) {
                sb = new StringBuffer();
                sb.append("scheduleInterface: Uncaught exception, failed to schedule interface ");
                sb.append(iface);
                sb.append('/');
                sb.append(svcName);
                sb.append(". ");
                sb.append(t);
                this.log().error((Object)sb.toString(), t);
            }
        }
    }

    public Collection<CollectionSpecification> getSpecificationsForInterface(OnmsIpInterface iface, String svcName) {
        LinkedList<CollectionSpecification> matchingPkgs = new LinkedList<CollectionSpecification>();
        CollectdConfigFactory cCfgFactory = CollectdConfigFactory.getInstance();
        CollectdConfig config = cCfgFactory.getCollectdConfig();
        for (CollectdPackage wpkg : config.getPackages()) {
            StringBuffer sb;
            if (!wpkg.serviceInPackageAndEnabled(svcName)) {
                if (!this.log().isDebugEnabled()) continue;
                sb = new StringBuffer();
                sb.append("getSpecificationsForInterface: address/service: ");
                sb.append(iface);
                sb.append("/");
                sb.append(svcName);
                sb.append(" not scheduled, service is not enabled or does not exist in package: ");
                sb.append(wpkg.getName());
                this.log().debug((Object)sb.toString());
                continue;
            }
            if (!wpkg.interfaceInPackage(iface.getIpAddress())) {
                if (!this.log().isDebugEnabled()) continue;
                sb = new StringBuffer();
                sb.append("getSpecificationsForInterface: address/service: ");
                sb.append(iface);
                sb.append("/");
                sb.append(svcName);
                sb.append(" not scheduled, interface does not belong to package: ");
                sb.append(wpkg.getName());
                this.log().debug((Object)sb.toString());
                continue;
            }
            LinkedList outageCalendars = new LinkedList();
            matchingPkgs.add(new CollectionSpecification(wpkg, svcName, outageCalendars, this.getServiceCollector(svcName)));
        }
        return matchingPkgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyScheduled(OnmsIpInterface iface, CollectionSpecification spec) {
        StringBuffer sb;
        String ipAddress = iface.getIpAddress();
        String svcName = spec.getServiceName();
        String pkgName = spec.getPackageName();
        boolean isScheduled = false;
        if (this.log().isDebugEnabled()) {
            sb = new StringBuffer();
            sb.append("alreadyScheduled: determining if interface: ");
            sb.append(iface);
            sb.append(" is already scheduled.");
        }
        List<CollectableService> list = this.m_collectableServices;
        synchronized (list) {
            for (CollectableService cSvc : this.m_collectableServices) {
                InetAddress addr = (InetAddress)cSvc.getAddress();
                if (!addr.getHostAddress().equals(ipAddress) || !cSvc.getPackageName().equals(pkgName) || !cSvc.getServiceName().equals(svcName)) continue;
                isScheduled = true;
                break;
            }
        }
        if (this.log().isDebugEnabled()) {
            sb = new StringBuffer();
            sb.append("alreadyScheduled: interface ");
            sb.append(iface);
            sb.append("already scheduled check: ");
            sb.append(isScheduled);
        }
        return isScheduled;
    }

    private void setSchedulingCompleted(boolean schedulingCompleted) {
        this.m_schedulingCompletedFlag.setSchedulingCompleted(schedulingCompleted);
    }

    private void refreshServicePackages() {
        for (CollectableService thisService : this.m_collectableServices) {
            thisService.refreshPackage();
        }
    }

    private List<CollectableService> getCollectableServices() {
        return this.m_collectableServices;
    }

    @Override
    public void onEvent(final Event event) {
        this.m_transTemplate.execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                Collectd.this.onEventInTransaction(event);
                return null;
            }
        });
    }

    private void onEventInTransaction(Event event) {
        this.log().debug((Object)("received event, uei = " + event.getUei()));
        try {
            if (event.getUei().equals("uei.opennms.org/internal/schedOutagesChanged")) {
                this.handleScheduledOutagesChanged(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/configureSNMP")) {
                this.handleConfigureSNMP(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
                this.handleNodeGainedService(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/primarySnmpInterfaceChanged")) {
                this.handlePrimarySnmpInterfaceChanged(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/reinitializePrimarySnmpInterface")) {
                this.handleReinitializePrimarySnmpInterface(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceReparented")) {
                this.handleInterfaceReparented(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/nodeDeleted")) {
                this.handleNodeDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/duplicateNodeDeleted")) {
                this.handleDupNodeDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceDeleted")) {
                this.handleInterfaceDeleted(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/serviceDeleted")) {
                this.handleServiceDeleted(event);
            }
        }
        catch (InsufficientInformationException e) {
            this.log().info((Object)e.getMessage());
        }
    }

    private void handleDupNodeDeleted(Event event) throws InsufficientInformationException {
        this.handleNodeDeleted(event);
    }

    private void handleScheduledOutagesChanged(Event event) {
        try {
            this.log().info((Object)"Reloading Collectd config factory");
            CollectdConfigFactory.reload();
            this.refreshServicePackages();
        }
        catch (Exception e) {
            this.log().error((Object)("Failed to reload CollectdConfigFactory because " + e.getMessage()), (Throwable)e);
        }
    }

    private void deinstallMessageSelectors() {
        this.getEventIpcManager().removeEventListener(this);
    }

    private void handleConfigureSNMP(Event event) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"configureSNMPHandler: processing configure SNMP event...");
        }
        String firstIPAddress = null;
        String lastIPAddress = null;
        String communityString = null;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            Enumeration parmEnum = parms.enumerateParm();
            while (parmEnum.hasMoreElements()) {
                Parm parm = (Parm)parmEnum.nextElement();
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (parmName.equals("firstIPAddress")) {
                    firstIPAddress = parmContent;
                    continue;
                }
                if (parmName.equals("lastIPAddress")) {
                    lastIPAddress = parmContent;
                    continue;
                }
                if (!parmName.equals("communityString")) continue;
                communityString = parmContent;
            }
        }
        if (firstIPAddress != null && !firstIPAddress.equals("")) {
            int begin;
            int end = begin = new IPv4Address(firstIPAddress).getAddress();
            if (lastIPAddress != null && !lastIPAddress.equals("") && (end = new IPv4Address(lastIPAddress).getAddress()) < begin) {
                end = begin;
            }
            SnmpPeerFactory factory = SnmpPeerFactory.getInstance();
            for (int address = begin; address <= end; ++address) {
                try {
                    InetAddress ip = InetAddress.getByAddress(new IPv4Address(address).getAddressBytes());
                    factory.define(ip, communityString);
                    continue;
                }
                catch (Exception e) {
                    this.log().warn((Object)("configureSNMPHandler: Failed to process IP address " + IPv4Address.addressToString((int)address) + ": " + e.getMessage()), (Throwable)e);
                }
            }
            try {
                SnmpPeerFactory.saveCurrent();
            }
            catch (Exception e) {
                this.log().warn((Object)("configureSNMPHandler: Failed to store SNMP configuration: " + e.getMessage()), (Throwable)e);
            }
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("configureSNMPHandler: processing configure SNMP event for IP " + firstIPAddress + "-" + lastIPAddress + " completed."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInterfaceDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        Category log = this.log();
        int nodeId = (int)event.getNodeid();
        String ipAddr = event.getInterface();
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc = null;
            ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
            while (liter.hasNext()) {
                cSvc = liter.next();
                InetAddress addr = (InetAddress)cSvc.getAddress();
                if (cSvc.getNodeId() != nodeId || !addr.getHostName().equals(ipAddr)) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("interfaceDeletedHandler: processing of interfaceDeleted event for " + nodeId + "/" + ipAddr + " completed."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInterfaceReparented(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        Category log = this.log();
        if (log.isDebugEnabled()) {
            log.debug((Object)("interfaceReparentedHandler:  processing interfaceReparented event for " + event.getInterface()));
        }
        if (event.getInterface() == null) {
            return;
        }
        String oldNodeIdStr = null;
        String newNodeIdStr = null;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            Enumeration parmEnum = parms.enumerateParm();
            while (parmEnum.hasMoreElements()) {
                Parm parm = (Parm)parmEnum.nextElement();
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (parmName.equals("oldNodeID")) {
                    oldNodeIdStr = parmContent;
                    continue;
                }
                if (!parmName.equals("newNodeID")) continue;
                newNodeIdStr = parmContent;
            }
        }
        if (oldNodeIdStr == null || newNodeIdStr == null) {
            log.warn((Object)"interfaceReparentedHandler: old and new nodeId parms are required, unable to process.");
            return;
        }
        OnmsIpInterface iface = null;
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc2 = null;
            for (CollectableService cSvc2 : this.getCollectableServices()) {
                InetAddress addr = (InetAddress)cSvc2.getAddress();
                if (!addr.getHostAddress().equals(event.getInterface())) continue;
                CollectableService collectableService = cSvc2;
                synchronized (collectableService) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("interfaceReparentedHandler: got a CollectableService match for " + event.getInterface()));
                    }
                    CollectorUpdates updates = cSvc2.getCollectorUpdates();
                    if (iface == null) {
                        iface = this.getIpInterface((int)event.getNodeid(), event.getInterface());
                    }
                    updates.markForReparenting(oldNodeIdStr, newNodeIdStr, iface);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("interfaceReparentedHandler: marking " + event.getInterface() + " for reparenting for service SNMP."));
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("interfaceReparentedHandler: processing of interfaceReparented event for interface " + event.getInterface() + " completed."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        Category log = this.log();
        int nodeId = (int)event.getNodeid();
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc = null;
            ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
            while (liter.hasNext()) {
                cSvc = liter.next();
                if (cSvc.getNodeId() != nodeId) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("nodeDeletedHandler: processing of nodeDeleted event for nodeid " + nodeId + " completed."));
        }
    }

    private void handleNodeGainedService(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        EventUtils.checkService(event);
        this.scheduleForCollection(event);
    }

    private void scheduleForCollection(Event event) {
        CollectdConfigFactory cCfgFactory = CollectdConfigFactory.getInstance();
        cCfgFactory.rebuildPackageIpListMap();
        this.scheduleInterface((int)event.getNodeid(), event.getInterface(), event.getService(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrimarySnmpInterfaceChanged(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        Category log = this.log();
        if (log.isDebugEnabled()) {
            log.debug((Object)"primarySnmpInterfaceChangedHandler:  processing primary SNMP interface changed event...");
        }
        if (!event.getService().equals("SNMP")) {
            return;
        }
        String oldPrimaryIfAddr = null;
        String newPrimaryIfAddr = null;
        Parms parms = event.getParms();
        if (parms != null) {
            String parmName = null;
            Value parmValue = null;
            String parmContent = null;
            Enumeration parmEnum = parms.enumerateParm();
            while (parmEnum.hasMoreElements()) {
                Parm parm = (Parm)parmEnum.nextElement();
                parmName = parm.getParmName();
                parmValue = parm.getValue();
                if (parmValue == null) continue;
                parmContent = parmValue.getContent();
                if (parmName.equals("oldPrimarySnmpAddress")) {
                    oldPrimaryIfAddr = parmContent;
                    continue;
                }
                if (!parmName.equals("newPrimarySnmpAddress")) continue;
                newPrimaryIfAddr = parmContent;
            }
        }
        if (oldPrimaryIfAddr != null) {
            List<CollectableService> list = this.getCollectableServices();
            synchronized (list) {
                CollectableService cSvc = null;
                ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
                while (liter.hasNext()) {
                    cSvc = liter.next();
                    InetAddress addr = (InetAddress)cSvc.getAddress();
                    if (!addr.getHostAddress().equals(oldPrimaryIfAddr)) continue;
                    CollectableService collectableService = cSvc;
                    synchronized (collectableService) {
                        CollectorUpdates updates = cSvc.getCollectorUpdates();
                        updates.markForDeletion();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("primarySnmpInterfaceChangedHandler: marking " + oldPrimaryIfAddr + " as deleted for service SNMP."));
                        }
                    }
                    liter.remove();
                }
            }
        }
        this.scheduleForCollection(event);
        if (log.isDebugEnabled()) {
            log.debug((Object)("primarySnmpInterfaceChangedHandler: processing of primarySnmpInterfaceChanged event for nodeid " + event.getNodeid() + " completed."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReinitializePrimarySnmpInterface(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        Category log = this.log();
        if (event.getInterface() == null) {
            log.error((Object)"reinitializePrimarySnmpInterface event is missing an interface.");
            return;
        }
        OnmsIpInterface iface = null;
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            for (CollectableService cSvc : this.getCollectableServices()) {
                InetAddress addr = (InetAddress)cSvc.getAddress();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Comparing CollectableService ip address = " + addr.getHostAddress() + " and event ip interface = " + event.getInterface()));
                }
                if (!addr.getHostAddress().equals(event.getInterface())) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    if (iface == null) {
                        iface = this.getIpInterface((int)event.getNodeid(), event.getInterface());
                    }
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    updates.markForReinitialization(iface);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("reinitializePrimarySnmpInterfaceHandler: marking " + event.getInterface() + " for reinitialization for service SNMP."));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleServiceDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        EventUtils.checkInterface(event);
        EventUtils.checkService(event);
        Category log = this.log();
        if (!event.getService().equals("SNMP")) {
            return;
        }
        int nodeId = (int)event.getNodeid();
        String ipAddr = event.getInterface();
        String svcName = event.getService();
        List<CollectableService> list = this.getCollectableServices();
        synchronized (list) {
            CollectableService cSvc = null;
            ListIterator<CollectableService> liter = this.getCollectableServices().listIterator();
            while (liter.hasNext()) {
                cSvc = liter.next();
                InetAddress addr = (InetAddress)cSvc.getAddress();
                if ((cSvc.getNodeId() != nodeId || !addr.getHostName().equals(ipAddr)) && cSvc.getServiceName().equals(svcName)) continue;
                CollectableService collectableService = cSvc;
                synchronized (collectableService) {
                    CollectorUpdates updates = cSvc.getCollectorUpdates();
                    updates.markForDeletion();
                }
                liter.remove();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("serviceDeletedHandler: processing of serviceDeleted event for " + nodeId + "/" + ipAddr + "/" + svcName + " completed."));
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    private Scheduler getScheduler() {
        if (this.m_scheduler == null) {
            this.createScheduler();
        }
        return this.m_scheduler;
    }

    public void setCollectorConfigDao(CollectorConfigDao collectorConfigDao) {
        this.m_collectorConfigDao = collectorConfigDao;
    }

    private CollectorConfigDao getCollectorConfigDao() {
        return this.m_collectorConfigDao;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monSvcDao) {
        this.m_monSvcDao = monSvcDao;
    }

    private MonitoredServiceDao getMonitoredServiceDao() {
        return this.m_monSvcDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ifSvcDao) {
        this.m_ifSvcDao = ifSvcDao;
    }

    private IpInterfaceDao getIpInterfaceDao() {
        return this.m_ifSvcDao;
    }

    public void setTransactionTemplate(TransactionTemplate transTemplate) {
        this.m_transTemplate = transTemplate;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setServiceCollector(String svcName, ServiceCollector collector) {
        this.m_collectors.put(svcName, collector);
    }

    public ServiceCollector getServiceCollector(String svcName) {
        return this.m_collectors.get(svcName);
    }

    public Set<String> getCollectorNames() {
        return this.m_collectors.keySet();
    }

    private void instantiateCollectors() {
        this.log().debug((Object)"instantiateCollectors: Loading collectors");
        Collection collectors = this.getCollectorConfigDao().getCollectors();
        for (Collector collector : collectors) {
            String svcName = collector.getService();
            try {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("instantiateCollectors: Loading collector " + svcName + ", classname " + collector.getClassName()));
                }
                Class<?> cc = Class.forName(collector.getClassName());
                ServiceCollector sc = (ServiceCollector)cc.newInstance();
                Map properties = null;
                sc.initialize(properties);
                this.setServiceCollector(svcName, sc);
            }
            catch (Throwable t) {
                this.log().warn((Object)("instantiateCollectors: Failed to load collector " + collector.getClassName() + " for service " + svcName + ": " + t), t);
            }
        }
    }

    static class SchedulingCompletedFlag {
        boolean m_schedulingCompleted = false;

        SchedulingCompletedFlag() {
        }

        public synchronized void setSchedulingCompleted(boolean schedulingCompleted) {
            this.m_schedulingCompleted = schedulingCompleted;
        }

        public synchronized boolean isSchedulingCompleted() {
            return this.m_schedulingCompleted;
        }
    }
}

