/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.collectd.AbstractCollectionSetVisitor;
import org.opennms.netmgt.collectd.Attribute;
import org.opennms.netmgt.collectd.AttributeGroup;
import org.opennms.netmgt.collectd.AttributeType;
import org.opennms.netmgt.collectd.CollectionResource;
import org.opennms.netmgt.collectd.PersistOperationBuilder;
import org.opennms.netmgt.collectd.Persister;
import org.opennms.netmgt.collectd.ServiceParameters;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.model.RrdRepository;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.snmp.SnmpValue;

public class BasePersister
extends AbstractCollectionSetVisitor
implements Persister {
    private ServiceParameters m_params;
    private RrdRepository m_repository;
    private LinkedList stack = new LinkedList();
    private PersistOperationBuilder m_builder;

    public BasePersister() {
    }

    public BasePersister(ServiceParameters params) {
        this.m_params = params;
        this.m_repository = DataCollectionConfigFactory.getInstance().getRrdRepository(params.getCollectionName());
    }

    protected void commitBuilder() {
        String name = this.m_builder.getName();
        try {
            this.m_builder.commit();
            this.m_builder = null;
        }
        catch (RrdException e) {
            this.log().error((Object)("Unable to persist data for " + name), (Throwable)e);
        }
    }

    public void completeAttribute(Attribute attribute) {
        this.popShouldPersist();
    }

    public void completeGroup(AttributeGroup group) {
        this.popShouldPersist();
    }

    public void completeResource(CollectionResource resource) {
        this.popShouldPersist();
    }

    protected void createBuilder(CollectionResource resource, String name, AttributeType attributeType) {
        this.createBuilder(resource, name, Collections.singleton(attributeType));
    }

    protected void createBuilder(CollectionResource resource, String name, Set attributeTypes) {
        this.m_builder = new PersistOperationBuilder(this.m_repository, resource, name);
        for (AttributeType attrType : attributeTypes) {
            this.m_builder.declareAttribute(attrType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getCurrentProperties(File propertiesFile) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        FileInputStream fileInputStream = null;
        if (propertiesFile.exists()) {
            try {
                fileInputStream = new FileInputStream(propertiesFile);
                props.load(fileInputStream);
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException e) {
                    this.log().error((Object)"performUpdate: Error closing file.", (Throwable)e);
                }
            }
        }
        return props;
    }

    protected Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public void persistNumericAttribute(Attribute attribute) {
        this.log().debug((Object)("Persisting " + attribute));
        this.m_builder.setAttributeValue(attribute.getAttributeType(), attribute.getNumericValue());
    }

    public void persistStringAttribute(Attribute attribute) {
        try {
            String val;
            this.log().debug((Object)("Persisting " + attribute));
            RrdRepository repository = this.m_repository;
            CollectionResource resource = attribute.getResource();
            SnmpValue value = attribute.getValue();
            File resourceDir = resource.getResourceDir(repository);
            String string = val = value == null ? null : value.toString();
            if (val == null) {
                this.log().info((Object)("No data collected for attribute " + attribute + ". Skipping"));
                return;
            }
            File propertiesFile = new File(resourceDir, "strings.properties");
            Properties props = this.getCurrentProperties(propertiesFile);
            props.setProperty(attribute.getName(), val);
            this.saveUpdatedProperties(propertiesFile, props);
        }
        catch (IOException e) {
            this.log().error((Object)("Unable to save string attribute " + attribute), (Throwable)e);
        }
    }

    private boolean pop() {
        boolean top = this.top();
        this.stack.removeLast();
        return top;
    }

    protected boolean popShouldPersist() {
        return this.pop();
    }

    private void push(boolean b) {
        this.stack.addLast(b);
    }

    protected void pushShouldPersist(Attribute attribute) {
        this.pushShouldPersist(attribute.shouldPersist(this.m_params));
    }

    protected void pushShouldPersist(AttributeGroup group) {
        this.pushShouldPersist(group.shouldPersist(this.m_params));
    }

    private void pushShouldPersist(boolean shouldPersist) {
        this.push(this.top() && shouldPersist);
    }

    protected void pushShouldPersist(CollectionResource resource) {
        this.push(resource.shouldPersist(this.m_params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveUpdatedProperties(File propertiesFile, Properties props) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(propertiesFile);
            props.store(fileOutputStream, null);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                this.log().error((Object)"performUpdate: Error closing file.", (Throwable)e);
            }
        }
    }

    protected boolean shouldPersist() {
        return this.top();
    }

    protected void storeAttribute(Attribute attribute) {
        if (this.shouldPersist()) {
            attribute.storeAttribute(this);
        }
    }

    private boolean top() {
        return (Boolean)this.stack.getLast();
    }

    public void visitAttribute(Attribute attribute) {
        this.pushShouldPersist(attribute);
        this.storeAttribute(attribute);
    }

    public void visitGroup(AttributeGroup group) {
        this.pushShouldPersist(group);
    }

    public void visitResource(CollectionResource resource) {
        this.log().info((Object)("Persisting data for resource " + resource));
        this.pushShouldPersist(resource);
    }
}

