/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.utils.ParameterMap;

public final class SnmpPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "SNMP";
    private static final String DEFAULT_OID = ".1.3.6.1.2.1.1.2.0";

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress address) {
        try {
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(address);
            return this.getValue(agentConfig, DEFAULT_OID) != null;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    private String getValue(SnmpAgentConfig agentConfig, String oid) {
        SnmpValue val = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)SnmpObjId.get((String)oid));
        return val == null ? null : val.toString();
    }

    public boolean isProtocolSupported(InetAddress address, Map qualifiers) {
        try {
            String retrievedValue;
            String oid = ParameterMap.getKeyedString(qualifiers, "vbname", DEFAULT_OID);
            SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(address);
            String expectedValue = null;
            if (qualifiers != null) {
                if (qualifiers.get("port") != null) {
                    int port = ParameterMap.getKeyedInteger(qualifiers, "port", agentConfig.getPort());
                    agentConfig.setPort(port);
                }
                if (qualifiers.get("timeout") != null) {
                    int timeout = ParameterMap.getKeyedInteger(qualifiers, "timeout", agentConfig.getTimeout());
                    agentConfig.setTimeout(timeout);
                }
                if (qualifiers.get("retry") != null) {
                    int retry = ParameterMap.getKeyedInteger(qualifiers, "retry", agentConfig.getRetries());
                    agentConfig.setRetries(retry);
                }
                if (qualifiers.get("force version") != null) {
                    String version = (String)qualifiers.get("force version");
                    if (version.equalsIgnoreCase("snmpv1")) {
                        agentConfig.setVersion(1);
                    } else if (version.equalsIgnoreCase("snmpv2") || version.equalsIgnoreCase("snmpv2c")) {
                        agentConfig.setVersion(2);
                    } else if (version.equalsIgnoreCase("snmpv3")) {
                        agentConfig.setVersion(3);
                    }
                }
                if (qualifiers.get("vbvalue") != null) {
                    expectedValue = (String)qualifiers.get("vbvalue");
                }
            }
            if ((retrievedValue = this.getValue(agentConfig, oid)) != null && expectedValue != null) {
                return Pattern.compile(expectedValue).matcher(retrievedValue).find();
            }
            return retrievedValue != null;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }
}

