/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.poller.nsclient.NsclientCheckParams;
import org.opennms.netmgt.poller.nsclient.NsclientException;
import org.opennms.netmgt.poller.nsclient.NsclientManager;
import org.opennms.netmgt.poller.nsclient.NsclientPacket;
import org.opennms.netmgt.utils.ParameterMap;

public class NsclientPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "NSCLIENT";
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress address) {
        throw new UnsupportedOperationException("Undirected TCP checking not supported");
    }

    public boolean isProtocolSupported(InetAddress address, Map qualifiers) {
        NsclientCheckParams params;
        NsclientPacket pack;
        Category log = ThreadCategory.getInstance(this.getClass());
        int retries = 0;
        int timeout = 5000;
        int port = NsclientManager.DEFAULT_PORT;
        String parameter = null;
        String command = null;
        int critPerc = 0;
        int warnPerc = 0;
        if (qualifiers != null) {
            command = ParameterMap.getKeyedString(qualifiers, "command", NsclientManager.convertTypeToString((short)1));
            port = ParameterMap.getKeyedInteger(qualifiers, "port", NsclientManager.DEFAULT_PORT);
            retries = ParameterMap.getKeyedInteger(qualifiers, "retry", 0);
            timeout = ParameterMap.getKeyedInteger(qualifiers, "timeout", 5000);
            parameter = ParameterMap.getKeyedString(qualifiers, "parameter", null);
            critPerc = ParameterMap.getKeyedInteger(qualifiers, "criticalPercent", 0);
            warnPerc = ParameterMap.getKeyedInteger(qualifiers, "warningPercent", 0);
        }
        if ((pack = this.isServer(address, port, command, retries, timeout, params = new NsclientCheckParams(critPerc, warnPerc, parameter))) == null) {
            log.error((Object)"Received a null packet response from isServer.");
            return false;
        }
        return pack.getResultCode() != 2 && pack.getResultCode() != -1;
    }

    private NsclientPacket isServer(InetAddress host, int port, String command, int retries, int timeout, NsclientCheckParams params) {
        boolean isAServer = false;
        Category log = ThreadCategory.getInstance(this.getClass());
        for (int attempts = 0; attempts <= retries && !isAServer; ++attempts) {
            try {
                NsclientManager client = new NsclientManager(host.getHostAddress(), port);
                NsclientPacket response = null;
                client.setTimeout(timeout);
                client.init();
                response = client.processCheckCommand(NsclientManager.convertStringToType(command), params);
                log.debug((Object)("NsclientPlugin: " + command + ": " + response.getResponse()));
                isAServer = true;
                return response;
            }
            catch (NsclientException e) {
                log.debug((Object)("NsclientPlugin: Check failed: " + e.getMessage()));
                log.error((Object)("NsclientManager returned exception: " + e.getMessage() + " : " + e.getCause().getMessage()));
                isAServer = false;
                continue;
            }
        }
        return null;
    }
}

