/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.net.InetAddress;
import java.util.Map;
import org.opennms.netmgt.capsd.Plugin;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.utils.ParameterMap;

public class LoopPlugin
implements Plugin {
    private String m_protocolName = "LOOP";

    public String getProtocolName() {
        return this.m_protocolName;
    }

    public boolean isProtocolSupported(InetAddress address) {
        return this.isProtocolSupported(address, null);
    }

    public boolean isProtocolSupported(InetAddress address, Map qualifiers) {
        if (qualifiers == null) {
            return false;
        }
        String ipMatch = this.getIpMatch(qualifiers);
        if (SnmpPeerFactory.verifyIpMatch(address.getHostAddress(), ipMatch)) {
            return this.isSupported(qualifiers);
        }
        return false;
    }

    private boolean isSupported(Map parameters) {
        return ParameterMap.getKeyedString(parameters, "is-supported", "false").equalsIgnoreCase("true");
    }

    private String getIpMatch(Map parameters) {
        return ParameterMap.getKeyedString(parameters, "ip-match", "*.*.*.*");
    }
}

