/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractPlugin;
import org.opennms.netmgt.ping.Packet;
import org.opennms.netmgt.ping.Reply;
import org.opennms.netmgt.ping.ReplyReceiver;
import org.opennms.netmgt.utils.ParameterMap;
import org.opennms.protocols.icmp.IcmpSocket;

public final class IcmpPlugin
extends AbstractPlugin {
    private static final String PROTOCOL_NAME = "ICMP";
    private static final int DEFAULT_RETRY = 2;
    private static final int DEFAULT_TIMEOUT = 800;
    private static final short FILTER_ID = (short)new Random(System.currentTimeMillis()).nextInt();
    private static short m_seqid = (short)-16657;
    private static ReplyReceiver m_receiver = null;
    private static IcmpSocket m_icmpSock = null;
    private static Map m_waiting = Collections.synchronizedMap(new TreeMap());
    private static Thread m_worker = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IcmpPlugin() throws IOException {
        Class<IcmpPlugin> clazz = IcmpPlugin.class;
        synchronized (IcmpPlugin.class) {
            if (m_worker == null) {
                final FifoQueueImpl q = new FifoQueueImpl();
                m_icmpSock = new IcmpSocket();
                m_receiver = new ReplyReceiver(m_icmpSock, (FifoQueue)q, FILTER_ID);
                m_receiver.start();
                m_worker = new Thread(new Runnable(){

                    public void run() {
                        while (true) {
                            Reply pong = null;
                            try {
                                pong = (Reply)q.remove();
                            }
                            catch (InterruptedException ex) {
                                break;
                            }
                            catch (Exception ex) {
                                ThreadCategory.getInstance(this.getClass()).error((Object)"Error processing response queue", (Throwable)ex);
                            }
                            Long key = new Long(pong.getPacket().getTID());
                            Ping ping = (Ping)m_waiting.get(key);
                            if (ping == null || !ping.isTarget(pong.getAddress())) continue;
                            ping.signal();
                        }
                    }
                }, "IcmpPlugin-Receiver");
                m_worker.setDaemon(true);
                m_worker.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static synchronized DatagramPacket getDatagram(InetAddress addr, long tid) {
        Packet iPkt = new Packet(tid);
        iPkt.setIdentity(FILTER_ID);
        short s = m_seqid;
        m_seqid = (short)(s + 1);
        iPkt.setSequenceId(s);
        iPkt.computeChecksum();
        byte[] data = iPkt.toBytes();
        return new DatagramPacket(data, data.length, addr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPingable(InetAddress ipv4Addr, int retries, long timeout) {
        Category log = ThreadCategory.getInstance(this.getClass());
        Long tidKey = null;
        long tid = Thread.currentThread().hashCode();
        Map map = m_waiting;
        synchronized (map) {
            while (m_waiting.containsKey(tidKey = new Long(tid))) {
                ++tid;
            }
        }
        DatagramPacket pkt = IcmpPlugin.getDatagram(ipv4Addr, tid);
        Ping reply = new Ping(ipv4Addr);
        m_waiting.put(tidKey, reply);
        for (int attempts = 0; attempts <= retries && !reply.isSignaled(); ++attempts) {
            Ping ping = reply;
            synchronized (ping) {
                try {
                    m_icmpSock.send(pkt);
                }
                catch (IOException ioE) {
                    log.info((Object)("isPingable: Failed to send to address " + ipv4Addr), (Throwable)ioE);
                    break;
                }
                catch (Throwable t) {
                    log.info((Object)("isPingable: Undeclared throwable exception caught sending to " + ipv4Addr), t);
                    break;
                }
                try {
                    reply.wait(timeout);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        m_waiting.remove(tidKey);
        boolean pingable = false;
        if (reply.isSignaled()) {
            pingable = true;
        }
        return pingable;
    }

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public boolean isProtocolSupported(InetAddress address) {
        return this.isPingable(address, 2, 800L);
    }

    public boolean isProtocolSupported(InetAddress address, Map qualifiers) {
        int retries = 2;
        int timeout = 800;
        if (qualifiers != null) {
            retries = ParameterMap.getKeyedInteger(qualifiers, "retry", 2);
            timeout = ParameterMap.getKeyedInteger(qualifiers, "timeout", 800);
        }
        return this.isPingable(address, retries, timeout);
    }

    private static final class Ping {
        private final InetAddress m_addr;
        private boolean m_signaled;

        Ping(InetAddress addr) {
            this.m_addr = addr;
        }

        synchronized boolean isSignaled() {
            return this.m_signaled;
        }

        synchronized void signal() {
            this.m_signaled = true;
            this.notifyAll();
        }

        boolean isTarget(InetAddress addr) {
            return this.m_addr.equals(addr);
        }
    }
}

