/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.AbstractTcpPlugin;
import org.opennms.netmgt.capsd.ConnectionConfig;

public class HttpPlugin
extends AbstractTcpPlugin {
    public static final boolean CHECK_RETURN_CODE = true;
    private static final int[] DEFAULT_PORTS = new int[]{80, 8080, 8888};
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    public static final String PROTOCOL_NAME = "HTTP";
    public static final String QUERY_STRING = "GET / HTTP/1.0\r\n\r\n";
    public static final String DEFAULT_URL = "/";
    public static final String RESPONSE_STRING = "HTTP/";
    private boolean m_checkReturnCode = true;
    private int[] m_defaultPorts;
    private String m_queryString = "GET / HTTP/1.0\r\n\r\n";
    private String m_responseString = "HTTP/";

    public HttpPlugin() {
        this(PROTOCOL_NAME, true, QUERY_STRING, RESPONSE_STRING, DEFAULT_PORTS);
    }

    protected HttpPlugin(String protocolName, boolean checkReturnCode, String queryString, String responseString) {
        this(protocolName, checkReturnCode, queryString, responseString, DEFAULT_PORTS);
    }

    protected HttpPlugin(String protocolName, boolean checkReturnCode, String queryString, String responseString, int[] defaultPorts) {
        super(protocolName, 5000, 0);
        this.m_checkReturnCode = checkReturnCode;
        this.m_queryString = queryString;
        this.m_responseString = responseString;
        this.m_defaultPorts = defaultPorts;
    }

    protected boolean checkProtocol(Socket socket, ConnectionConfig config) throws IOException {
        boolean isAServer = false;
        this.m_queryString = "GET " + config.getKeyedString("url", DEFAULT_URL) + " HTTP/1.0\r\n\r\n";
        Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)("Query: " + this.m_queryString));
        try {
            StringBuffer response;
            block10: {
                BufferedReader lineRdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                socket.getOutputStream().write(this.m_queryString.getBytes());
                char[] cbuf = new char[1024];
                int chars = 0;
                response = new StringBuffer();
                try {
                    while ((chars = lineRdr.read(cbuf, 0, 1024)) != -1) {
                        String line = new String(cbuf, 0, chars);
                        log.debug((Object)("Read: " + line.length() + " bytes: [" + line.toString() + "] from socket."));
                        response.append(line);
                    }
                }
                catch (SocketTimeoutException timeoutEx) {
                    if (timeoutEx.bytesTransferred <= 0) break block10;
                    String line = new String(cbuf, 0, timeoutEx.bytesTransferred);
                    log.debug((Object)("Read: " + line.length() + " bytes: [" + line.toString() + "] from socket @ timeout!"));
                    response.append(line);
                }
            }
            if (response.toString() != null && response.toString().indexOf(this.m_responseString) > -1) {
                if (this.m_checkReturnCode) {
                    int maxRetCode = config.getKeyedInteger("max-ret-code", 399);
                    if (DEFAULT_URL.equals(config.getKeyedString("url", DEFAULT_URL)) || !config.getKeyedBoolean("check-return-code", true)) {
                        maxRetCode = 600;
                    }
                    StringTokenizer t = new StringTokenizer(response.toString());
                    t.nextToken();
                    int rVal = Integer.parseInt(t.nextToken());
                    log.debug((Object)(this.getPluginName() + ": Request returned code: " + rVal));
                    if (rVal >= 99 && rVal <= maxRetCode) {
                        isAServer = true;
                    }
                } else {
                    isAServer = true;
                }
            }
        }
        catch (NumberFormatException e) {
            log.debug((Object)(this.getPluginName() + ": failed to parse response code from host " + config.getInetAddress().getHostAddress()), (Throwable)e);
            isAServer = false;
        }
        return isAServer;
    }

    protected List getConnectionConfigList(Map qualifiers, InetAddress address) {
        int[] ports = this.getKeyedIntegerArray(qualifiers, "port", this.m_defaultPorts);
        LinkedList<ConnectionConfig> list = new LinkedList<ConnectionConfig>();
        for (int i = 0; i < ports.length; ++i) {
            list.add(this.createConnectionConfig(address, ports[i]));
        }
        return list;
    }
}

