/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.IfSmbCollector;
import org.opennms.netmgt.capsd.IfSnmpCollector;
import org.opennms.netmgt.capsd.KnownIPMgr;
import org.opennms.netmgt.capsd.Plugin;
import org.opennms.netmgt.capsd.snmp.IfTableEntry;
import org.opennms.netmgt.capsd.snmp.IpAddrTable;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.CapsdConfigManager;

public final class IfCollector
implements Runnable {
    private final InetAddress m_target;
    private IfSmbCollector m_smbCollector;
    private IfSnmpCollector m_snmpCollector;
    private List m_protocols;
    private Map m_subTargets;
    private List m_nonIpInterfaces;
    private boolean m_doSnmpCollection;
    private Set m_previouslyProbed;

    private static void probe(InetAddress target, List supports) {
        Category log = ThreadCategory.getInstance(IfCollector.class);
        String logAddr = target.getHostAddress();
        CapsdConfigManager.ProtocolInfo[] plugins = CapsdConfigFactory.getInstance().getProtocolSpecification(target);
        for (int i = 0; i < plugins.length; ++i) {
            log.debug((Object)(logAddr + " testing plugin " + plugins[i].getProtocol()));
            if (plugins[i].autoEnabled()) {
                log.debug((Object)(logAddr + " protocol " + plugins[i].getProtocol() + " is auto enabled"));
                supports.add(new SupportedProtocol(plugins[i].getProtocol(), null));
                continue;
            }
            try {
                Plugin p = plugins[i].getPlugin();
                Map q = plugins[i].getParameters();
                boolean r = p.isProtocolSupported(target, q);
                log.debug((Object)(logAddr + " protocol " + plugins[i].getProtocol() + " supported? " + (r ? "true" : "false")));
                if (r) {
                    supports.add(new SupportedProtocol(plugins[i].getProtocol(), q));
                }
            }
            catch (UndeclaredThrowableException utE) {
                Throwable t = utE.getUndeclaredThrowable();
                if (t instanceof NoRouteToHostException) {
                    if (CapsdConfigFactory.getInstance().getAbortProtocolScansFlag()) {
                        log.warn((Object)("IfCollector: No route to host " + logAddr + ", aborting protocol scans."));
                        break;
                    }
                    log.warn((Object)("IfCollector: No route to host " + logAddr + ", continuing protocol scans."));
                } else {
                    log.warn((Object)("IfCollector: Caught undeclared throwable exception when testing for protocol " + plugins[i].getProtocol() + " on host " + logAddr), (Throwable)utE);
                }
            }
            catch (Throwable t) {
                log.warn((Object)("IfCollector: Caught an exception when testing for protocol " + plugins[i].getProtocol() + " on host " + logAddr), t);
            }
            log.debug((Object)(logAddr + " plugin " + plugins[i].getProtocol() + " completed!"));
        }
    }

    IfCollector() {
        throw new UnsupportedOperationException("default construction not available!");
    }

    IfCollector(InetAddress addr, boolean doSnmpCollection) {
        this(addr, doSnmpCollection, new HashSet());
    }

    IfCollector(InetAddress addr, boolean doSnmpCollection, Set previouslyProbed) {
        this.m_target = addr;
        this.m_doSnmpCollection = doSnmpCollection;
        this.m_smbCollector = null;
        this.m_snmpCollector = null;
        this.m_protocols = new ArrayList(8);
        this.m_subTargets = null;
        this.m_nonIpInterfaces = null;
        this.m_previouslyProbed = previouslyProbed;
    }

    InetAddress getTarget() {
        return this.m_target;
    }

    List getSupportedProtocols() {
        return this.m_protocols;
    }

    boolean hasAdditionalTargets() {
        return this.m_subTargets != null && !this.m_subTargets.isEmpty();
    }

    Map getAdditionalTargets() {
        return this.m_subTargets;
    }

    boolean hasNonIpInterfaces() {
        return this.m_nonIpInterfaces != null && !this.m_nonIpInterfaces.isEmpty();
    }

    List getNonIpInterfaces() {
        return this.m_nonIpInterfaces;
    }

    boolean hasSmbCollection() {
        return this.m_smbCollector != null;
    }

    IfSmbCollector getSmbCollector() {
        return this.m_smbCollector;
    }

    boolean hasSnmpCollection() {
        return this.m_snmpCollector != null;
    }

    IfSnmpCollector getSnmpCollector() {
        return this.m_snmpCollector;
    }

    void deleteSnmpCollector() {
        this.m_snmpCollector = null;
    }

    public void run() {
        Category log = ThreadCategory.getInstance(IfCollector.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("IfCollector.run: run method invoked to collect information for address " + this.m_target.getHostAddress()));
        }
        boolean isSnmp = false;
        boolean isSnmpV2 = false;
        boolean isSmb = false;
        boolean hasExchange = false;
        IfCollector.probe(this.m_target, this.m_protocols);
        this.m_previouslyProbed.add(this.m_target);
        for (SupportedProtocol proto : this.m_protocols) {
            if (proto.getProtocolName().equalsIgnoreCase("snmp")) {
                isSnmp = true;
                continue;
            }
            if (proto.getProtocolName().equalsIgnoreCase("smb")) {
                isSmb = true;
                continue;
            }
            if (!proto.getProtocolName().equalsIgnoreCase("msexchange")) continue;
            isSmb = true;
            hasExchange = true;
        }
        if (isSmb) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IfCollector.run: starting SMB collection");
            }
            try {
                this.m_smbCollector = new IfSmbCollector(this.m_target, hasExchange);
                this.m_smbCollector.run();
            }
            catch (Throwable t) {
                this.m_smbCollector = null;
                log.warn((Object)("IfCollector.run: Caught an exception when collecting SMB information from target " + this.m_target.getHostAddress()), t);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"IfCollector.run: SMB collection completed");
            }
        }
        if ((isSnmp || isSnmpV2) && this.m_doSnmpCollection) {
            block31: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"IfCollector.run: starting SNMP collection");
                }
                try {
                    this.m_snmpCollector = new IfSnmpCollector(this.m_target);
                    this.m_snmpCollector.run();
                    if (this.m_snmpCollector.hasIpAddrTable() && this.m_snmpCollector.hasIfTable()) {
                        this.m_subTargets = new TreeMap(KnownIPMgr.AddrComparator.comparator);
                        this.m_nonIpInterfaces = new ArrayList();
                        for (IfTableEntry ifEntry : this.m_snmpCollector.getIfTable().getEntries()) {
                            Integer ifIndex = ifEntry.getIfIndex();
                            if (ifIndex == null) continue;
                            ArrayList<InetAddress> ipAddrs = IpAddrTable.getIpAddresses(this.m_snmpCollector.getIpAddrTable().getEntries(), ifIndex);
                            if (ipAddrs == null || ipAddrs.size() == 0) {
                                InetAddress nonIpAddr = null;
                                try {
                                    nonIpAddr = InetAddress.getByName("0.0.0.0");
                                }
                                catch (UnknownHostException e) {
                                    log.info((Object)("IfCollector.run: Failed to create InetAddress for Non IP interface at ifIndex  " + ifIndex + " for original target " + this.m_target.getHostAddress()), (Throwable)e);
                                }
                                if (ipAddrs == null) {
                                    ipAddrs = new ArrayList<InetAddress>();
                                }
                                ipAddrs.add(nonIpAddr);
                            }
                            for (InetAddress subtarget : ipAddrs) {
                                Integer ifType;
                                if (subtarget == null || subtarget.equals(this.m_target) || this.m_previouslyProbed.contains(subtarget) || (ifType = ifEntry.getIfType()) == null) continue;
                                if (subtarget.getHostAddress().startsWith("127")) {
                                    if (!log.isDebugEnabled()) continue;
                                    log.debug((Object)("ifCollector.run: Loopback interface: " + subtarget.getHostAddress() + ", skipping..."));
                                    continue;
                                }
                                if (subtarget.getHostAddress().equals("0.0.0.0")) {
                                    this.m_nonIpInterfaces.add(ifIndex);
                                    continue;
                                }
                                ArrayList probelist = new ArrayList();
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"----------------------------------------------------------------------------------------");
                                    log.debug((Object)("ifCollector.run: probing subtarget " + subtarget.getHostAddress()));
                                }
                                IfCollector.probe(subtarget, probelist);
                                this.m_previouslyProbed.add(subtarget);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("ifCollector.run: adding subtarget " + subtarget.getHostAddress() + " # supported protocols: " + probelist.size()));
                                    log.debug((Object)"----------------------------------------------------------------------------------------");
                                }
                                this.m_subTargets.put(subtarget, probelist);
                            }
                        }
                        break block31;
                    }
                    if (this.m_snmpCollector.hasIpAddrTable()) {
                        this.m_subTargets = new TreeMap(KnownIPMgr.AddrComparator.comparator);
                        List ipAddrs = IpAddrTable.getIpAddresses(this.m_snmpCollector.getIpAddrTable().getEntries());
                        for (InetAddress subtarget : ipAddrs) {
                            if (subtarget == null || subtarget.equals(this.m_target)) continue;
                            if (subtarget.getHostAddress().startsWith("127")) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)("ifCollector.run: Loopback interface: " + subtarget.getHostAddress() + ", skipping..."));
                                continue;
                            }
                            ArrayList probelist = new ArrayList();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"----------------------------------------------------------------------------------------");
                                log.debug((Object)("ifCollector.run: probing subtarget " + subtarget.getHostAddress()));
                            }
                            IfCollector.probe(subtarget, probelist);
                            this.m_previouslyProbed.add(subtarget);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("ifCollector.run: adding subtarget " + subtarget.getHostAddress() + " # supported protocols: " + probelist.size()));
                                log.debug((Object)"----------------------------------------------------------------------------------------");
                            }
                            this.m_subTargets.put(subtarget, probelist);
                        }
                    }
                }
                catch (Throwable t) {
                    this.m_snmpCollector = null;
                    log.warn((Object)("IfCollector.run: Caught an exception when collecting SNMP information from target " + this.m_target.getHostAddress()), t);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"IfCollector.run: SNMP collection completed");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("IfCollector.run: run method exiting after collecting information from address " + this.m_target.getHostAddress()));
        }
    }

    static final class SupportedProtocol {
        private final String m_name;
        private final Map m_qualifiers;

        SupportedProtocol(String protoName, Map qualifiers) {
            this.m_name = protoName;
            this.m_qualifiers = qualifiers;
        }

        String getProtocolName() {
            return this.m_name;
        }

        Map getQualifiers() {
            return this.m_qualifiers;
        }
    }
}

