/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.EventConstants;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbSnmpInterfaceEntry;
import org.opennms.netmgt.config.DataSourceFactory;

final class DbNodeEntry {
    static final char NODE_TYPE_ACTIVE = 'A';
    static final char NODE_TYPE_DELETED = 'D';
    static final char NODE_TYPE_UNKNOWN = ' ';
    static final char LABEL_SOURCE_USER = 'U';
    static final char LABEL_SOURCE_NETBIOS = 'N';
    static final char LABEL_SOURCE_HOSTNAME = 'H';
    static final char LABEL_SOURCE_SYSNAME = 'S';
    static final char LABEL_SOURCE_ADDRESS = 'A';
    static final char LABEL_SOURCE_UNKNOWN = ' ';
    private static final String DEFAULT_DP_NAME = "localhost";
    private static final String SQL_NEXT_NID = "SELECT NEXTVAL('nodeNxtId')";
    private static final String SQL_LOAD_REC = "SELECT nodeCreateTime, nodeParentID, nodeType, nodeSysOID, nodeSysName, nodeSysDescription, nodeSysLocation, nodeSysContact, nodeLabel, nodeLabelSource, nodeNetBIOSName, nodeDomainName, operatingSystem, lastCapsdPoll FROM node WHERE nodeID = ? AND dpName = ? AND nodeType != 'D'";
    private static final String SQL_LOAD_IF_LIST = "SELECT ipAddr, ifIndex FROM ipInterface WHERE nodeID = ? AND isManaged != 'D'";
    private static final String SQL_LOAD_MANAGED_IF_LIST = "SELECT ipAddr, ifIndex FROM ipInterface WHERE nodeID = ? AND isManaged = 'M'";
    private static final String SQL_LOAD_SNMP_LIST = "SELECT ipAddr, snmpIfIndex FROM snmpInterface WHERE nodeID = ?";
    private boolean m_fromDb = false;
    private int m_nodeId = -1;
    private String m_dpName;
    private Timestamp m_createTime;
    private int m_parentId;
    private char m_type;
    private String m_sysoid;
    private String m_sysname;
    private String m_sysdescr;
    private String m_syslocation;
    private String m_syscontact;
    private String m_label;
    private char m_labelSource;
    private String m_nbName;
    private String m_nbDomainName;
    private String m_os;
    private Timestamp m_lastPoll;
    private int m_changed;
    private static final int CHANGED_CREATE_TIME = 1;
    private static final int CHANGED_PARENT_ID = 2;
    private static final int CHANGED_TYPE = 4;
    private static final int CHANGED_SYSOID = 8;
    private static final int CHANGED_SYSNAME = 16;
    private static final int CHANGED_SYSLOC = 32;
    private static final int CHANGED_SYSCONTACT = 64;
    private static final int CHANGED_LABEL = 128;
    private static final int CHANGED_LABEL_SOURCE = 256;
    private static final int CHANGED_NETBIOS_NAME = 512;
    private static final int CHANGED_DOMAIN_NAME = 1024;
    private static final int CHANGED_OS = 2048;
    private static final int CHANGED_DPNAME = 4096;
    private static final int CHANGED_SYSDESCR = 8192;
    private static final int CHANGED_POLLTIME = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Connection c) throws SQLException {
        if (this.m_fromDb) {
            throw new IllegalStateException("The record already exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            stmt = c.prepareStatement(SQL_NEXT_NID);
            rset = stmt.executeQuery();
            rset.next();
            this.m_nodeId = rset.getInt(1);
            rset.close();
            rset = null;
            stmt.close();
            stmt = null;
            StringBuffer names = new StringBuffer("INSERT INTO node (nodeID,dpName");
            StringBuffer values = new StringBuffer("?");
            if ((this.m_changed & 0x1000) == 4096) {
                values.append(",?");
            } else {
                values.append(",'").append(DEFAULT_DP_NAME).append("'");
            }
            if ((this.m_changed & 2) == 2) {
                values.append(",?");
                names.append(",nodeParentID");
            }
            if ((this.m_changed & 4) == 4) {
                values.append(",?");
                names.append(",nodeType");
            }
            if ((this.m_changed & 1) == 1) {
                values.append(",?");
                names.append(",nodeCreateTime");
            } else {
                values.append(",?");
                names.append(",nodeCreateTime");
                this.m_createTime = new Timestamp(new Date().getTime());
                this.m_changed |= 1;
            }
            if ((this.m_changed & 8) == 8) {
                values.append(",?");
                names.append(",nodeSysOID");
            }
            if ((this.m_changed & 0x10) == 16) {
                values.append(",?");
                names.append(",nodeSysName");
            }
            if ((this.m_changed & 0x2000) == 8192) {
                values.append(",?");
                names.append(",nodeSysDescription");
            }
            if ((this.m_changed & 0x20) == 32) {
                values.append(",?");
                names.append(",nodeSysLocation");
            }
            if ((this.m_changed & 0x40) == 64) {
                values.append(",?");
                names.append(",nodeSysContact");
            }
            if ((this.m_changed & 0x80) == 128) {
                values.append(",?");
                names.append(",nodeLabel");
            }
            if ((this.m_changed & 0x100) == 256) {
                values.append(",?");
                names.append(",nodeLabelSource");
            }
            if ((this.m_changed & 0x200) == 512) {
                values.append(",?");
                names.append(",nodeNetBIOSName");
            }
            if ((this.m_changed & 0x400) == 1024) {
                values.append(",?");
                names.append(",nodeDomainName");
            }
            if ((this.m_changed & 0x800) == 2048) {
                values.append(",?");
                names.append(",operatingSystem");
            }
            if ((this.m_changed & 0x4000) == 16384) {
                values.append(",?");
                names.append(",lastCapsdPoll");
            }
            names.append(") VALUES (").append(values).append(')');
            log.debug((Object)("DbNodeEntry.insert: SQL insert statment = " + names.toString()));
            stmt = c.prepareStatement(names.toString());
            names = null;
            int ndx = 1;
            stmt.setInt(ndx++, this.m_nodeId);
            if ((this.m_changed & 0x1000) == 4096) {
                stmt.setString(ndx++, this.m_dpName);
            }
            if ((this.m_changed & 2) == 2) {
                if (this.m_parentId == -1) {
                    stmt.setNull(ndx++, 4);
                } else {
                    stmt.setInt(ndx++, this.m_parentId);
                }
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setString(ndx++, new String(new char[]{this.m_type}));
            }
            if ((this.m_changed & 1) == 1) {
                stmt.setTimestamp(ndx++, this.m_createTime);
            }
            if ((this.m_changed & 8) == 8) {
                stmt.setString(ndx++, this.m_sysoid);
            }
            if ((this.m_changed & 0x10) == 16) {
                stmt.setString(ndx++, this.m_sysname);
            }
            if ((this.m_changed & 0x2000) == 8192) {
                stmt.setString(ndx++, this.m_sysdescr);
            }
            if ((this.m_changed & 0x20) == 32) {
                stmt.setString(ndx++, this.m_syslocation);
            }
            if ((this.m_changed & 0x40) == 64) {
                stmt.setString(ndx++, this.m_syscontact);
            }
            if ((this.m_changed & 0x80) == 128) {
                stmt.setString(ndx++, this.m_label);
            }
            if ((this.m_changed & 0x100) == 256) {
                stmt.setString(ndx++, new String(new char[]{this.m_labelSource}));
            }
            if ((this.m_changed & 0x200) == 512) {
                stmt.setString(ndx++, this.m_nbName);
            }
            if ((this.m_changed & 0x400) == 1024) {
                stmt.setString(ndx++, this.m_nbDomainName);
            }
            if ((this.m_changed & 0x800) == 2048) {
                stmt.setString(ndx++, this.m_os);
            }
            if ((this.m_changed & 0x4000) == 16384) {
                stmt.setTimestamp(ndx++, this.m_lastPoll);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("nodeid='" + this.m_nodeId + "'" + " nodetype='" + new String(new char[]{this.m_type}) + "'" + " createTime='" + this.m_createTime + "'" + " lastPoll='" + this.m_lastPoll + "'" + " dpName='" + this.m_dpName + "'" + " sysname='" + this.m_sysname + "'" + " sysoid='" + this.m_sysoid + "'" + " sysdescr='" + this.m_sysdescr + "'" + " syslocation='" + this.m_syslocation + "'" + " syscontact='" + this.m_syscontact + "'" + " label='" + this.m_label + "'" + " labelsource='" + new String(new char[]{this.m_labelSource}) + "'" + " netbios='" + this.m_nbName + "'" + " domain='" + this.m_nbDomainName + "'" + " os='" + this.m_os + "'"));
            }
            int rc = stmt.executeUpdate();
            log.debug((Object)("DbNodeEntry.insert: SQL update result = " + rc));
            this.createAssetNodeEntry(c, this.m_nodeId);
            this.m_fromDb = true;
            this.m_changed = 0;
        }
        finally {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Connection c) throws SQLException {
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        StringBuffer sqlText = new StringBuffer("UPDATE node SET ");
        int comma = 32;
        if ((this.m_changed & 2) == 2) {
            sqlText.append((char)comma).append("nodeParentID = ?");
            comma = 44;
        }
        if ((this.m_changed & 4) == 4) {
            sqlText.append((char)comma).append("nodeType = ?");
            comma = 44;
        }
        if ((this.m_changed & 1) == 1) {
            sqlText.append((char)comma).append("nodeCreateTime = ?");
            comma = 44;
        }
        if ((this.m_changed & 8) == 8) {
            sqlText.append((char)comma).append("nodeSysOID = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x10) == 16) {
            sqlText.append((char)comma).append("nodeSysName = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x2000) == 8192) {
            sqlText.append((char)comma).append("nodeSysDescription = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x20) == 32) {
            sqlText.append((char)comma).append("nodeSysLocation = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x40) == 64) {
            sqlText.append((char)comma).append("nodeSysContact = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x80) == 128) {
            sqlText.append((char)comma).append("nodeLabel = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x100) == 256) {
            sqlText.append((char)comma).append("nodeLabelSource = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x200) == 512) {
            sqlText.append((char)comma).append("nodeNetBIOSName = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x400) == 1024) {
            sqlText.append((char)comma).append("nodeDomainName = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x800) == 2048) {
            sqlText.append((char)comma).append("operatingSystem = ?");
            comma = 44;
        }
        if ((this.m_changed & 0x4000) == 16384) {
            sqlText.append((char)comma).append("lastCapsdPoll = ?");
            comma = 44;
        }
        sqlText.append(" WHERE nodeID = ? AND dpName = ?");
        log.debug((Object)("DbNodeEntry.update: SQL update statment = " + sqlText.toString()));
        PreparedStatement stmt = null;
        try {
            stmt = c.prepareStatement(sqlText.toString());
            sqlText = null;
            int ndx = 1;
            if ((this.m_changed & 2) == 2) {
                if (this.m_parentId == -1) {
                    stmt.setNull(ndx++, 4);
                } else {
                    stmt.setInt(ndx++, this.m_parentId);
                }
            }
            if ((this.m_changed & 4) == 4) {
                stmt.setString(ndx++, new String(new char[]{this.m_type}));
            }
            if ((this.m_changed & 1) == 1) {
                if (this.m_createTime == null) {
                    stmt.setNull(ndx++, 93);
                } else {
                    stmt.setTimestamp(ndx++, this.m_createTime);
                }
            }
            if ((this.m_changed & 8) == 8) {
                if (this.m_sysoid == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_sysoid);
                }
            }
            if ((this.m_changed & 0x10) == 16) {
                if (this.m_sysname == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_sysname);
                }
            }
            if ((this.m_changed & 0x2000) == 8192) {
                if (this.m_sysdescr == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_sysdescr);
                }
            }
            if ((this.m_changed & 0x20) == 32) {
                if (this.m_syslocation == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_syslocation);
                }
            }
            if ((this.m_changed & 0x40) == 64) {
                if (this.m_syscontact == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_syscontact);
                }
            }
            if ((this.m_changed & 0x80) == 128) {
                if (this.m_label == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_label);
                }
            }
            if ((this.m_changed & 0x100) == 256) {
                stmt.setString(ndx++, new String(new char[]{this.m_labelSource}));
            }
            if ((this.m_changed & 0x200) == 512) {
                if (this.m_nbName == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_nbName);
                }
            }
            if ((this.m_changed & 0x400) == 1024) {
                if (this.m_nbDomainName == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_nbDomainName);
                }
            }
            if ((this.m_changed & 0x800) == 2048) {
                if (this.m_os == null) {
                    stmt.setNull(ndx++, 12);
                } else {
                    stmt.setString(ndx++, this.m_os);
                }
            }
            if ((this.m_changed & 0x4000) == 16384) {
                if (this.m_lastPoll != null) {
                    stmt.setTimestamp(ndx++, this.m_lastPoll);
                } else {
                    stmt.setNull(ndx++, 93);
                }
            }
            stmt.setInt(ndx++, this.m_nodeId);
            stmt.setString(ndx++, this.m_dpName);
            int rc = stmt.executeUpdate();
            log.debug((Object)("DbNodeEntry.update: update result = " + rc));
            this.m_changed = 0;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private boolean load(Connection c) throws SQLException {
        String str;
        if (!this.m_fromDb) {
            throw new IllegalStateException("The record does not exists in the database");
        }
        PreparedStatement stmt = c.prepareStatement(SQL_LOAD_REC);
        stmt.setInt(1, this.m_nodeId);
        stmt.setString(2, this.m_dpName);
        ResultSet rset = stmt.executeQuery();
        if (!rset.next()) {
            rset.close();
            stmt.close();
            return false;
        }
        int ndx = 1;
        this.m_createTime = rset.getTimestamp(ndx++);
        this.m_parentId = rset.getInt(ndx++);
        if (rset.wasNull()) {
            this.m_parentId = -1;
        }
        this.m_type = (str = rset.getString(ndx++)) != null && !rset.wasNull() ? str.charAt(0) : (char)32;
        this.m_sysoid = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_sysoid = null;
        }
        this.m_sysname = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_sysname = null;
        }
        this.m_sysdescr = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_sysdescr = null;
        }
        this.m_syslocation = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_syslocation = null;
        }
        this.m_syscontact = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_syscontact = null;
        }
        this.m_label = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_label = null;
        }
        str = rset.getString(ndx++);
        this.m_labelSource = rset.wasNull() || str == null ? (char)32 : str.charAt(0);
        this.m_nbName = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_nbName = null;
        }
        this.m_nbDomainName = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_nbDomainName = null;
        }
        this.m_os = rset.getString(ndx++);
        if (rset.wasNull()) {
            this.m_os = null;
        }
        this.m_lastPoll = rset.getTimestamp(ndx++);
        rset.close();
        stmt.close();
        this.m_changed = 0;
        return true;
    }

    private DbNodeEntry() {
        this(DEFAULT_DP_NAME);
    }

    private DbNodeEntry(String poller) {
        this.m_dpName = poller;
        this.m_createTime = null;
        this.m_parentId = -1;
        this.m_type = (char)32;
        this.m_sysoid = null;
        this.m_sysname = null;
        this.m_sysdescr = null;
        this.m_syslocation = null;
        this.m_syscontact = null;
        this.m_label = null;
        this.m_labelSource = (char)32;
        this.m_nbName = null;
        this.m_nbDomainName = null;
        this.m_os = null;
        this.m_lastPoll = null;
        this.m_changed = 0;
    }

    private DbNodeEntry(int nid) {
        this(DEFAULT_DP_NAME);
        this.m_fromDb = true;
        this.m_nodeId = nid;
        this.m_dpName = DEFAULT_DP_NAME;
    }

    private DbNodeEntry(int nid, String dpName) {
        this(dpName);
        this.m_fromDb = true;
        this.m_nodeId = nid;
        this.m_dpName = dpName;
    }

    int getNodeId() {
        return this.m_nodeId;
    }

    String getDistributedPollerName() {
        return this.m_dpName;
    }

    Timestamp getCreationTime() {
        return this.m_createTime;
    }

    String getFormattedCreationTime() {
        String result = null;
        if (this.m_createTime != null) {
            result = this.m_createTime.toString();
        }
        return result;
    }

    void setCreationTime(String time) throws ParseException {
        if (time == null) {
            this.m_createTime = null;
        } else {
            Date tmpDate = EventConstants.parseToDate(time);
            this.m_createTime = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 1;
    }

    void setCreationTime(Date time) {
        this.m_createTime = new Timestamp(time.getTime());
        this.m_changed |= 1;
    }

    void setCreationTime(Timestamp time) {
        this.m_createTime = time;
        this.m_changed |= 1;
    }

    boolean hasParentId() {
        return this.m_parentId != -1;
    }

    int getParentId() {
        return this.m_parentId;
    }

    void setParentId(int id) {
        this.m_parentId = id;
        this.m_changed |= 2;
    }

    boolean hasParentIdChanged() {
        return (this.m_changed & 2) == 2;
    }

    boolean updateParentId(int newparentId) {
        if (newparentId != this.m_parentId) {
            this.setParentId(newparentId);
            return true;
        }
        return false;
    }

    char getNodeType() {
        return this.m_type;
    }

    void setNodeType(char type) {
        this.m_type = type;
        this.m_changed |= 4;
    }

    boolean hasNodeTypeChanged() {
        return (this.m_changed & 4) == 4;
    }

    boolean updateNodeType(char newtype) {
        if (newtype != this.m_type) {
            this.setNodeType(newtype);
            return true;
        }
        return false;
    }

    String getSystemOID() {
        return this.m_sysoid;
    }

    void setSystemOID(String oid) {
        this.m_sysoid = oid;
        this.m_changed |= 8;
    }

    boolean hasSystemOIDChanged() {
        return (this.m_changed & 8) == 8;
    }

    boolean updateSystemOID(String newsysoid) {
        if (newsysoid == null || newsysoid.equals(this.m_sysoid)) {
            return false;
        }
        this.setSystemOID(newsysoid);
        return true;
    }

    String getSystemName() {
        return this.m_sysname;
    }

    void setSystemName(String name) {
        this.m_sysname = name;
        this.m_changed |= 0x10;
    }

    boolean hasSystemNameChanged() {
        return (this.m_changed & 0x10) == 16;
    }

    boolean updateSystemName(String newsysname) {
        if (newsysname == null || newsysname.equals(this.m_sysname)) {
            return false;
        }
        this.setSystemName(newsysname);
        return true;
    }

    String getSystemDescription() {
        return this.m_sysdescr;
    }

    void setSystemDescription(String descr) {
        this.m_sysdescr = descr;
        this.m_changed |= 0x2000;
    }

    boolean hasSystemDescriptionChanged() {
        return (this.m_changed & 0x2000) == 8192;
    }

    boolean updateSystemDescription(String newsysdescr) {
        if (newsysdescr == null || newsysdescr.equals(this.m_sysdescr)) {
            return false;
        }
        this.setSystemDescription(newsysdescr);
        return true;
    }

    String getSystemLocation() {
        return this.m_syslocation;
    }

    void setSystemLocation(String loc) {
        this.m_syslocation = loc;
        this.m_changed |= 0x20;
    }

    boolean hasSystemLocationChanged() {
        return (this.m_changed & 0x20) == 32;
    }

    boolean updateSystemLocation(String newsyslocation) {
        if (newsyslocation == null || newsyslocation.equals(this.m_syslocation)) {
            return false;
        }
        this.setSystemLocation(newsyslocation);
        return true;
    }

    String getSystemContact() {
        return this.m_syscontact;
    }

    void setSystemContact(String contact) {
        this.m_syscontact = contact;
        this.m_changed |= 0x40;
    }

    boolean hasSystemContactChanged() {
        return (this.m_changed & 0x40) == 64;
    }

    boolean updateSystemContact(String newsyscontact) {
        if (newsyscontact == null || newsyscontact.equals(this.m_syscontact)) {
            return false;
        }
        this.setSystemContact(newsyscontact);
        return true;
    }

    String getLabel() {
        return this.m_label;
    }

    void setLabel(String label) {
        this.m_label = label;
        this.m_changed |= 0x80;
    }

    boolean hasLabelChanged() {
        return (this.m_changed & 0x80) == 128;
    }

    boolean updateLabel(String newlabel) {
        boolean doUpdate = false;
        if (newlabel != null && this.m_label != null) {
            if (!newlabel.equals(this.m_label)) {
                doUpdate = true;
            }
        } else if (newlabel != null || this.m_label != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setLabel(newlabel);
            return true;
        }
        return false;
    }

    char getLabelSource() {
        return this.m_labelSource;
    }

    void setLabelSource(char src) {
        this.m_labelSource = src;
        this.m_changed |= 0x100;
    }

    boolean hasLabelSourceChanged() {
        return (this.m_changed & 0x100) == 256;
    }

    boolean updateLabelSource(char newlabelSource) {
        if (newlabelSource != this.m_labelSource) {
            this.setLabelSource(newlabelSource);
            return true;
        }
        return false;
    }

    String getNetBIOSName() {
        return this.m_nbName;
    }

    void setNetBIOSName(String name) {
        this.m_nbName = name != null ? name.toUpperCase() : null;
        this.m_changed |= 0x200;
    }

    boolean hasNetBIOSNameChanged() {
        return (this.m_changed & 0x200) == 512;
    }

    boolean updateNetBIOSName(String newnbName) {
        boolean doUpdate = false;
        if (newnbName != null && this.m_nbName != null) {
            if (!newnbName.toUpperCase().equals(this.m_nbName)) {
                doUpdate = true;
            }
        } else if (newnbName != null || this.m_nbName != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setNetBIOSName(newnbName);
            return true;
        }
        return false;
    }

    String getDomainName() {
        return this.m_nbDomainName;
    }

    void setDomainName(String domain) {
        this.m_nbDomainName = domain;
        this.m_changed |= 0x400;
    }

    boolean hasDomainNameChanged() {
        return (this.m_changed & 0x400) == 1024;
    }

    boolean updateDomainName(String domain) {
        boolean doUpdate = false;
        if (domain != null && this.m_nbDomainName != null) {
            if (!domain.equals(this.m_nbDomainName)) {
                doUpdate = true;
            }
        } else if (domain != null || this.m_nbDomainName != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setDomainName(domain);
            return true;
        }
        return false;
    }

    String getOS() {
        return this.m_os;
    }

    void setOS(String os) {
        this.m_os = os;
        this.m_changed |= 0x800;
    }

    boolean hasOSChanged() {
        return (this.m_changed & 0x200) == 512;
    }

    boolean updateOS(String newos) {
        boolean doUpdate = false;
        if (newos != null && this.m_os != null) {
            if (!newos.equals(this.m_os)) {
                doUpdate = true;
            }
        } else if (newos != null || this.m_os != null) {
            doUpdate = true;
        }
        if (doUpdate) {
            this.setOS(newos);
            return true;
        }
        return false;
    }

    String getLastPollString() {
        String result = null;
        if (this.m_lastPoll != null) {
            result = this.m_lastPoll.toString();
        }
        return result;
    }

    Timestamp getLastPoll() {
        return this.m_lastPoll;
    }

    void setLastPoll(String time) throws ParseException {
        if (time == null) {
            this.m_lastPoll = null;
        } else {
            Date tmpDate = EventConstants.parseToDate(time);
            this.m_lastPoll = new Timestamp(tmpDate.getTime());
        }
        this.m_changed |= 0x4000;
    }

    void setLastPoll(Date time) {
        this.m_lastPoll = new Timestamp(time.getTime());
        this.m_changed |= 0x4000;
    }

    void setLastPoll(Timestamp time) {
        this.m_lastPoll = time;
        this.m_changed |= 0x4000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store() throws SQLException {
        if (this.m_changed != 0 || !this.m_fromDb) {
            Connection db = null;
            try {
                db = DataSourceFactory.getInstance().getConnection();
                this.store(db);
                if (!db.getAutoCommit()) {
                    db.commit();
                }
            }
            finally {
                try {
                    if (db != null) {
                        db.close();
                    }
                }
                catch (SQLException e) {
                    ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
                }
            }
        }
    }

    void store(Connection db) throws SQLException {
        Category log = ThreadCategory.getInstance(this.getClass());
        log.debug((Object)("DbNodeEntry: changed map = 0x" + Integer.toHexString(this.m_changed)));
        if (this.m_changed != 0 || !this.m_fromDb) {
            if (this.m_fromDb) {
                this.update(db);
            } else {
                this.insert(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbIpInterfaceEntry[] getInterfaces() throws SQLException {
        DbIpInterfaceEntry[] entries = null;
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            entries = this.getInterfaces(db);
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
        return entries;
    }

    DbIpInterfaceEntry[] getInterfaces(Connection db) throws SQLException {
        PreparedStatement stmt = db.prepareStatement(SQL_LOAD_IF_LIST);
        stmt.setInt(1, this.m_nodeId);
        ResultSet rset = stmt.executeQuery();
        ArrayList<DbIpInterfaceEntry> l = new ArrayList<DbIpInterfaceEntry>();
        while (rset.next()) {
            String saddr = rset.getString(1);
            int ifIndex = rset.getInt(2);
            if (rset.wasNull()) {
                ifIndex = -1;
            }
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(saddr);
            }
            catch (UnknownHostException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)("Failed to convert address " + saddr + " to InetAddress for node " + this.m_nodeId + ", ifIndex " + ifIndex), (Throwable)e);
                continue;
            }
            DbIpInterfaceEntry entry = null;
            entry = ifIndex == -1 ? DbIpInterfaceEntry.get(db, this.m_nodeId, addr) : DbIpInterfaceEntry.get(db, this.m_nodeId, addr, ifIndex);
            if (entry == null) continue;
            l.add(entry);
        }
        rset.close();
        stmt.close();
        DbIpInterfaceEntry[] entries = new DbIpInterfaceEntry[l.size()];
        return l.toArray(entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbIpInterfaceEntry[] getManagedInterfaces() throws SQLException {
        DbIpInterfaceEntry[] entries = null;
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            entries = this.getManagedInterfaces(db);
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
        return entries;
    }

    DbIpInterfaceEntry[] getManagedInterfaces(Connection db) throws SQLException {
        PreparedStatement stmt = db.prepareStatement(SQL_LOAD_MANAGED_IF_LIST);
        stmt.setInt(1, this.m_nodeId);
        ResultSet rset = stmt.executeQuery();
        ArrayList<DbIpInterfaceEntry> l = new ArrayList<DbIpInterfaceEntry>();
        while (rset.next()) {
            String saddr = rset.getString(1);
            int ifIndex = rset.getInt(2);
            if (rset.wasNull()) {
                ifIndex = -1;
            }
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(saddr);
            }
            catch (UnknownHostException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)("Failed to convert address " + saddr + " to InetAddress for node " + this.m_nodeId + ", ifIndex " + ifIndex), (Throwable)e);
                continue;
            }
            DbIpInterfaceEntry entry = null;
            entry = ifIndex == -1 ? DbIpInterfaceEntry.get(db, this.m_nodeId, addr) : DbIpInterfaceEntry.get(db, this.m_nodeId, addr, ifIndex);
            if (entry == null) continue;
            l.add(entry);
        }
        rset.close();
        stmt.close();
        DbIpInterfaceEntry[] entries = new DbIpInterfaceEntry[l.size()];
        return l.toArray(entries);
    }

    static DbIpInterfaceEntry getPrimarySnmpInterface(DbIpInterfaceEntry[] ipInterfaces) {
        if (ipInterfaces == null) {
            return null;
        }
        for (int i = 0; i < ipInterfaces.length; ++i) {
            if (ipInterfaces[i].getPrimaryState() != 'P') continue;
            return ipInterfaces[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DbSnmpInterfaceEntry[] getSnmpInterfaces() throws SQLException {
        DbSnmpInterfaceEntry[] entries = null;
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            entries = this.getSnmpInterfaces(db);
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
        return entries;
    }

    DbSnmpInterfaceEntry[] getSnmpInterfaces(Connection db) throws SQLException {
        PreparedStatement stmt = db.prepareStatement(SQL_LOAD_SNMP_LIST);
        stmt.setInt(1, this.m_nodeId);
        ResultSet rset = stmt.executeQuery();
        ArrayList<DbSnmpInterfaceEntry> l = new ArrayList<DbSnmpInterfaceEntry>();
        while (rset.next()) {
            String saddr = rset.getString(1);
            int ifIndex = rset.getInt(2);
            if (rset.wasNull()) {
                ifIndex = -1;
            }
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(saddr);
            }
            catch (UnknownHostException e) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)("Failed to convert address " + saddr + " to InetAddress for node " + this.m_nodeId + ", ifIndex " + ifIndex), (Throwable)e);
                continue;
            }
            DbSnmpInterfaceEntry entry = null;
            if (ifIndex == -1 || (entry = DbSnmpInterfaceEntry.get(db, this.m_nodeId, ifIndex)) == null) continue;
            l.add(entry);
        }
        rset.close();
        stmt.close();
        DbSnmpInterfaceEntry[] entries = new DbSnmpInterfaceEntry[l.size()];
        return l.toArray(entries);
    }

    static DbNodeEntry create() {
        return new DbNodeEntry(DEFAULT_DP_NAME);
    }

    static DbNodeEntry create(String poller) {
        if (poller == null) {
            poller = DEFAULT_DP_NAME;
        }
        return new DbNodeEntry(poller);
    }

    static DbNodeEntry clone(DbNodeEntry entry) {
        DbNodeEntry clonedEntry = DbNodeEntry.create();
        clonedEntry.m_fromDb = entry.m_fromDb;
        clonedEntry.m_nodeId = entry.m_nodeId;
        clonedEntry.m_createTime = entry.m_createTime;
        clonedEntry.m_parentId = entry.m_parentId;
        clonedEntry.m_type = entry.m_type;
        clonedEntry.m_sysoid = entry.m_sysoid;
        clonedEntry.m_sysname = entry.m_sysname;
        clonedEntry.m_syslocation = entry.m_syslocation;
        clonedEntry.m_sysdescr = entry.m_sysdescr;
        clonedEntry.m_syscontact = entry.m_syscontact;
        clonedEntry.m_label = entry.m_label;
        clonedEntry.m_labelSource = entry.m_labelSource;
        clonedEntry.m_nbName = entry.m_nbName;
        clonedEntry.m_nbDomainName = entry.m_nbDomainName;
        clonedEntry.m_os = entry.m_os;
        clonedEntry.m_lastPoll = entry.m_lastPoll;
        clonedEntry.m_changed = entry.m_changed;
        return clonedEntry;
    }

    static DbNodeEntry get(int nid) throws SQLException {
        return DbNodeEntry.get(nid, DEFAULT_DP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DbNodeEntry get(int nid, String dpName) throws SQLException {
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            DbNodeEntry dbNodeEntry = DbNodeEntry.get(db, nid, dpName);
            return dbNodeEntry;
        }
        finally {
            try {
                if (db != null) {
                    db.close();
                }
            }
            catch (SQLException e) {
                ThreadCategory.getInstance(DbNodeEntry.class).warn((Object)"Exception closing JDBC connection", (Throwable)e);
            }
        }
    }

    static DbNodeEntry get(Connection db, int nid) throws SQLException {
        return DbNodeEntry.get(db, nid, DEFAULT_DP_NAME);
    }

    static DbNodeEntry get(Connection db, int nid, String dpName) throws SQLException {
        DbNodeEntry entry = new DbNodeEntry(nid, dpName);
        if (!entry.load(db)) {
            entry = null;
        }
        return entry;
    }

    public String toString() {
        String sep = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer();
        buf.append("from database            = ").append(this.m_fromDb).append(sep);
        buf.append("node identifier          = ").append(this.m_nodeId).append(sep);
        buf.append("distributed poller       = ").append(this.m_dpName).append(sep);
        buf.append("creation time            = ").append(this.m_createTime).append(sep);
        buf.append("parent identfier         = ").append(this.m_parentId).append(sep);
        buf.append("node type                = ").append(this.m_type).append(sep);
        buf.append("snmp system oid          = ").append(this.m_sysoid).append(sep);
        buf.append("snmp system name         = ").append(this.m_sysname).append(sep);
        buf.append("snmp system description  = ").append(this.m_sysdescr).append(sep);
        buf.append("snmp system location     = ").append(this.m_syslocation).append(sep);
        buf.append("snmp system contact      = ").append(this.m_syscontact).append(sep);
        buf.append("label                    = ").append(this.m_label).append(sep);
        buf.append("label source             = ").append(this.m_labelSource).append(sep);
        buf.append("NetBIOS                  = ").append(this.m_nbName).append(sep);
        buf.append("Domain                   = ").append(this.m_nbDomainName).append(sep);
        buf.append("Operating System         = ").append(this.m_os).append(sep);
        buf.append("last poll time           = ").append(this.m_lastPoll).append(sep);
        return buf.toString();
    }

    public void createAssetNodeEntry(Connection conn, int nodeid) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("INSERT INTO ASSETS (nodeID,category,userLastModified,lastModifiedDate,displayCategory,notifyCategory,pollerCategory,thresholdCategory) values(?,?,?,?,?,?,?,?)");
        stmt.setInt(1, nodeid);
        stmt.setString(2, "Unspecified");
        stmt.setString(3, "");
        stmt.setTimestamp(4, new Timestamp(new Date().getTime()));
        stmt.setString(5, " ");
        stmt.setString(6, " ");
        stmt.setString(7, " ");
        stmt.setString(8, " ");
        stmt.execute();
        stmt.close();
    }
}

