/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.BroadcastEventProcessor;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;

public class Capsd
extends AbstractServiceDaemon {
    private static final String LOG4J_CATEGORY = "OpenNMS.Capsd";
    private static final Capsd m_singleton = new Capsd();
    private static Object m_dbSyncLock = new Object();
    private static String m_address = null;
    private Scheduler m_scheduler = null;
    private BroadcastEventProcessor m_receiver;
    private RunnableConsumerThreadPool m_suspectRunner;
    private RunnableConsumerThreadPool m_rescanRunner;

    public Capsd() {
        super(LOG4J_CATEGORY);
    }

    protected void onStop() {
        this.m_receiver.close();
        this.m_suspectRunner.stop();
        this.m_rescanRunner.stop();
    }

    protected void onInit() {
        this.initialCapsdConfig();
        this.initializePollerConfig();
        this.initializeCollectdConfig();
        this.initializeDataSourceFactory();
        this.initializeSnmpPeerFactory();
        Connection conn = null;
        try {
            conn = DataSourceFactory.getInstance().getConnection();
            this.log().debug((Object)"init: Loading services into database...");
            CapsdConfigFactory.getInstance().syncServices(conn);
            this.log().debug((Object)"init: Syncing management state...");
            CapsdConfigFactory.getInstance().syncManagementState(conn);
            this.log().debug((Object)"init: Syncing primary SNMP interface state...");
            CapsdConfigFactory.getInstance().syncSnmpPrimaryState(conn);
        }
        catch (SQLException sqlE) {
            this.log().fatal((Object)"SQL Exception while syncing database with latest configuration information.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            this.log().fatal((Object)"Unknown error while syncing database with latest configuration information.", t);
            throw new UndeclaredThrowableException(t);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        this.m_suspectRunner = new RunnableConsumerThreadPool("Capsd Suspect Pool", 0.0f, 0.0f, CapsdConfigFactory.getInstance().getMaxSuspectThreadPoolSize());
        this.m_rescanRunner = new RunnableConsumerThreadPool("Capsd Rescan Pool", 0.0f, 0.0f, CapsdConfigFactory.getInstance().getMaxRescanThreadPoolSize());
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"init: Creating rescan scheduler");
        }
        try {
            this.m_scheduler = new Scheduler(this.m_rescanRunner.getRunQueue());
        }
        catch (SQLException sqlE) {
            this.log().error((Object)"Failed to initialize the rescan scheduler.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            this.log().error((Object)"Failed to initialize the rescan scheduler.", t);
            throw new UndeclaredThrowableException(t);
        }
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"init: Creating event broadcast event receiver");
            }
            this.m_receiver = new BroadcastEventProcessor(this.m_suspectRunner.getRunQueue(), this.m_scheduler);
        }
        catch (Throwable t) {
            this.log().error((Object)"Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
    }

    private void initializeSnmpPeerFactory() {
        try {
            SnmpPeerFactory.init();
        }
        catch (MarshalException ex) {
            this.log().error((Object)"Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error((Object)"Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error((Object)"Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    private void initializeDataSourceFactory() {
        try {
            DataSourceFactory.init();
        }
        catch (IOException ie) {
            this.log().fatal((Object)"IOException loading database config", (Throwable)ie);
            throw new UndeclaredThrowableException(ie);
        }
        catch (MarshalException me) {
            this.log().fatal((Object)"Marshall Exception loading database config", (Throwable)me);
            throw new UndeclaredThrowableException(me);
        }
        catch (ValidationException ve) {
            this.log().fatal((Object)"Validation Exception loading database config", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        catch (ClassNotFoundException ce) {
            this.log().fatal((Object)"Class lookup failure loading database config", (Throwable)ce);
            throw new UndeclaredThrowableException(ce);
        }
        catch (PropertyVetoException pve) {
            this.log().fatal((Object)"Property veto failure loading database config", (Throwable)pve);
            throw new UndeclaredThrowableException(pve);
        }
        catch (SQLException sqle) {
            this.log().fatal((Object)"SQL exception loading database config", (Throwable)sqle);
            throw new UndeclaredThrowableException(sqle);
        }
    }

    private void initializeCollectdConfig() {
        try {
            CollectdConfigFactory.init();
        }
        catch (MarshalException ex) {
            this.log().error((Object)"Failed to load collectd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error((Object)"Failed to load collectd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error((Object)"Failed to load collectd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    private void initializePollerConfig() {
        try {
            PollerConfigFactory.init();
        }
        catch (MarshalException ex) {
            this.log().error((Object)"Failed to load poller configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error((Object)"Failed to load poller configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error((Object)"Failed to load poller configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    private void initialCapsdConfig() {
        try {
            CapsdConfigFactory.init();
        }
        catch (MarshalException ex) {
            this.log().error((Object)"Failed to load Capsd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error((Object)"Failed to load Capsd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error((Object)"Failed to load Capsd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    protected void onStart() {
        this.log().debug((Object)"start: Starting runnable thread pools...");
        this.m_suspectRunner.start();
        this.m_rescanRunner.start();
        this.log().debug((Object)"start: Starting rescan scheduler");
        this.m_scheduler.start();
    }

    protected void onPause() {
    }

    protected void onResume() {
    }

    public static String getLocalHostAddress() {
        return m_address;
    }

    public static Capsd getInstance() {
        return m_singleton;
    }

    static Object getDbSyncLock() {
        return m_dbSyncLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanSuspectInterface(String ifAddr) throws UnknownHostException {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            InetAddress addr = InetAddress.getByName(ifAddr);
            SuspectEventProcessor proc = new SuspectEventProcessor(addr.getHostAddress());
            proc.run();
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanInterfaceParent(Integer nodeId) {
        String prefix = ThreadCategory.getPrefix();
        try {
            ThreadCategory.setPrefix((String)this.getName());
            this.m_scheduler.forceRescan(nodeId);
        }
        finally {
            ThreadCategory.setPrefix((String)prefix);
        }
    }

    static {
        try {
            m_address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhE) {
            m_address = "localhost";
            ThreadCategory.getInstance((String)LOG4J_CATEGORY).warn((Object)"Could not lookup the host name for the local host machine, address set to localhost", (Throwable)uhE);
        }
    }
}

