/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.capsd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.capsd.DbIfServiceEntry;
import org.opennms.netmgt.capsd.DbIpInterfaceEntry;
import org.opennms.netmgt.capsd.DbNodeEntry;
import org.opennms.netmgt.capsd.EventUtils;
import org.opennms.netmgt.capsd.FailedOperationException;
import org.opennms.netmgt.capsd.InsufficientInformationException;
import org.opennms.netmgt.capsd.Scheduler;
import org.opennms.netmgt.capsd.SuspectEventProcessor;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.OpennmsServerConfigFactory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.utils.XmlrpcUtil;
import org.opennms.netmgt.xml.event.Event;

final class BroadcastEventProcessor
implements EventListener {
    private static String SQL_ADD_INTERFACE_TO_SERVER = "INSERT INTO serverMap VALUES (?, ?)";
    private static String SQL_ADD_SERVICE_TO_MAPPING = "INSERT INTO serviceMap VALUES (?, ?)";
    private static String SQL_DELETE_ALL_SERVICES_INTERFACE_MAPPING = "DELETE FROM serviceMap WHERE ipaddr = ?";
    private static String SQL_DELETE_INTERFACE_ON_SERVER = "DELETE FROM serverMap WHERE ipaddr = ? AND servername = ?";
    private static String SQL_DELETE_SERVICE_INTERFACE_MAPPING = "DELETE FROM serviceMap WHERE ipaddr = ? AND servicemapname = ?";
    private static String SQL_QUERY_IPADDRESS_EXIST = "SELECT nodeid FROM ipinterface WHERE ipaddr = ? AND isManaged !='D'";
    private static String SQL_QUERY_IPINTERFACE_EXIST = "SELECT nodelabel, ipaddr FROM node, ipinterface WHERE node.nodeid = ipinterface.nodeid AND node.nodelabel = ? AND ipinterface.ipaddr = ? AND isManaged !='D' AND nodeType !='D'";
    private static String SQL_QUERY_NODE_EXIST = "SELECT nodeid, dpname FROM node WHERE nodelabel = ? AND nodeType !='D'";
    private static String SQL_QUERY_SERVICE_EXIST = "SELECT nodeid FROM ifservices, service WHERE ifservices.serviceid = service.serviceid AND ipaddr = ? AND servicename = ? AND status !='D'";
    private static String SQL_QUERY_SERVICE_MAPPING_EXIST = "SELECT * FROM serviceMap WHERE ipaddr = ? AND servicemapname = ?";
    private static String SQL_RETRIEVE_NODEID = "select nodeid from ipinterface where ipaddr=? and isManaged!='D'";
    private static String SQL_RETRIEVE_SERVICE_ID = "SELECT serviceid FROM service WHERE servicename = ?";
    private String m_localServer = null;
    private Set m_notifySet = new HashSet();
    private Scheduler m_scheduler;
    private FifoQueue m_suspectQ;

    public static boolean isPropagationEnabled() {
        return CapsdConfigFactory.getInstance().getDeletePropagationEnabled();
    }

    public static boolean isXmlRpcEnabled() {
        return CapsdConfigFactory.getInstance().getXmlrpc().equals("true");
    }

    BroadcastEventProcessor(FifoQueue suspectQ, Scheduler scheduler) {
        this.m_suspectQ = suspectQ;
        this.m_scheduler = scheduler;
        this.m_localServer = OpennmsServerConfigFactory.getInstance().getServerName();
        this.createMessageSelectorAndSubscribe();
    }

    public void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countOtherInterfacesOnNode(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        String DB_COUNT_OTHER_INTERFACES_ON_NODE = "SELECT count(*) FROM ipinterface WHERE nodeID=? and ipAddr != ? and isManaged != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ipinterface WHERE nodeID=? and ipAddr != ? and isManaged != 'D'");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("countServicesForInterface: count services for interface " + nodeId + "/" + ipAddr + ": found " + count));
            }
            int n = count;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countOtherServicesOnInterface(Connection dbConn, long nodeId, String ipAddr, String service) throws SQLException {
        String DB_COUNT_OTHER_SERVICES_ON_IFACE = "SELECT count(*) FROM ifservices, service WHERE ifservices.serviceId = service.serviceId AND ifservices.status != 'D' AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.servicename != ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ifservices, service WHERE ifservices.serviceId = service.serviceId AND ifservices.status != 'D' AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.servicename != ?");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, service);
            rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("countServicesForInterface: count services for interface " + nodeId + "/" + ipAddr + ": found " + count));
            }
            int n = count;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countServicesOnOtherInterfaces(Connection dbConn, long nodeId, String ipAddr) throws SQLException {
        String DB_COUNT_SERVICES_ON_OTHER_INTERFACES = "SELECT count(*) FROM ifservices WHERE nodeID=? and ipAddr != ? and status != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement("SELECT count(*) FROM ifservices WHERE nodeID=? and ipAddr != ? and status != 'D'");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("countServicesOnOtherInterfaces: count services for node " + nodeId + ": found " + count));
            }
            int n = count;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List createInterfaceOnNode(Connection dbConn, String nodeLabel, String ipaddr, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_NODE_EXIST);
            stmt.setString(1, nodeLabel);
            rs = stmt.executeQuery();
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            while (rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("addInterfaceHandler:  add interface: " + ipaddr + " to the database."));
                }
                InetAddress ifaddr = InetAddress.getByName(ipaddr);
                int nodeId = rs.getInt(1);
                String dpName = rs.getString(2);
                DbIpInterfaceEntry ipInterface = DbIpInterfaceEntry.create(nodeId, ifaddr);
                ipInterface.setHostname(ifaddr.getHostName());
                ipInterface.setManagedState('M');
                ipInterface.setPrimaryState('N');
                ipInterface.store(dbConn);
                DbNodeEntry nodeEntry = DbNodeEntry.get(nodeId, dpName);
                Event newEvent = EventUtils.createNodeGainedInterfaceEvent(nodeEntry, ifaddr, txNo);
                eventsToSend.add(newEvent);
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        catch (UnknownHostException e) {
            throw new FailedOperationException("unable to resolve host " + ipaddr + ": " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void createMessageSelectorAndSubscribe() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/internal/discovery/newSuspect");
        ueiList.add("uei.opennms.org/internal/capsd/forceRescan");
        ueiList.add("uei.opennms.org/internal/capsd/addNode");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/addNode");
        ueiList.add("uei.opennms.org/internal/capsd/deleteNode");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/deleteNode");
        ueiList.add("uei.opennms.org/internal/capsd/addInterface");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/addInterface");
        ueiList.add("uei.opennms.org/internal/capsd/deleteInterface");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/deleteInterface");
        ueiList.add("uei.opennms.org/nodes/deleteService");
        ueiList.add("uei.opennms.org/internal/capsd/changeService");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/changeService");
        ueiList.add("uei.opennms.org/internal/capsd/updateServer");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/updateServer");
        ueiList.add("uei.opennms.org/internal/capsd/updateService");
        this.m_notifySet.add("uei.opennms.org/internal/capsd/updateService");
        ueiList.add("uei.opennms.org/nodes/nodeAdded");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/duplicateNodeDeleted");
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueiList);
    }

    private List createNodeWithInterface(Connection conn, String nodeLabel, String ipaddr, long txNo) throws SQLException, FailedOperationException {
        if (nodeLabel == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("addNode:  Add a node " + nodeLabel + " to the database"));
        }
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        DbNodeEntry node = DbNodeEntry.create();
        Date now = new Date();
        node.setCreationTime(now);
        node.setNodeType('A');
        node.setLabel(nodeLabel);
        node.setLabelSource('U');
        node.store(conn);
        Event newEvent = EventUtils.createNodeAddedEvent(node, txNo);
        eventsToSend.add(newEvent);
        if (ipaddr != null) {
            try {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("addNode:  Add an IP Address " + ipaddr + " to the database"));
                }
                InetAddress ifaddress = InetAddress.getByName(ipaddr);
                DbIpInterfaceEntry ipInterface = DbIpInterfaceEntry.create(node.getNodeId(), ifaddress);
                ipInterface.setHostname(ifaddress.getHostName());
                ipInterface.setManagedState('M');
                ipInterface.setPrimaryState('N');
                ipInterface.store(conn);
                Event gainIfEvent = EventUtils.createNodeGainedInterfaceEvent(node, ifaddress, txNo);
                eventsToSend.add(gainIfEvent);
            }
            catch (UnknownHostException e) {
                throw new FailedOperationException("unable to resolve host " + ipaddr + ": " + e.getMessage(), e);
            }
        }
        return eventsToSend;
    }

    private List doAddInterface(Connection dbConn, String nodeLabel, String ipaddr, long txNo) throws SQLException, FailedOperationException {
        List eventsToSend;
        if (this.interfaceExists(dbConn, nodeLabel, ipaddr)) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("addInterfaceHandler: node " + nodeLabel + " with IPAddress " + ipaddr + " already exist in the database."));
            }
            eventsToSend = Collections.EMPTY_LIST;
        } else {
            eventsToSend = this.nodeExists(dbConn, nodeLabel) ? this.createInterfaceOnNode(dbConn, nodeLabel, ipaddr, txNo) : this.createNodeWithInterface(dbConn, nodeLabel, ipaddr, txNo);
        }
        return eventsToSend;
    }

    private List doAddNode(Connection dbConn, String nodeLabel, String ipaddr, long txNo) throws SQLException, FailedOperationException {
        List eventsToSend;
        if (!this.nodeExists(dbConn, nodeLabel)) {
            eventsToSend = this.createNodeWithInterface(dbConn, nodeLabel, ipaddr, txNo);
        } else {
            eventsToSend = Collections.EMPTY_LIST;
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("doAddNode: node " + nodeLabel + " with IPAddress " + ipaddr + " already exist in the database."));
            }
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doAddServiceMapping(Connection dbConn, String ipaddr, String serviceName, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement(SQL_ADD_SERVICE_TO_MAPPING);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("updateServiceHandler: add service " + serviceName + " to interface: " + ipaddr));
            }
            List list = this.doChangeService(dbConn, ipaddr, serviceName, "ADD", txNo);
            return list;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doAddServiceToInterface(Connection dbConn, String ipaddr, String serviceName, int serviceId, long txNo) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_IPADDRESS_EXIST);
            stmt.setString(1, ipaddr);
            rs = stmt.executeQuery();
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            while (rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("changeServiceHandler: add service " + serviceName + " to interface: " + ipaddr));
                }
                int nodeId = rs.getInt(1);
                DbIfServiceEntry service = DbIfServiceEntry.create(nodeId, InetAddress.getByName(ipaddr), serviceId);
                service.setSource('P');
                service.setStatus('A');
                service.setNotify('Y');
                service.store(dbConn);
                DbNodeEntry nodeEntry = DbNodeEntry.get(nodeId);
                Event newEvent = EventUtils.createNodeGainedServiceEvent(nodeEntry, InetAddress.getByName(ipaddr), serviceName, txNo);
                eventsToSend.add(newEvent);
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        catch (UnknownHostException e) {
            throw new FailedOperationException("Unable to resolve host: " + e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private List doChangeService(Connection dbConn, String ipaddr, String serviceName, String action, long txNo) throws SQLException, FailedOperationException {
        List eventsToSend = null;
        int serviceId = this.verifyServiceExists(dbConn, serviceName);
        if (action.equalsIgnoreCase("DELETE")) {
            eventsToSend = new LinkedList();
            int[] nodeIds = this.findNodeIdForServiceAndInterface(dbConn, ipaddr, serviceName);
            for (int i = 0; i < nodeIds.length; ++i) {
                int nodeId = nodeIds[i];
                eventsToSend.addAll(this.doDeleteService(dbConn, "OpenNMS.Capsd", nodeId, ipaddr, serviceName, txNo));
            }
        } else {
            eventsToSend = action.equalsIgnoreCase("ADD") ? this.doAddServiceToInterface(dbConn, ipaddr, serviceName, serviceId, txNo) : Collections.EMPTY_LIST;
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doCreateInterfaceMappings(Connection dbConn, String nodeLabel, String ipaddr, String hostName, long txNo) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement(SQL_ADD_INTERFACE_TO_SERVER);
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("updateServerHandler: added interface " + ipaddr + " into NMS server: " + hostName));
            }
            Event newEvent = EventUtils.createAddInterfaceEvent("OpenNMS.Capsd", nodeLabel, ipaddr, hostName, txNo);
            List<Event> list = Collections.singletonList(newEvent);
            return list;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private List doDeleteInterface(Connection dbConn, String source, long nodeid, String ipAddr, long txNo) throws SQLException {
        LinkedList eventsToSend = new LinkedList();
        if (BroadcastEventProcessor.isPropagationEnabled() && this.countOtherInterfacesOnNode(dbConn, nodeid, ipAddr) == 0) {
            this.doDeleteNode(dbConn, source, nodeid, txNo);
        } else {
            eventsToSend.addAll(this.markAllServicesForInterfaceDeleted(dbConn, source, nodeid, ipAddr, txNo));
            eventsToSend.addAll(this.markInterfaceDeleted(dbConn, source, nodeid, ipAddr, txNo));
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doDeleteInterfaceMappings(Connection dbConn, String nodeLabel, String ipaddr, String hostName, long txNo) throws SQLException {
        Statement stmt = null;
        try {
            LinkedList eventsToSend = new LinkedList();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("updateServer: delete all services on the interface: " + ipaddr + " in the interface/service mapping."));
            }
            stmt = dbConn.prepareStatement(SQL_DELETE_ALL_SERVICES_INTERFACE_MAPPING);
            stmt.setString(1, ipaddr);
            stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("updateServer: delete interface: " + ipaddr + " on NMS server: " + hostName));
            }
            stmt = dbConn.prepareStatement(SQL_DELETE_INTERFACE_ON_SERVER);
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            stmt.executeUpdate();
            long[] nodeIds = this.findNodeIdsForInterfaceAndLabel(dbConn, nodeLabel, ipaddr);
            for (int i = 0; i < nodeIds.length; ++i) {
                long nodeId = nodeIds[i];
                eventsToSend.addAll(this.doDeleteInterface(dbConn, "OpenNMS.Capsd", nodeId, ipaddr, txNo));
            }
            LinkedList linkedList = eventsToSend;
            return linkedList;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private List doDeleteNode(Connection dbConn, String source, long nodeid, long txNo) throws SQLException {
        LinkedList eventsToSend = new LinkedList();
        eventsToSend.addAll(this.markInterfacesAndServicesDeleted(dbConn, source, nodeid, txNo));
        eventsToSend.addAll(this.markNodeDeleted(dbConn, source, nodeid, txNo));
        return eventsToSend;
    }

    private List doDeleteService(Connection dbConn, String source, long nodeid, String ipAddr, String service, long txNo) throws SQLException {
        LinkedList eventsToSend = new LinkedList();
        if (BroadcastEventProcessor.isPropagationEnabled()) {
            int otherSvcsOnIfCnt = this.countOtherServicesOnInterface(dbConn, nodeid, ipAddr, service);
            if (otherSvcsOnIfCnt == 0 && this.countServicesOnOtherInterfaces(dbConn, nodeid, ipAddr) == 0) {
                this.log().debug((Object)("Propagating service delete to node " + nodeid));
                eventsToSend.addAll(this.doDeleteNode(dbConn, source, nodeid, txNo));
            } else if (otherSvcsOnIfCnt == 0) {
                this.log().debug((Object)("Propagting service delete to interface " + nodeid + "/" + ipAddr));
                eventsToSend.addAll(this.doDeleteInterface(dbConn, source, nodeid, ipAddr, txNo));
            } else {
                this.log().debug((Object)("No need to Propagate service delete " + nodeid + "/" + ipAddr + "/" + service));
                eventsToSend.addAll(this.markServiceDeleted(dbConn, source, nodeid, ipAddr, service, txNo));
            }
        } else {
            this.log().debug((Object)("Propagation disabled:  deleting only service " + nodeid + "/" + ipAddr + "/" + service));
            eventsToSend.addAll(this.markServiceDeleted(dbConn, source, nodeid, ipAddr, service, txNo));
        }
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List doDeleteServiceMapping(Connection dbConn, String ipaddr, String serviceName, long txNo) throws SQLException, FailedOperationException {
        Statement stmt = null;
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("handleUpdateService: delete service: " + serviceName + " on IPAddress: " + ipaddr));
            }
            stmt = dbConn.prepareStatement(SQL_DELETE_SERVICE_INTERFACE_MAPPING);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            stmt.executeUpdate();
            List list = this.doChangeService(dbConn, ipaddr, serviceName, "DELETE", txNo);
            return list;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private List doUpdateServer(Connection dbConn, String nodeLabel, String ipaddr, String action, String hostName, long txNo) throws SQLException, FailedOperationException {
        boolean exists = this.existsInServerMap(dbConn, hostName, ipaddr);
        if ("DELETE".equalsIgnoreCase(action)) {
            return this.doDeleteInterfaceMappings(dbConn, nodeLabel, ipaddr, hostName, txNo);
        }
        if ("ADD".equalsIgnoreCase(action)) {
            if (exists) {
                throw new FailedOperationException("Could not add interface " + ipaddr + " to NMS server: " + hostName + " because it already exists!");
            }
            return this.doCreateInterfaceMappings(dbConn, nodeLabel, ipaddr, hostName, txNo);
        }
        this.log().error((Object)("updateServerHandler: could not process interface: " + ipaddr + " on NMS server: " + hostName + ": action " + action + " unknown"));
        throw new FailedOperationException("Undefined operation " + action + " for updateServer event!");
    }

    private List doUpdateService(Connection dbConn, String nodeLabel, String ipaddr, String serviceName, String action, long txNo) throws SQLException, FailedOperationException {
        this.verifyServiceExists(dbConn, serviceName);
        this.verifyInterfaceExists(dbConn, nodeLabel, ipaddr);
        boolean mapExists = this.serviceMappingExists(dbConn, ipaddr, serviceName);
        List eventsToSend = mapExists && "DELETE".equalsIgnoreCase(action) ? this.doDeleteServiceMapping(dbConn, ipaddr, serviceName, txNo) : (!mapExists && "ADD".equalsIgnoreCase(action) ? this.doAddServiceMapping(dbConn, ipaddr, serviceName, txNo) : Collections.EMPTY_LIST);
        return eventsToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsInServerMap(Connection dbConn, String hostName, String ipaddr) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String SQL_QUERY_INTERFACE_ON_SERVER = "SELECT count(*)  FROM serverMap WHERE ipaddr = ? AND servername = ?";
            stmt = dbConn.prepareStatement("SELECT count(*)  FROM serverMap WHERE ipaddr = ? AND servername = ?");
            stmt.setString(1, ipaddr);
            stmt.setString(2, hostName);
            ResultSet rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                count = rs.getInt(1);
            }
            boolean bl = count > 0;
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] findNodeIdForServiceAndInterface(Connection dbConn, String ipaddr, String serviceName) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_SERVICE_EXIST);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            rs = stmt.executeQuery();
            LinkedList<Integer> nodeIdList = new LinkedList<Integer>();
            while (rs.next()) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("changeService: service " + serviceName + " on IPAddress " + ipaddr + " already exists in the database."));
                }
                int nodeId = rs.getInt(1);
                nodeIdList.add(new Integer(nodeId));
            }
            int[] nodeIds = new int[nodeIdList.size()];
            int i = 0;
            for (Integer n : nodeIdList) {
                nodeIds[i] = n;
                ++i;
            }
            int[] nArray = nodeIds;
            return nArray;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] findNodeIdsForInterfaceAndLabel(Connection dbConn, String nodeLabel, String ipAddr) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement("SELECT node.nodeid FROM node, ipinterface WHERE node.nodeid = ipinterface.nodeid AND node.nodelabel = ? AND ipinterface.ipaddr = ? AND isManaged !='D' AND nodeType !='D'");
            stmt.setString(1, nodeLabel);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            LinkedList<Long> nodeIdList = new LinkedList<Long>();
            while (rs.next()) {
                nodeIdList.add(new Long(rs.getLong(1)));
            }
            long[] nodeIds = new long[nodeIdList.size()];
            int i = 0;
            for (Long nodeId : nodeIdList) {
                nodeIds[i] = nodeId;
                ++i;
            }
            long[] lArray = nodeIds;
            return lArray;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    public String getLocalServer() {
        return this.m_localServer;
    }

    public String getName() {
        return "Capsd:BroadcastEventProcessor";
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAddInterface(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkInterface(event);
        EventUtils.requireParm(event, "nodelabel");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("addInterfaceHandler:  processing addInterface event for " + event.getInterface()));
        }
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        Connection dbConn = null;
        List eventsToSend = null;
        dbConn = DataSourceFactory.getInstance().getConnection();
        dbConn.setAutoCommit(false);
        eventsToSend = this.doAddInterface(dbConn, nodeLabel, event.getInterface(), txNo);
        Object var9_6 = null;
        if (dbConn == null) return;
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            this.log().error((Object)"handleAddInterface: Threw Exception during commit: ", (Throwable)ex);
            throw new FailedOperationException("Database error: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.setAutoCommit(true);
                    dbConn.close();
                }
                catch (SQLException ex2) {
                    this.log().error((Object)"handleAddInterface: Threw Exception during close: ", (Throwable)ex2);
                }
            }
        }
        {
            catch (SQLException sqlE) {
                this.log().error((Object)"addInterfaceHandler: SQLException during add node and ipaddress to the database.", (Throwable)sqlE);
                throw new FailedOperationException("Database error: " + sqlE.getMessage(), sqlE);
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (dbConn == null) throw throwable;
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
            } else {
                dbConn.rollback();
            }
            if (dbConn == null) throw throwable;
            try {
                dbConn.setAutoCommit(true);
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error((Object)"handleAddInterface: Threw Exception during close: ", (Throwable)ex);
            }
            throw throwable;
            catch (SQLException ex) {
                try {}
                catch (Throwable throwable2) {
                    if (dbConn == null) throw throwable2;
                    try {
                        dbConn.setAutoCommit(true);
                        dbConn.close();
                        throw throwable2;
                    }
                    catch (SQLException ex2) {
                        this.log().error((Object)"handleAddInterface: Threw Exception during close: ", (Throwable)ex2);
                    }
                    throw throwable2;
                }
                this.log().error((Object)"handleAddInterface: Threw Exception during commit: ", (Throwable)ex);
                throw new FailedOperationException("Database error: " + ex.getMessage(), ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleAddNode(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.requireParm(event, "nodelabel");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        String ipaddr = event.getInterface();
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        this.log().debug((Object)("addNodeHandler:  processing addNode event for " + ipaddr));
        Connection dbConn = null;
        List eventsToSend = null;
        dbConn = DataSourceFactory.getInstance().getConnection();
        dbConn.setAutoCommit(false);
        eventsToSend = this.doAddNode(dbConn, nodeLabel, ipaddr, txNo);
        Object var10_7 = null;
        if (dbConn == null) return;
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            this.log().error((Object)"handleAddNode: Threw Exception during commit: ", (Throwable)ex);
            throw new FailedOperationException("database error: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex2) {
                    this.log().error((Object)"handleAddNode: Threw Exception during close: ", (Throwable)ex2);
                }
            }
        }
        {
            catch (SQLException sqlE) {
                this.log().error((Object)"addNodeHandler: SQLException during add node and ipaddress to tables", (Throwable)sqlE);
                throw new FailedOperationException("database error: " + sqlE.getMessage(), sqlE);
            }
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            if (dbConn == null) throw throwable;
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
            } else {
                dbConn.rollback();
            }
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error((Object)"handleAddNode: Threw Exception during close: ", (Throwable)ex);
            }
            throw throwable;
            catch (SQLException ex) {
                try {}
                catch (Throwable throwable2) {
                    if (dbConn == null) throw throwable2;
                    try {
                        dbConn.close();
                        throw throwable2;
                    }
                    catch (SQLException ex2) {
                        this.log().error((Object)"handleAddNode: Threw Exception during close: ", (Throwable)ex2);
                    }
                    throw throwable2;
                }
                this.log().error((Object)"handleAddNode: Threw Exception during commit: ", (Throwable)ex);
                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleChangeService(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkInterface(event);
        EventUtils.checkService(event);
        EventUtils.requireParm(event, "action");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        String action = EventUtils.getParm(event, "action");
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        this.log().debug((Object)("changeServiceHandler:  processing changeService event on: " + event.getInterface()));
        Connection dbConn = null;
        List eventsToSend = null;
        dbConn = DataSourceFactory.getInstance().getConnection();
        dbConn.setAutoCommit(false);
        eventsToSend = this.doChangeService(dbConn, event.getInterface(), event.getService(), action, txNo);
        Object var9_6 = null;
        if (dbConn == null) return;
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            this.log().error((Object)"handleChangeService: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException("exeption processing changeService: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex2) {
                    this.log().error((Object)("handleChangeService: Exception thrown closing connection: " + ex2));
                }
            }
        }
        {
            catch (SQLException sqlE) {
                this.log().error((Object)"SQLException during changeService on database.", (Throwable)sqlE);
                throw new FailedOperationException("exeption processing changeService: " + sqlE.getMessage(), sqlE);
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (dbConn == null) throw throwable;
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
            } else {
                dbConn.rollback();
            }
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error((Object)("handleChangeService: Exception thrown closing connection: " + ex));
            }
            throw throwable;
            catch (SQLException ex) {
                try {}
                catch (Throwable throwable2) {
                    if (dbConn == null) throw throwable2;
                    try {
                        dbConn.close();
                        throw throwable2;
                    }
                    catch (SQLException ex2) {
                        this.log().error((Object)("handleChangeService: Exception thrown closing connection: " + ex2));
                    }
                    throw throwable2;
                }
                this.log().error((Object)"handleChangeService: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException("exeption processing changeService: " + ex.getMessage(), ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleDeleteInterface(Event e) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkEventId(e);
        EventUtils.checkInterface(e);
        EventUtils.checkNodeId(e);
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(e, "txno");
        }
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("handleDeleteInterface: Event\nuei\t\t" + e.getUei() + "\neventid\t\t" + e.getDbid() + "\nnodeId\t\t" + e.getNodeid() + "\nipaddr\t\t" + e.getInterface() + "\neventtime\t" + (e.getTime() != null ? e.getTime() : "<null>")));
        }
        long txNo = EventUtils.getLongParm(e, "txno", -1L);
        Connection dbConn = null;
        List eventsToSend = null;
        dbConn = DataSourceFactory.getInstance().getConnection();
        dbConn.setAutoCommit(false);
        String source = e.getSource() == null ? "OpenNMS.Capsd" : e.getSource();
        eventsToSend = this.doDeleteInterface(dbConn, source, e.getNodeid(), e.getInterface(), txNo);
        Object var8_7 = null;
        if (dbConn == null) return;
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), e.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            this.log().error((Object)"handleDeleteInterface: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException("exeption processing delete interface: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex2) {
                    this.log().error((Object)"handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex2);
                }
            }
        }
        {
            catch (SQLException ex) {
                this.log().error((Object)("handleDeleteService:  Database error deleting service " + e.getService() + " on ipAddr " + e.getInterface() + " for node " + e.getNodeid()), (Throwable)ex);
                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (dbConn == null) throw throwable;
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), e.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
            } else {
                dbConn.rollback();
            }
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error((Object)"handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex);
            }
            throw throwable;
            catch (SQLException ex) {
                try {}
                catch (Throwable throwable2) {
                    if (dbConn == null) throw throwable2;
                    try {
                        dbConn.close();
                        throw throwable2;
                    }
                    catch (SQLException ex2) {
                        this.log().error((Object)"handleDeleteInterface: Exception thrown closing connection: ", (Throwable)ex2);
                    }
                    throw throwable2;
                }
                this.log().error((Object)"handleDeleteInterface: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException("exeption processing delete interface: " + ex.getMessage(), ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleDeleteNode(Event e) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkEventId(e);
        EventUtils.checkNodeId(e);
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(e, "txno");
        }
        long nodeid = e.getNodeid();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("handleDeleteNode: Event\nuei\t\t" + e.getUei() + "\neventid\t\t" + e.getDbid() + "\nnodeId\t\t" + nodeid + "\neventtime\t" + (e.getTime() != null ? e.getTime() : "<null>")));
        }
        long txNo = EventUtils.getLongParm(e, "txno", -1L);
        Connection dbConn = null;
        List eventsToSend = null;
        dbConn = DataSourceFactory.getInstance().getConnection();
        dbConn.setAutoCommit(false);
        String source = e.getSource() == null ? "OpenNMS.Capsd" : e.getSource();
        eventsToSend = this.doDeleteNode(dbConn, source, nodeid, txNo);
        Object var10_8 = null;
        if (dbConn == null) return;
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), e.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            this.log().error((Object)"handleDeleteNode: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException("exeption processing deleteNode: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex2) {
                    this.log().error((Object)"handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex2);
                }
            }
        }
        {
            catch (SQLException ex) {
                this.log().error((Object)("handleDeleteService:  Database error deleting service " + e.getService() + " on ipAddr " + e.getInterface() + " for node " + nodeid), (Throwable)ex);
                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (dbConn == null) throw throwable;
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), e.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
            } else {
                dbConn.rollback();
            }
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error((Object)"handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex);
            }
            throw throwable;
            catch (SQLException ex) {
                try {}
                catch (Throwable throwable2) {
                    if (dbConn == null) throw throwable2;
                    try {
                        dbConn.close();
                        throw throwable2;
                    }
                    catch (SQLException ex2) {
                        this.log().error((Object)"handleDeleteNode: Exception thrown closing connection: ", (Throwable)ex2);
                    }
                    throw throwable2;
                }
                this.log().error((Object)"handleDeleteNode: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException("exeption processing deleteNode: " + ex.getMessage(), ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleDeleteService(Event e) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkEventId(e);
        EventUtils.checkNodeId(e);
        EventUtils.checkInterface(e);
        EventUtils.checkService(e);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("handleDeleteService: Event\nuei\t\t" + e.getUei() + "\neventid\t\t" + e.getDbid() + "\nnodeid\t\t" + e.getNodeid() + "\nipaddr\t\t" + e.getInterface() + "\nservice\t\t" + e.getService() + "\neventtime\t" + (e.getTime() != null ? e.getTime() : "<null>")));
        }
        long txNo = EventUtils.getLongParm(e, "txno", -1L);
        Connection dbConn = null;
        List eventsToSend = null;
        dbConn = DataSourceFactory.getInstance().getConnection();
        dbConn.setAutoCommit(false);
        String source = e.getSource() == null ? "OpenNMS.Capsd" : e.getSource();
        eventsToSend = this.doDeleteService(dbConn, source, e.getNodeid(), e.getInterface(), e.getService(), txNo);
        Object var8_7 = null;
        if (dbConn == null) return;
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), e.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            this.log().error((Object)"handleDeleteService: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException("exeption processing deleteService: " + ex.getMessage(), ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex2) {
                    this.log().error((Object)"handleDeleteService: Exception thrown closing connection: ", (Throwable)ex2);
                }
            }
        }
        {
            catch (SQLException ex) {
                this.log().error((Object)("handleDeleteService:  Database error deleting service " + e.getService() + " on ipAddr " + e.getInterface() + " for node " + e.getNodeid()), (Throwable)ex);
                throw new FailedOperationException("database error: " + ex.getMessage(), ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (dbConn == null) throw throwable;
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), e.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
            } else {
                dbConn.rollback();
            }
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error((Object)"handleDeleteService: Exception thrown closing connection: ", (Throwable)ex);
            }
            throw throwable;
            catch (SQLException ex) {
                try {}
                catch (Throwable throwable2) {
                    if (dbConn == null) throw throwable2;
                    try {
                        dbConn.close();
                        throw throwable2;
                    }
                    catch (SQLException ex2) {
                        this.log().error((Object)"handleDeleteService: Exception thrown closing connection: ", (Throwable)ex2);
                    }
                    throw throwable2;
                }
                this.log().error((Object)"handleDeleteService: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException("exeption processing deleteService: " + ex.getMessage(), ex);
            }
        }
    }

    private void handleDupNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_scheduler.unscheduleNode((int)event.getNodeid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleForceRescan(Event event) throws InsufficientInformationException {
        block101: {
            block96: {
                block112: {
                    nodeid = -1;
                    if (!event.hasNodeid()) break block112;
                    nodeid = (int)event.getNodeid();
                    break block101;
                }
                EventUtils.checkInterface(event);
                dbc = null;
                stmt = null;
                rs = null;
                dbc = DataSourceFactory.getInstance().getConnection();
                stmt = dbc.prepareStatement(BroadcastEventProcessor.SQL_RETRIEVE_NODEID);
                stmt.setString(1, event.getInterface());
                rs = stmt.executeQuery();
                if (!rs.next()) break block96;
                nodeid = rs.getInt(1);
            }
            var8_6 = null;
            try {
                if (rs == null) ** GOTO lbl233
                rs.close();
            }
            catch (SQLException e) {
                this.log().error((Object)"handleForceRescan: Exception thrown closing resultset: ", (Throwable)e);
            }
            finally {
                block98: {
                    block97: {
                        if (stmt == null) break block97;
                        stmt.close();
                    }
                    try {
                        if (dbc != null) {
                            dbc.close();
                        }
                        break block98;
                    }
                    catch (SQLException e) {
                        this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                    }
                    break block98;
                    catch (SQLException e) {
                        try {}
                        catch (Throwable var12_24) {
                            try {
                                if (dbc != null) {
                                    dbc.close();
                                }
                            }
                            catch (SQLException e) {
                                this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                            }
                            throw var12_24;
                        }
                        this.log().error((Object)"handleForceRescan: Exception thrown closing statement: ", (Throwable)e);
                        try {
                            if (dbc != null) {
                                dbc.close();
                            }
                        }
                        catch (SQLException e) {
                            this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                        }
                    }
                }
            }
            {
                catch (SQLException sqlE) {
                    block100: {
                        this.log().error((Object)("handleForceRescan: Database error during nodeid retrieval for interface " + event.getInterface()), (Throwable)sqlE);
                        var8_7 = null;
                        if (rs == null) break block100;
                        rs.close();
                    }
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        break block101;
                    }
                    catch (SQLException e) {
                        this.log().error((Object)"handleForceRescan: Exception thrown closing statement: ", (Throwable)e);
                        break block101;
                    }
                    finally {
                        try {
                            if (dbc != null) {
                                dbc.close();
                            }
                        }
                        catch (SQLException e) {
                            this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                        }
                    }
                    catch (SQLException e) {
                        try {}
                        catch (Throwable var14_31) {
                            try {
                                if (stmt != null) {
                                    stmt.close();
                                }
                            }
                            catch (SQLException e) {
                                this.log().error((Object)"handleForceRescan: Exception thrown closing statement: ", (Throwable)e);
                            }
                            finally {
                                try {
                                    if (dbc != null) {
                                        dbc.close();
                                    }
                                }
                                catch (SQLException e) {
                                    this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                                }
                            }
                            throw var14_31;
                        }
                        this.log().error((Object)"handleForceRescan: Exception thrown closing resultset: ", (Throwable)e);
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                            break block101;
                        }
                        catch (SQLException e) {
                            this.log().error((Object)"handleForceRescan: Exception thrown closing statement: ", (Throwable)e);
                            break block101;
                        }
                        finally {
                            try {
                                if (dbc != null) {
                                    dbc.close();
                                }
                            }
                            catch (SQLException e) {
                                this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                            }
                        }
                    }
                }
            }
            catch (Throwable var7_46) {
                block108: {
                    block107: {
                        block106: {
                            var8_8 = null;
                            if (rs == null) break block106;
                            rs.close();
                        }
                        if (stmt == null) break block107;
                        stmt.close();
                    }
                    try {
                        if (dbc != null) {
                            dbc.close();
                        }
                        break block108;
                    }
                    catch (SQLException e) {
                        this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                    }
                    break block108;
                    catch (SQLException e) {
                        try {}
                        catch (Throwable var10_20) {
                            try {
                                if (dbc != null) {
                                    dbc.close();
                                }
                            }
                            catch (SQLException e) {
                                this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                            }
                            throw var10_20;
                        }
                        this.log().error((Object)"handleForceRescan: Exception thrown closing statement: ", (Throwable)e);
                        try {
                            if (dbc != null) {
                                dbc.close();
                            }
                            break block108;
                        }
                        catch (SQLException e) {
                            this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                        }
                        break block108;
                    }
                    catch (SQLException e) {
                        block109: {
                            try {}
                            catch (Throwable var14_32) {
                                block111: {
                                    block110: {
                                        if (stmt == null) break block110;
                                        stmt.close();
                                    }
                                    try {
                                        if (dbc != null) {
                                            dbc.close();
                                        }
                                        break block111;
                                    }
                                    catch (SQLException e) {
                                        this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                                    }
                                    break block111;
                                    catch (SQLException e) {
                                        try {}
                                        catch (Throwable var16_41) {
                                            try {
                                                if (dbc != null) {
                                                    dbc.close();
                                                }
                                            }
                                            catch (SQLException e) {
                                                this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                                            }
                                            throw var16_41;
                                        }
                                        this.log().error((Object)"handleForceRescan: Exception thrown closing statement: ", (Throwable)e);
                                        try {
                                            if (dbc != null) {
                                                dbc.close();
                                            }
                                        }
                                        catch (SQLException e) {
                                            this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                                        }
                                    }
                                }
                                throw var14_32;
                            }
                            this.log().error((Object)"handleForceRescan: Exception thrown closing resultset: ", (Throwable)e);
                            if (stmt == null) break block109;
                            stmt.close();
                        }
                        try {
                            if (dbc != null) {
                                dbc.close();
                            }
                            break block108;
                        }
                        catch (SQLException e) {
                            this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                        }
                        break block108;
                        catch (SQLException e) {
                            try {}
                            catch (Throwable var12_26) {
                                try {
                                    if (dbc != null) {
                                        dbc.close();
                                    }
                                }
                                catch (SQLException e) {
                                    this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                                }
                                throw var12_26;
                            }
                            this.log().error((Object)"handleForceRescan: Exception thrown closing statement: ", (Throwable)e);
                            try {
                                if (dbc != null) {
                                    dbc.close();
                                }
                            }
                            catch (SQLException e) {
                                this.log().error((Object)"handleForceRescan: Exception thrown closing connection: ", (Throwable)e);
                            }
                        }
                    }
                }
                throw var7_46;
            }
        }
        if (nodeid == -1) {
            this.log().error((Object)("handleForceRescan: Nodeid retrieval for interface " + event.getInterface() + " failed.  Unable to perform rescan."));
        } else {
            this.m_scheduler.forceRescan(nodeid);
        }
    }

    private void handleNewSuspect(Event event) throws InsufficientInformationException {
        EventUtils.checkInterface(event);
        try {
            this.log().debug((Object)("onMessage: Adding interface to suspectInterface Q: " + event.getInterface()));
            this.m_suspectQ.add((Object)new SuspectEventProcessor(event.getInterface()));
        }
        catch (Exception ex) {
            this.log().error((Object)"onMessage: Failed to add interface to suspect queue", (Throwable)ex);
        }
    }

    private void handleNodeAdded(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        try {
            this.m_scheduler.scheduleNode((int)event.getNodeid());
        }
        catch (SQLException sqlE) {
            this.log().error((Object)("onMessage: SQL exception while attempting to schedule node " + event.getNodeid()), (Throwable)sqlE);
        }
    }

    private void handleNodeDeleted(Event event) throws InsufficientInformationException {
        EventUtils.checkNodeId(event);
        this.m_scheduler.unscheduleNode((int)event.getNodeid());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleUpdateServer(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkInterface(event);
        EventUtils.checkHost(event);
        EventUtils.requireParm(event, "action");
        EventUtils.requireParm(event, "nodelabel");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        String action = EventUtils.getParm(event, "action");
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("updateServerHandler:  processing updateServer event for: " + event.getInterface() + " on OpenNMS server: " + this.getLocalServer()));
        }
        Connection dbConn = null;
        List eventsToSend = null;
        dbConn = DataSourceFactory.getInstance().getConnection();
        dbConn.setAutoCommit(false);
        eventsToSend = this.doUpdateServer(dbConn, nodeLabel, event.getInterface(), action, this.getLocalServer(), txNo);
        Object var10_7 = null;
        if (dbConn == null) return;
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            this.log().error((Object)"handleUpdateServer: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException("SQLException during updateServer on database.", ex);
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex2) {
                    this.log().error((Object)"handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex2);
                }
            }
        }
        {
            catch (SQLException sqlE) {
                this.log().error((Object)"SQLException during updateServer on database.", (Throwable)sqlE);
                throw new FailedOperationException("SQLException during updateServer on database.", sqlE);
            }
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            if (dbConn == null) throw throwable;
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
            } else {
                dbConn.rollback();
            }
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error((Object)"handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex);
            }
            throw throwable;
            catch (SQLException ex) {
                try {}
                catch (Throwable throwable2) {
                    if (dbConn == null) throw throwable2;
                    try {
                        dbConn.close();
                        throw throwable2;
                    }
                    catch (SQLException ex2) {
                        this.log().error((Object)"handleUpdateServer: Exception thrown closing connection: ", (Throwable)ex2);
                    }
                    throw throwable2;
                }
                this.log().error((Object)"handleUpdateServer: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException("SQLException during updateServer on database.", ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleUpdateService(Event event) throws InsufficientInformationException, FailedOperationException {
        EventUtils.checkInterface(event);
        EventUtils.checkService(event);
        EventUtils.requireParm(event, "nodelabel");
        EventUtils.requireParm(event, "action");
        if (BroadcastEventProcessor.isXmlRpcEnabled()) {
            EventUtils.requireParm(event, "txno");
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        String action = EventUtils.getParm(event, "action");
        String nodeLabel = EventUtils.getParm(event, "nodelabel");
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("handleUpdateService:  processing updateService event for : " + event.getService() + " on : " + event.getInterface()));
        }
        List eventsToSend = null;
        Connection dbConn = null;
        dbConn = DataSourceFactory.getInstance().getConnection();
        dbConn.setAutoCommit(false);
        eventsToSend = this.doUpdateService(dbConn, nodeLabel, event.getInterface(), event.getService(), action, txNo);
        Object var10_7 = null;
        if (dbConn == null) return;
        try {
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
                return;
            }
            dbConn.rollback();
            return;
        }
        catch (SQLException ex) {
            this.log().error((Object)"handleUpdateService: Exception thrown during commit/rollback: ", (Throwable)ex);
            throw new FailedOperationException(ex.getMessage());
        }
        finally {
            if (dbConn != null) {
                try {
                    dbConn.close();
                }
                catch (SQLException ex2) {
                    this.log().error((Object)"handleUpdateService: Exception thrown during close: ", (Throwable)ex2);
                }
            }
        }
        {
            catch (SQLException sqlE) {
                this.log().error((Object)"SQLException during handleUpdateService on database.", (Throwable)sqlE);
                throw new FailedOperationException(sqlE.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            if (dbConn == null) throw throwable;
            if (eventsToSend != null) {
                dbConn.commit();
                Iterator it = eventsToSend.iterator();
                while (it.hasNext()) {
                    EventUtils.sendEvent((Event)it.next(), event.getUei(), txNo, BroadcastEventProcessor.isXmlRpcEnabled());
                }
            } else {
                dbConn.rollback();
            }
            if (dbConn == null) throw throwable;
            try {
                dbConn.close();
                throw throwable;
            }
            catch (SQLException ex) {
                this.log().error((Object)"handleUpdateService: Exception thrown during close: ", (Throwable)ex);
            }
            throw throwable;
            catch (SQLException ex) {
                try {}
                catch (Throwable throwable2) {
                    if (dbConn == null) throw throwable2;
                    try {
                        dbConn.close();
                        throw throwable2;
                    }
                    catch (SQLException ex2) {
                        this.log().error((Object)"handleUpdateService: Exception thrown during close: ", (Throwable)ex2);
                    }
                    throw throwable2;
                }
                this.log().error((Object)"handleUpdateService: Exception thrown during commit/rollback: ", (Throwable)ex);
                throw new FailedOperationException(ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean interfaceExists(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_IPINTERFACE_EXIST);
            stmt.setString(1, nodeLabel);
            stmt.setString(2, ipaddr);
            rs = stmt.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List markAllServicesForInterfaceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, long txNo) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            LinkedList<Event> eventsToSend = new LinkedList<Event>();
            String DB_FIND_SERVICES_FOR_INTERFACE = "SELECT DISTINCT service.serviceName FROM ifservices as ifservices, service as service WHERE ifservices.nodeID = ? and ifservices.ipAddr = ? and ifservices.status != 'D' and ifservices.serviceID = service.serviceID";
            stmt = dbConn.prepareStatement("SELECT DISTINCT service.serviceName FROM ifservices as ifservices, service as service WHERE ifservices.nodeID = ? and ifservices.ipAddr = ? and ifservices.status != 'D' and ifservices.serviceID = service.serviceID");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            rs = stmt.executeQuery();
            HashSet<String> services = new HashSet<String>();
            while (rs.next()) {
                String serviceName = rs.getString(1);
                this.log().debug((Object)("found service " + serviceName + " for ipAddr " + ipAddr + " node " + nodeId));
                services.add(serviceName);
            }
            rs.close();
            rs = null;
            stmt.close();
            stmt = null;
            String DB_MARK_SERVICES_FOR_INTERFACE = "UPDATE ifservices SET status = 'D' where ifservices.nodeID = ? and ifservices.ipAddr = ?";
            stmt = dbConn.prepareStatement("UPDATE ifservices SET status = 'D' where ifservices.nodeID = ? and ifservices.ipAddr = ?");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.executeUpdate();
            for (String serviceName : services) {
                this.log().debug((Object)("creating event for service " + serviceName + " for ipAddr " + ipAddr + " node " + nodeId));
                eventsToSend.add(EventUtils.createServiceDeletedEvent(source, nodeId, ipAddr, serviceName, txNo));
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("markServicesDeleted: marked service deleted: " + nodeId + "/" + ipAddr));
            }
            LinkedList<Event> linkedList = eventsToSend;
            return linkedList;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List markInterfaceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, long txNo) throws SQLException {
        String DB_FIND_INTERFACE = "UPDATE ipinterface SET isManaged = 'D' WHERE nodeid = ? and ipAddr = ? and isManaged != 'D'";
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement("UPDATE ipinterface SET isManaged = 'D' WHERE nodeid = ? and ipAddr = ? and isManaged != 'D'");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            int count = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("markServicesDeleted: marked service deleted: " + nodeId + "/" + ipAddr));
            }
            if (count > 0) {
                List<Event> list = Collections.singletonList(EventUtils.createInterfaceDeletedEvent(source, nodeId, ipAddr, txNo));
                return list;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List markInterfacesAndServicesDeleted(Connection dbConn, String source, long nodeId, long txNo) throws SQLException {
        LinkedList eventsToSend = new LinkedList();
        String DB_FIND_IFS_FOR_NODE = "SELECT ipinterface.ipaddr FROM ipinterface WHERE ipinterface.nodeid = ? and ipinterface.ismanaged != 'D'";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement("SELECT ipinterface.ipaddr FROM ipinterface WHERE ipinterface.nodeid = ? and ipinterface.ismanaged != 'D'");
            stmt.setLong(1, nodeId);
            rs = stmt.executeQuery();
            HashSet<String> ipAddrs = new HashSet<String>();
            while (rs.next()) {
                String ipAddr = rs.getString(1);
                this.log().debug((Object)("found interface " + ipAddr + " for node " + nodeId));
                ipAddrs.add(ipAddr);
            }
            for (String ipAddr : ipAddrs) {
                this.log().debug((Object)("deleting interface " + ipAddr + " for node " + nodeId));
                eventsToSend.addAll(this.markAllServicesForInterfaceDeleted(dbConn, source, nodeId, ipAddr, txNo));
                eventsToSend.addAll(this.markInterfaceDeleted(dbConn, source, nodeId, ipAddr, txNo));
            }
            LinkedList linkedList = eventsToSend;
            return linkedList;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List markNodeDeleted(Connection dbConn, String source, long nodeId, long txNo) throws SQLException {
        String DB_FIND_INTERFACE = "UPDATE node SET nodeType = 'D' WHERE nodeid = ? and nodeType != 'D'";
        PreparedStatement stmt = null;
        try {
            stmt = dbConn.prepareStatement("UPDATE node SET nodeType = 'D' WHERE nodeid = ? and nodeType != 'D'");
            stmt.setLong(1, nodeId);
            int count = stmt.executeUpdate();
            this.log().debug((Object)("markServicesDeleted: marked service deleted: " + nodeId));
            if (count > 0) {
                List<Event> list = Collections.singletonList(EventUtils.createNodeDeletedEvent(source, nodeId, txNo));
                return list;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List markServiceDeleted(Connection dbConn, String source, long nodeId, String ipAddr, String service, long txNo) throws SQLException {
        PreparedStatement stmt = null;
        String DB_MARK_SERVICE_DELETED = "UPDATE ifservices SET status='D' FROM service WHERE ifservices.serviceID = service.serviceID AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.serviceName=?";
        try {
            stmt = dbConn.prepareStatement("UPDATE ifservices SET status='D' FROM service WHERE ifservices.serviceID = service.serviceID AND ifservices.nodeID=? AND ifservices.ipAddr=? AND service.serviceName=?");
            stmt.setLong(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setString(3, service);
            int count = stmt.executeUpdate();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("markServiceDeleted: marked service deleted: " + nodeId + "/" + ipAddr + "/" + service));
            }
            if (count > 0) {
                List<Event> list = Collections.singletonList(EventUtils.createServiceDeletedEvent(source, nodeId, ipAddr, service, txNo));
                return list;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nodeExists(Connection dbConn, String nodeLabel) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_QUERY_NODE_EXIST);
            stmt.setString(1, nodeLabel);
            rs = stmt.executeQuery();
            boolean bl = rs.next();
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private void notifyEventError(Event event, String msg, Exception ex) {
        if (!BroadcastEventProcessor.isXmlRpcEnabled()) {
            return;
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (txNo != -1L && this.m_notifySet.contains(event.getUei())) {
            int status = 2;
            XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, event.getUei(), msg + ex.getMessage(), status, "OpenNMS.Capsd");
        }
    }

    private void notifyEventReceived(Event event) {
        if (!BroadcastEventProcessor.isXmlRpcEnabled()) {
            return;
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (txNo != -1L && this.m_notifySet.contains(event.getUei())) {
            StringBuffer message = new StringBuffer("Received event: ");
            message.append(event.getUei());
            message.append(" : ");
            message.append(event);
            int status = 0;
            XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, event.getUei(), message.toString(), status, "OpenNMS.Capsd");
        }
    }

    private void notifyEventSuccess(Event event) {
        if (!BroadcastEventProcessor.isXmlRpcEnabled()) {
            return;
        }
        long txNo = EventUtils.getLongParm(event, "txno", -1L);
        if (txNo != -1L && this.m_notifySet.contains(event.getUei())) {
            StringBuffer message = new StringBuffer("Completed processing event: ");
            message.append(event.getUei());
            message.append(" : ");
            message.append(event);
            int status = 1;
            XmlrpcUtil.createAndSendXmlrpcNotificationEvent(txNo, event.getUei(), message.toString(), status, "OpenNMS.Capsd");
        }
    }

    public void onEvent(Event event) {
        try {
            String eventUei = event.getUei();
            if (eventUei == null) {
                return;
            }
            this.log().debug((Object)("Received event: " + eventUei));
            this.notifyEventReceived(event);
            if (eventUei.equals("uei.opennms.org/internal/discovery/newSuspect")) {
                this.handleNewSuspect(event);
            } else if (eventUei.equals("uei.opennms.org/internal/capsd/forceRescan")) {
                this.handleForceRescan(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/capsd/updateServer")) {
                this.handleUpdateServer(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/capsd/updateService")) {
                this.handleUpdateService(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/capsd/addNode")) {
                this.handleAddNode(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/capsd/deleteNode")) {
                this.handleDeleteNode(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/capsd/addInterface")) {
                this.handleAddInterface(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/capsd/deleteInterface")) {
                this.handleDeleteInterface(event);
            } else if (event.getUei().equals("uei.opennms.org/nodes/deleteService")) {
                this.handleDeleteService(event);
            } else if (event.getUei().equals("uei.opennms.org/internal/capsd/changeService")) {
                this.handleChangeService(event);
            } else if (eventUei.equals("uei.opennms.org/nodes/nodeAdded")) {
                this.handleNodeAdded(event);
            } else if (eventUei.equals("uei.opennms.org/nodes/nodeDeleted")) {
                this.handleNodeDeleted(event);
            } else if (eventUei.equals("uei.opennms.org/nodes/duplicateNodeDeleted")) {
                this.handleDupNodeDeleted(event);
            }
            this.notifyEventSuccess(event);
        }
        catch (InsufficientInformationException ex) {
            this.log().info((Object)("BroadcastEventProcessor: insufficient information in event, discarding it: " + ex.getMessage()));
            this.notifyEventError(event, "Invalid parameters: ", ex);
        }
        catch (FailedOperationException ex) {
            this.log().error((Object)("BroadcastEventProcessor: operation failed for event: " + event.getUei() + ", exception: " + ex.getMessage()));
            this.notifyEventError(event, "processing failed: ", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean serviceMappingExists(Connection dbConn, String ipaddr, String serviceName) throws SQLException {
        PreparedStatement stmt = null;
        try {
            boolean mapExists;
            stmt = dbConn.prepareStatement(SQL_QUERY_SERVICE_MAPPING_EXIST);
            stmt.setString(1, ipaddr);
            stmt.setString(2, serviceName);
            ResultSet rs = stmt.executeQuery();
            boolean bl = mapExists = rs.next();
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int verifyServiceExists(Connection dbConn, String serviceName) throws SQLException, FailedOperationException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = dbConn.prepareStatement(SQL_RETRIEVE_SERVICE_ID);
            stmt.setString(1, serviceName);
            rs = stmt.executeQuery();
            int serviceId = -1;
            while (rs.next()) {
                this.log().debug((Object)("verifyServiceExists: retrieve serviceid for service " + serviceName));
                serviceId = rs.getInt(1);
            }
            if (serviceId < 0) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("verifyServiceExists: the specified service: " + serviceName + " does not exist in the database."));
                }
                throw new FailedOperationException("Invalid service: " + serviceName);
            }
            int n = serviceId;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private void verifyInterfaceExists(Connection dbConn, String nodeLabel, String ipaddr) throws SQLException, FailedOperationException {
        if (!this.interfaceExists(dbConn, nodeLabel, ipaddr)) {
            throw new FailedOperationException("Interface " + ipaddr + " does not exist on a node with nodeLabel " + nodeLabel);
        }
    }
}

