/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBTools {
    private static int _counter;
    private static DBTools _instance;
    public static final String JDBC_HOST = "OPENNMS_JDBC_HOSTNAME";
    public static int MIN_PORT_VALUE;
    public static int MAX_PORT_VALUE;
    public static final String DEFAULT_JDBC_DRIVER = "com.sybase.jdbc2.jdbc.SybDriver";
    public static final String DEFAULT_DATABASE_USER = "sa";
    public static final int DEFAULT_PORT = 4100;
    public static final String DEFAULT_DATABASE_PASSWORD = "";
    public static final String DEFAULT_URL = "jdbc:sybase:Tds:OPENNMS_JDBC_HOSTNAME/tempdb";
    private static final Pattern _pattern;

    private DBTools() {
    }

    public static synchronized DBTools getInstance() {
        if (_instance == null) {
            _instance = new DBTools();
        }
        ++_counter;
        return _instance;
    }

    public int getNumberOfInstances() {
        return _counter;
    }

    public static String constructUrl(String url_, String hostname_) throws IllegalArgumentException, NullPointerException {
        String url = null;
        if (url_ == null) {
            throw new NullPointerException(DBTools.class.getName() + ": url cannot be null");
        }
        if (hostname_ == null) {
            throw new NullPointerException(DBTools.class.getName() + ": hostname cannot be null");
        }
        Matcher match = _pattern.matcher(url_);
        url = match.replaceFirst(hostname_);
        return url;
    }

    static {
        MIN_PORT_VALUE = 1024;
        MAX_PORT_VALUE = 65535;
        _pattern = Pattern.compile(JDBC_HOST);
    }
}

