/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.views;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Category
implements Serializable {
    private String _label;
    private String _categoryComment;
    private double _normal;
    private boolean _has_normal;
    private double _warning;
    private boolean _has_warning;
    private ArrayList _serviceList = new ArrayList();
    private String _rule;

    public void addService(String vService) throws IndexOutOfBoundsException {
        this._serviceList.add(vService);
    }

    public void addService(int index, String vService) throws IndexOutOfBoundsException {
        this._serviceList.add(index, vService);
    }

    public void clearService() {
        this._serviceList.clear();
    }

    public void deleteNormal() {
        this._has_normal = false;
    }

    public void deleteWarning() {
        this._has_warning = false;
    }

    public Enumeration enumerateService() {
        return new IteratorEnumeration(this._serviceList.iterator());
    }

    public String getCategoryComment() {
        return this._categoryComment;
    }

    public String getLabel() {
        return this._label;
    }

    public double getNormal() {
        return this._normal;
    }

    public String getRule() {
        return this._rule;
    }

    public String getService(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._serviceList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._serviceList.get(index);
    }

    public String[] getService() {
        int size = this._serviceList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._serviceList.get(index);
        }
        return mArray;
    }

    public ArrayList getServiceCollection() {
        return this._serviceList;
    }

    public int getServiceCount() {
        return this._serviceList.size();
    }

    public double getWarning() {
        return this._warning;
    }

    public boolean hasNormal() {
        return this._has_normal;
    }

    public boolean hasWarning() {
        return this._has_warning;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeService(String vService) {
        boolean removed = this._serviceList.remove(vService);
        return removed;
    }

    public void setCategoryComment(String categoryComment) {
        this._categoryComment = categoryComment;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public void setNormal(double normal) {
        this._normal = normal;
        this._has_normal = true;
    }

    public void setRule(String rule) {
        this._rule = rule;
    }

    public void setService(int index, String vService) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._serviceList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._serviceList.set(index, vService);
    }

    public void setService(String[] serviceArray) {
        this._serviceList.clear();
        for (int i = 0; i < serviceArray.length; ++i) {
            this._serviceList.add(serviceArray[i]);
        }
    }

    public void setService(ArrayList serviceCollection) {
        this._serviceList.clear();
        for (int i = 0; i < serviceCollection.size(); ++i) {
            this._serviceList.add((String)serviceCollection.get(i));
        }
    }

    public void setServiceCollection(ArrayList serviceCollection) {
        this._serviceList = serviceCollection;
    }

    public void setWarning(double warning) {
        this._warning = warning;
        this._has_warning = true;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Category)Unmarshaller.unmarshal(Category.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

