/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.threshd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.threshd.Expression;
import org.opennms.netmgt.config.threshd.Threshold;
import org.xml.sax.ContentHandler;

public class Group
implements Serializable {
    private String _name;
    private String _rrdRepository;
    private ArrayList _thresholdList = new ArrayList();
    private ArrayList _expressionList = new ArrayList();

    public void addExpression(Expression vExpression) throws IndexOutOfBoundsException {
        this._expressionList.add(vExpression);
    }

    public void addExpression(int index, Expression vExpression) throws IndexOutOfBoundsException {
        this._expressionList.add(index, vExpression);
    }

    public void addThreshold(Threshold vThreshold) throws IndexOutOfBoundsException {
        this._thresholdList.add(vThreshold);
    }

    public void addThreshold(int index, Threshold vThreshold) throws IndexOutOfBoundsException {
        this._thresholdList.add(index, vThreshold);
    }

    public void clearExpression() {
        this._expressionList.clear();
    }

    public void clearThreshold() {
        this._thresholdList.clear();
    }

    public Enumeration enumerateExpression() {
        return new IteratorEnumeration(this._expressionList.iterator());
    }

    public Enumeration enumerateThreshold() {
        return new IteratorEnumeration(this._thresholdList.iterator());
    }

    public Expression getExpression(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._expressionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Expression)this._expressionList.get(index);
    }

    public Expression[] getExpression() {
        int size = this._expressionList.size();
        Expression[] mArray = new Expression[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Expression)this._expressionList.get(index);
        }
        return mArray;
    }

    public ArrayList getExpressionCollection() {
        return this._expressionList;
    }

    public int getExpressionCount() {
        return this._expressionList.size();
    }

    public String getName() {
        return this._name;
    }

    public String getRrdRepository() {
        return this._rrdRepository;
    }

    public Threshold getThreshold(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._thresholdList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Threshold)this._thresholdList.get(index);
    }

    public Threshold[] getThreshold() {
        int size = this._thresholdList.size();
        Threshold[] mArray = new Threshold[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Threshold)this._thresholdList.get(index);
        }
        return mArray;
    }

    public ArrayList getThresholdCollection() {
        return this._thresholdList;
    }

    public int getThresholdCount() {
        return this._thresholdList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeExpression(Expression vExpression) {
        boolean removed = this._expressionList.remove(vExpression);
        return removed;
    }

    public boolean removeThreshold(Threshold vThreshold) {
        boolean removed = this._thresholdList.remove(vThreshold);
        return removed;
    }

    public void setExpression(int index, Expression vExpression) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._expressionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._expressionList.set(index, vExpression);
    }

    public void setExpression(Expression[] expressionArray) {
        this._expressionList.clear();
        for (int i = 0; i < expressionArray.length; ++i) {
            this._expressionList.add(expressionArray[i]);
        }
    }

    public void setExpression(ArrayList expressionCollection) {
        this._expressionList.clear();
        for (int i = 0; i < expressionCollection.size(); ++i) {
            this._expressionList.add((Expression)expressionCollection.get(i));
        }
    }

    public void setExpressionCollection(ArrayList expressionCollection) {
        this._expressionList = expressionCollection;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRrdRepository(String rrdRepository) {
        this._rrdRepository = rrdRepository;
    }

    public void setThreshold(int index, Threshold vThreshold) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._thresholdList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._thresholdList.set(index, vThreshold);
    }

    public void setThreshold(Threshold[] thresholdArray) {
        this._thresholdList.clear();
        for (int i = 0; i < thresholdArray.length; ++i) {
            this._thresholdList.add(thresholdArray[i]);
        }
    }

    public void setThreshold(ArrayList thresholdCollection) {
        this._thresholdList.clear();
        for (int i = 0; i < thresholdCollection.size(); ++i) {
            this._thresholdList.add((Threshold)thresholdCollection.get(i));
        }
    }

    public void setThresholdCollection(ArrayList thresholdCollection) {
        this._thresholdList = thresholdCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Group)Unmarshaller.unmarshal(Group.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

