/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmp;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.common.Range;
import org.xml.sax.ContentHandler;

public class Definition
implements Serializable {
    private int _retry;
    private boolean _has_retry;
    private int _timeout;
    private boolean _has_timeout;
    private String _readCommunity;
    private String _writeCommunity;
    private String _proxyHost;
    private int _port;
    private boolean _has_port;
    private String _version;
    private int _maxVarsPerPdu = 10;
    private boolean _has_maxVarsPerPdu;
    private int _maxRequestSize = 65535;
    private boolean _has_maxRequestSize;
    private String _securityName;
    private String _authPassphrase;
    private String _authProtocol;
    private String _engineId;
    private String _contextEngineId;
    private String _contextName;
    private String _privacyPassphrase;
    private String _privacyProtocol;
    private String _enterpriseId;
    private ArrayList _rangeList = new ArrayList();
    private ArrayList _specificList = new ArrayList();
    private ArrayList _ipMatchList = new ArrayList();

    public void addIpMatch(String vIpMatch) throws IndexOutOfBoundsException {
        this._ipMatchList.add(vIpMatch);
    }

    public void addIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        this._ipMatchList.add(index, vIpMatch);
    }

    public void addRange(Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(vRange);
    }

    public void addRange(int index, Range vRange) throws IndexOutOfBoundsException {
        this._rangeList.add(index, vRange);
    }

    public void addSpecific(String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(vSpecific);
    }

    public void addSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        this._specificList.add(index, vSpecific);
    }

    public void clearIpMatch() {
        this._ipMatchList.clear();
    }

    public void clearRange() {
        this._rangeList.clear();
    }

    public void clearSpecific() {
        this._specificList.clear();
    }

    public void deleteMaxRequestSize() {
        this._has_maxRequestSize = false;
    }

    public void deleteMaxVarsPerPdu() {
        this._has_maxVarsPerPdu = false;
    }

    public void deletePort() {
        this._has_port = false;
    }

    public void deleteRetry() {
        this._has_retry = false;
    }

    public void deleteTimeout() {
        this._has_timeout = false;
    }

    public Enumeration enumerateIpMatch() {
        return new IteratorEnumeration(this._ipMatchList.iterator());
    }

    public Enumeration enumerateRange() {
        return new IteratorEnumeration(this._rangeList.iterator());
    }

    public Enumeration enumerateSpecific() {
        return new IteratorEnumeration(this._specificList.iterator());
    }

    public String getAuthPassphrase() {
        return this._authPassphrase;
    }

    public String getAuthProtocol() {
        return this._authProtocol;
    }

    public String getContextEngineId() {
        return this._contextEngineId;
    }

    public String getContextName() {
        return this._contextName;
    }

    public String getEngineId() {
        return this._engineId;
    }

    public String getEnterpriseId() {
        return this._enterpriseId;
    }

    public String getIpMatch(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._ipMatchList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._ipMatchList.get(index);
    }

    public String[] getIpMatch() {
        int size = this._ipMatchList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._ipMatchList.get(index);
        }
        return mArray;
    }

    public ArrayList getIpMatchCollection() {
        return this._ipMatchList;
    }

    public int getIpMatchCount() {
        return this._ipMatchList.size();
    }

    public int getMaxRequestSize() {
        return this._maxRequestSize;
    }

    public int getMaxVarsPerPdu() {
        return this._maxVarsPerPdu;
    }

    public int getPort() {
        return this._port;
    }

    public String getPrivacyPassphrase() {
        return this._privacyPassphrase;
    }

    public String getPrivacyProtocol() {
        return this._privacyProtocol;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public Range getRange(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._rangeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Range)this._rangeList.get(index);
    }

    public Range[] getRange() {
        int size = this._rangeList.size();
        Range[] mArray = new Range[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Range)this._rangeList.get(index);
        }
        return mArray;
    }

    public ArrayList getRangeCollection() {
        return this._rangeList;
    }

    public int getRangeCount() {
        return this._rangeList.size();
    }

    public String getReadCommunity() {
        return this._readCommunity;
    }

    public int getRetry() {
        return this._retry;
    }

    public String getSecurityName() {
        return this._securityName;
    }

    public String getSpecific(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._specificList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._specificList.get(index);
    }

    public String[] getSpecific() {
        int size = this._specificList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._specificList.get(index);
        }
        return mArray;
    }

    public ArrayList getSpecificCollection() {
        return this._specificList;
    }

    public int getSpecificCount() {
        return this._specificList.size();
    }

    public int getTimeout() {
        return this._timeout;
    }

    public String getVersion() {
        return this._version;
    }

    public String getWriteCommunity() {
        return this._writeCommunity;
    }

    public boolean hasMaxRequestSize() {
        return this._has_maxRequestSize;
    }

    public boolean hasMaxVarsPerPdu() {
        return this._has_maxVarsPerPdu;
    }

    public boolean hasPort() {
        return this._has_port;
    }

    public boolean hasRetry() {
        return this._has_retry;
    }

    public boolean hasTimeout() {
        return this._has_timeout;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeIpMatch(String vIpMatch) {
        boolean removed = this._ipMatchList.remove(vIpMatch);
        return removed;
    }

    public boolean removeRange(Range vRange) {
        boolean removed = this._rangeList.remove(vRange);
        return removed;
    }

    public boolean removeSpecific(String vSpecific) {
        boolean removed = this._specificList.remove(vSpecific);
        return removed;
    }

    public void setAuthPassphrase(String authPassphrase) {
        this._authPassphrase = authPassphrase;
    }

    public void setAuthProtocol(String authProtocol) {
        this._authProtocol = authProtocol;
    }

    public void setContextEngineId(String contextEngineId) {
        this._contextEngineId = contextEngineId;
    }

    public void setContextName(String contextName) {
        this._contextName = contextName;
    }

    public void setEngineId(String engineId) {
        this._engineId = engineId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this._enterpriseId = enterpriseId;
    }

    public void setIpMatch(int index, String vIpMatch) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._ipMatchList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._ipMatchList.set(index, vIpMatch);
    }

    public void setIpMatch(String[] ipMatchArray) {
        this._ipMatchList.clear();
        for (int i = 0; i < ipMatchArray.length; ++i) {
            this._ipMatchList.add(ipMatchArray[i]);
        }
    }

    public void setIpMatch(ArrayList ipMatchCollection) {
        this._ipMatchList.clear();
        for (int i = 0; i < ipMatchCollection.size(); ++i) {
            this._ipMatchList.add((String)ipMatchCollection.get(i));
        }
    }

    public void setIpMatchCollection(ArrayList ipMatchCollection) {
        this._ipMatchList = ipMatchCollection;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this._maxRequestSize = maxRequestSize;
        this._has_maxRequestSize = true;
    }

    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this._maxVarsPerPdu = maxVarsPerPdu;
        this._has_maxVarsPerPdu = true;
    }

    public void setPort(int port) {
        this._port = port;
        this._has_port = true;
    }

    public void setPrivacyPassphrase(String privacyPassphrase) {
        this._privacyPassphrase = privacyPassphrase;
    }

    public void setPrivacyProtocol(String privacyProtocol) {
        this._privacyProtocol = privacyProtocol;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public void setRange(int index, Range vRange) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._rangeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._rangeList.set(index, vRange);
    }

    public void setRange(Range[] rangeArray) {
        this._rangeList.clear();
        for (int i = 0; i < rangeArray.length; ++i) {
            this._rangeList.add(rangeArray[i]);
        }
    }

    public void setRange(ArrayList rangeCollection) {
        this._rangeList.clear();
        for (int i = 0; i < rangeCollection.size(); ++i) {
            this._rangeList.add((Range)rangeCollection.get(i));
        }
    }

    public void setRangeCollection(ArrayList rangeCollection) {
        this._rangeList = rangeCollection;
    }

    public void setReadCommunity(String readCommunity) {
        this._readCommunity = readCommunity;
    }

    public void setRetry(int retry) {
        this._retry = retry;
        this._has_retry = true;
    }

    public void setSecurityName(String securityName) {
        this._securityName = securityName;
    }

    public void setSpecific(int index, String vSpecific) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._specificList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._specificList.set(index, vSpecific);
    }

    public void setSpecific(String[] specificArray) {
        this._specificList.clear();
        for (int i = 0; i < specificArray.length; ++i) {
            this._specificList.add(specificArray[i]);
        }
    }

    public void setSpecific(ArrayList specificCollection) {
        this._specificList.clear();
        for (int i = 0; i < specificCollection.size(); ++i) {
            this._specificList.add((String)specificCollection.get(i));
        }
    }

    public void setSpecificCollection(ArrayList specificCollection) {
        this._specificList = specificCollection;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
        this._has_timeout = true;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setWriteCommunity(String writeCommunity) {
        this._writeCommunity = writeCommunity;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Definition)Unmarshaller.unmarshal(Definition.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

