/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.notifd.AutoAcknowledge;
import org.opennms.netmgt.config.notifd.Queue;
import org.xml.sax.ContentHandler;

public class NotifdConfiguration
implements Serializable {
    private String _status;
    private String _pagesSent;
    private String _nextNotifId;
    private String _nextUserNotifId;
    private String _nextGroupId;
    private String _outstandingNoticesSql;
    private String _acknowledgeIdSql;
    private String _acknowledgeUpdateSql;
    private boolean _matchAll;
    private boolean _has_matchAll;
    private ArrayList _autoAcknowledgeList = new ArrayList();
    private ArrayList _queueList = new ArrayList();
    private ArrayList _outageCalendarList = new ArrayList();

    public void addAutoAcknowledge(AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        this._autoAcknowledgeList.add(vAutoAcknowledge);
    }

    public void addAutoAcknowledge(int index, AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        this._autoAcknowledgeList.add(index, vAutoAcknowledge);
    }

    public void addOutageCalendar(String vOutageCalendar) throws IndexOutOfBoundsException {
        this._outageCalendarList.add(vOutageCalendar);
    }

    public void addOutageCalendar(int index, String vOutageCalendar) throws IndexOutOfBoundsException {
        this._outageCalendarList.add(index, vOutageCalendar);
    }

    public void addQueue(Queue vQueue) throws IndexOutOfBoundsException {
        this._queueList.add(vQueue);
    }

    public void addQueue(int index, Queue vQueue) throws IndexOutOfBoundsException {
        this._queueList.add(index, vQueue);
    }

    public void clearAutoAcknowledge() {
        this._autoAcknowledgeList.clear();
    }

    public void clearOutageCalendar() {
        this._outageCalendarList.clear();
    }

    public void clearQueue() {
        this._queueList.clear();
    }

    public void deleteMatchAll() {
        this._has_matchAll = false;
    }

    public Enumeration enumerateAutoAcknowledge() {
        return new IteratorEnumeration(this._autoAcknowledgeList.iterator());
    }

    public Enumeration enumerateOutageCalendar() {
        return new IteratorEnumeration(this._outageCalendarList.iterator());
    }

    public Enumeration enumerateQueue() {
        return new IteratorEnumeration(this._queueList.iterator());
    }

    public String getAcknowledgeIdSql() {
        return this._acknowledgeIdSql;
    }

    public String getAcknowledgeUpdateSql() {
        return this._acknowledgeUpdateSql;
    }

    public AutoAcknowledge getAutoAcknowledge(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._autoAcknowledgeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (AutoAcknowledge)this._autoAcknowledgeList.get(index);
    }

    public AutoAcknowledge[] getAutoAcknowledge() {
        int size = this._autoAcknowledgeList.size();
        AutoAcknowledge[] mArray = new AutoAcknowledge[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (AutoAcknowledge)this._autoAcknowledgeList.get(index);
        }
        return mArray;
    }

    public ArrayList getAutoAcknowledgeCollection() {
        return this._autoAcknowledgeList;
    }

    public int getAutoAcknowledgeCount() {
        return this._autoAcknowledgeList.size();
    }

    public boolean getMatchAll() {
        return this._matchAll;
    }

    public String getNextGroupId() {
        return this._nextGroupId;
    }

    public String getNextNotifId() {
        return this._nextNotifId;
    }

    public String getNextUserNotifId() {
        return this._nextUserNotifId;
    }

    public String getOutageCalendar(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._outageCalendarList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._outageCalendarList.get(index);
    }

    public String[] getOutageCalendar() {
        int size = this._outageCalendarList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._outageCalendarList.get(index);
        }
        return mArray;
    }

    public ArrayList getOutageCalendarCollection() {
        return this._outageCalendarList;
    }

    public int getOutageCalendarCount() {
        return this._outageCalendarList.size();
    }

    public String getOutstandingNoticesSql() {
        return this._outstandingNoticesSql;
    }

    public String getPagesSent() {
        return this._pagesSent;
    }

    public Queue getQueue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._queueList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Queue)this._queueList.get(index);
    }

    public Queue[] getQueue() {
        int size = this._queueList.size();
        Queue[] mArray = new Queue[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Queue)this._queueList.get(index);
        }
        return mArray;
    }

    public ArrayList getQueueCollection() {
        return this._queueList;
    }

    public int getQueueCount() {
        return this._queueList.size();
    }

    public String getStatus() {
        return this._status;
    }

    public boolean hasMatchAll() {
        return this._has_matchAll;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeAutoAcknowledge(AutoAcknowledge vAutoAcknowledge) {
        boolean removed = this._autoAcknowledgeList.remove(vAutoAcknowledge);
        return removed;
    }

    public boolean removeOutageCalendar(String vOutageCalendar) {
        boolean removed = this._outageCalendarList.remove(vOutageCalendar);
        return removed;
    }

    public boolean removeQueue(Queue vQueue) {
        boolean removed = this._queueList.remove(vQueue);
        return removed;
    }

    public void setAcknowledgeIdSql(String acknowledgeIdSql) {
        this._acknowledgeIdSql = acknowledgeIdSql;
    }

    public void setAcknowledgeUpdateSql(String acknowledgeUpdateSql) {
        this._acknowledgeUpdateSql = acknowledgeUpdateSql;
    }

    public void setAutoAcknowledge(int index, AutoAcknowledge vAutoAcknowledge) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._autoAcknowledgeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._autoAcknowledgeList.set(index, vAutoAcknowledge);
    }

    public void setAutoAcknowledge(AutoAcknowledge[] autoAcknowledgeArray) {
        this._autoAcknowledgeList.clear();
        for (int i = 0; i < autoAcknowledgeArray.length; ++i) {
            this._autoAcknowledgeList.add(autoAcknowledgeArray[i]);
        }
    }

    public void setAutoAcknowledge(ArrayList autoAcknowledgeCollection) {
        this._autoAcknowledgeList.clear();
        for (int i = 0; i < autoAcknowledgeCollection.size(); ++i) {
            this._autoAcknowledgeList.add((AutoAcknowledge)autoAcknowledgeCollection.get(i));
        }
    }

    public void setAutoAcknowledgeCollection(ArrayList autoAcknowledgeCollection) {
        this._autoAcknowledgeList = autoAcknowledgeCollection;
    }

    public void setMatchAll(boolean matchAll) {
        this._matchAll = matchAll;
        this._has_matchAll = true;
    }

    public void setNextGroupId(String nextGroupId) {
        this._nextGroupId = nextGroupId;
    }

    public void setNextNotifId(String nextNotifId) {
        this._nextNotifId = nextNotifId;
    }

    public void setNextUserNotifId(String nextUserNotifId) {
        this._nextUserNotifId = nextUserNotifId;
    }

    public void setOutageCalendar(int index, String vOutageCalendar) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._outageCalendarList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._outageCalendarList.set(index, vOutageCalendar);
    }

    public void setOutageCalendar(String[] outageCalendarArray) {
        this._outageCalendarList.clear();
        for (int i = 0; i < outageCalendarArray.length; ++i) {
            this._outageCalendarList.add(outageCalendarArray[i]);
        }
    }

    public void setOutageCalendar(ArrayList outageCalendarCollection) {
        this._outageCalendarList.clear();
        for (int i = 0; i < outageCalendarCollection.size(); ++i) {
            this._outageCalendarList.add((String)outageCalendarCollection.get(i));
        }
    }

    public void setOutageCalendarCollection(ArrayList outageCalendarCollection) {
        this._outageCalendarList = outageCalendarCollection;
    }

    public void setOutstandingNoticesSql(String outstandingNoticesSql) {
        this._outstandingNoticesSql = outstandingNoticesSql;
    }

    public void setPagesSent(String pagesSent) {
        this._pagesSent = pagesSent;
    }

    public void setQueue(int index, Queue vQueue) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._queueList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._queueList.set(index, vQueue);
    }

    public void setQueue(Queue[] queueArray) {
        this._queueList.clear();
        for (int i = 0; i < queueArray.length; ++i) {
            this._queueList.add(queueArray[i]);
        }
    }

    public void setQueue(ArrayList queueCollection) {
        this._queueList.clear();
        for (int i = 0; i < queueCollection.size(); ++i) {
            this._queueList.add((Queue)queueCollection.get(i));
        }
    }

    public void setQueueCollection(ArrayList queueCollection) {
        this._queueList = queueCollection;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (NotifdConfiguration)Unmarshaller.unmarshal(NotifdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

