/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class AutoAcknowledge
implements Serializable {
    private String _resolutionPrefix = "RESOLVED: ";
    private String _uei;
    private String _acknowledge;
    private boolean _notify = true;
    private boolean _has_notify;
    private ArrayList _matchList;

    public AutoAcknowledge() {
        this.setResolutionPrefix("RESOLVED: ");
        this._matchList = new ArrayList();
    }

    public void addMatch(String vMatch) throws IndexOutOfBoundsException {
        this._matchList.add(vMatch);
    }

    public void addMatch(int index, String vMatch) throws IndexOutOfBoundsException {
        this._matchList.add(index, vMatch);
    }

    public void clearMatch() {
        this._matchList.clear();
    }

    public void deleteNotify() {
        this._has_notify = false;
    }

    public Enumeration enumerateMatch() {
        return new IteratorEnumeration(this._matchList.iterator());
    }

    public String getAcknowledge() {
        return this._acknowledge;
    }

    public String getMatch(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._matchList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._matchList.get(index);
    }

    public String[] getMatch() {
        int size = this._matchList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._matchList.get(index);
        }
        return mArray;
    }

    public ArrayList getMatchCollection() {
        return this._matchList;
    }

    public int getMatchCount() {
        return this._matchList.size();
    }

    public boolean getNotify() {
        return this._notify;
    }

    public String getResolutionPrefix() {
        return this._resolutionPrefix;
    }

    public String getUei() {
        return this._uei;
    }

    public boolean hasNotify() {
        return this._has_notify;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeMatch(String vMatch) {
        boolean removed = this._matchList.remove(vMatch);
        return removed;
    }

    public void setAcknowledge(String acknowledge) {
        this._acknowledge = acknowledge;
    }

    public void setMatch(int index, String vMatch) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._matchList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._matchList.set(index, vMatch);
    }

    public void setMatch(String[] matchArray) {
        this._matchList.clear();
        for (int i = 0; i < matchArray.length; ++i) {
            this._matchList.add(matchArray[i]);
        }
    }

    public void setMatch(ArrayList matchCollection) {
        this._matchList.clear();
        for (int i = 0; i < matchCollection.size(); ++i) {
            this._matchList.add((String)matchCollection.get(i));
        }
    }

    public void setMatchCollection(ArrayList matchCollection) {
        this._matchList = matchCollection;
    }

    public void setNotify(boolean notify) {
        this._notify = notify;
        this._has_notify = true;
    }

    public void setResolutionPrefix(String resolutionPrefix) {
        this._resolutionPrefix = resolutionPrefix;
    }

    public void setUei(String uei) {
        this._uei = uei;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (AutoAcknowledge)Unmarshaller.unmarshal(AutoAcknowledge.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

