/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.destinationPaths;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Target
implements Serializable {
    private String _interval = "0s";
    private String _name;
    private String _autoNotify;
    private ArrayList _commandList;

    public Target() {
        this.setInterval("0s");
        this._commandList = new ArrayList();
    }

    public void addCommand(String vCommand) throws IndexOutOfBoundsException {
        this._commandList.add(vCommand);
    }

    public void addCommand(int index, String vCommand) throws IndexOutOfBoundsException {
        this._commandList.add(index, vCommand);
    }

    public void clearCommand() {
        this._commandList.clear();
    }

    public Enumeration enumerateCommand() {
        return new IteratorEnumeration(this._commandList.iterator());
    }

    public String getAutoNotify() {
        return this._autoNotify;
    }

    public String getCommand(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._commandList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (String)this._commandList.get(index);
    }

    public String[] getCommand() {
        int size = this._commandList.size();
        String[] mArray = new String[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (String)this._commandList.get(index);
        }
        return mArray;
    }

    public ArrayList getCommandCollection() {
        return this._commandList;
    }

    public int getCommandCount() {
        return this._commandList.size();
    }

    public String getInterval() {
        return this._interval;
    }

    public String getName() {
        return this._name;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeCommand(String vCommand) {
        boolean removed = this._commandList.remove(vCommand);
        return removed;
    }

    public void setAutoNotify(String autoNotify) {
        this._autoNotify = autoNotify;
    }

    public void setCommand(int index, String vCommand) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._commandList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._commandList.set(index, vCommand);
    }

    public void setCommand(String[] commandArray) {
        this._commandList.clear();
        for (int i = 0; i < commandArray.length; ++i) {
            this._commandList.add(commandArray[i]);
        }
    }

    public void setCommand(ArrayList commandCollection) {
        this._commandList.clear();
        for (int i = 0; i < commandCollection.size(); ++i) {
            this._commandList.add((String)commandCollection.get(i));
        }
    }

    public void setCommandCollection(ArrayList commandCollection) {
        this._commandList = commandCollection;
    }

    public void setInterval(String interval) {
        this._interval = interval;
    }

    public void setName(String name) {
        this._name = name;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Target)Unmarshaller.unmarshal(Target.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

