/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.destinationPaths;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.common.Header;
import org.opennms.netmgt.config.destinationPaths.Path;
import org.xml.sax.ContentHandler;

public class DestinationPaths
implements Serializable {
    private Header _header;
    private ArrayList _pathList = new ArrayList();

    public void addPath(Path vPath) throws IndexOutOfBoundsException {
        this._pathList.add(vPath);
    }

    public void addPath(int index, Path vPath) throws IndexOutOfBoundsException {
        this._pathList.add(index, vPath);
    }

    public void clearPath() {
        this._pathList.clear();
    }

    public Enumeration enumeratePath() {
        return new IteratorEnumeration(this._pathList.iterator());
    }

    public Header getHeader() {
        return this._header;
    }

    public Path getPath(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._pathList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Path)this._pathList.get(index);
    }

    public Path[] getPath() {
        int size = this._pathList.size();
        Path[] mArray = new Path[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Path)this._pathList.get(index);
        }
        return mArray;
    }

    public ArrayList getPathCollection() {
        return this._pathList;
    }

    public int getPathCount() {
        return this._pathList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removePath(Path vPath) {
        boolean removed = this._pathList.remove(vPath);
        return removed;
    }

    public void setHeader(Header header) {
        this._header = header;
    }

    public void setPath(int index, Path vPath) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._pathList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._pathList.set(index, vPath);
    }

    public void setPath(Path[] pathArray) {
        this._pathList.clear();
        for (int i = 0; i < pathArray.length; ++i) {
            this._pathList.add(pathArray[i]);
        }
    }

    public void setPath(ArrayList pathCollection) {
        this._pathList.clear();
        for (int i = 0; i < pathCollection.size(); ++i) {
            this._pathList.add((Path)pathCollection.get(i));
        }
    }

    public void setPathCollection(ArrayList pathCollection) {
        this._pathList = pathCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (DestinationPaths)Unmarshaller.unmarshal(DestinationPaths.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

