/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.datacollection;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.datacollection.Groups;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.Rrd;
import org.opennms.netmgt.config.datacollection.Systems;
import org.xml.sax.ContentHandler;

public class SnmpCollection
implements Serializable {
    private String _name;
    private int _maxVarsPerPdu;
    private boolean _has_maxVarsPerPdu;
    private String _snmpStorageFlag;
    private Rrd _rrd;
    private ArrayList _resourceTypeList = new ArrayList();
    private Groups _groups;
    private Systems _systems;

    public void addResourceType(ResourceType vResourceType) throws IndexOutOfBoundsException {
        this._resourceTypeList.add(vResourceType);
    }

    public void addResourceType(int index, ResourceType vResourceType) throws IndexOutOfBoundsException {
        this._resourceTypeList.add(index, vResourceType);
    }

    public void clearResourceType() {
        this._resourceTypeList.clear();
    }

    public void deleteMaxVarsPerPdu() {
        this._has_maxVarsPerPdu = false;
    }

    public Enumeration enumerateResourceType() {
        return new IteratorEnumeration(this._resourceTypeList.iterator());
    }

    public Groups getGroups() {
        return this._groups;
    }

    public int getMaxVarsPerPdu() {
        return this._maxVarsPerPdu;
    }

    public String getName() {
        return this._name;
    }

    public ResourceType getResourceType(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._resourceTypeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (ResourceType)this._resourceTypeList.get(index);
    }

    public ResourceType[] getResourceType() {
        int size = this._resourceTypeList.size();
        ResourceType[] mArray = new ResourceType[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (ResourceType)this._resourceTypeList.get(index);
        }
        return mArray;
    }

    public ArrayList getResourceTypeCollection() {
        return this._resourceTypeList;
    }

    public int getResourceTypeCount() {
        return this._resourceTypeList.size();
    }

    public Rrd getRrd() {
        return this._rrd;
    }

    public String getSnmpStorageFlag() {
        return this._snmpStorageFlag;
    }

    public Systems getSystems() {
        return this._systems;
    }

    public boolean hasMaxVarsPerPdu() {
        return this._has_maxVarsPerPdu;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeResourceType(ResourceType vResourceType) {
        boolean removed = this._resourceTypeList.remove(vResourceType);
        return removed;
    }

    public void setGroups(Groups groups) {
        this._groups = groups;
    }

    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this._maxVarsPerPdu = maxVarsPerPdu;
        this._has_maxVarsPerPdu = true;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setResourceType(int index, ResourceType vResourceType) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._resourceTypeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._resourceTypeList.set(index, vResourceType);
    }

    public void setResourceType(ResourceType[] resourceTypeArray) {
        this._resourceTypeList.clear();
        for (int i = 0; i < resourceTypeArray.length; ++i) {
            this._resourceTypeList.add(resourceTypeArray[i]);
        }
    }

    public void setResourceType(ArrayList resourceTypeCollection) {
        this._resourceTypeList.clear();
        for (int i = 0; i < resourceTypeCollection.size(); ++i) {
            this._resourceTypeList.add((ResourceType)resourceTypeCollection.get(i));
        }
    }

    public void setResourceTypeCollection(ArrayList resourceTypeCollection) {
        this._resourceTypeList = resourceTypeCollection;
    }

    public void setRrd(Rrd rrd) {
        this._rrd = rrd;
    }

    public void setSnmpStorageFlag(String snmpStorageFlag) {
        this._snmpStorageFlag = snmpStorageFlag;
    }

    public void setSystems(Systems systems) {
        this._systems = systems;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (SnmpCollection)Unmarshaller.unmarshal(SnmpCollection.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

