/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.search.SimpleUserSearch;
import org.xmlpull.v1.XmlPullParser;

public class UserSearch
extends IQ {
    public String getChildElementXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<query xmlns=\"jabber:iq:search\">");
        buf.append(this.getExtensionsXML());
        buf.append("</query>");
        return buf.toString();
    }

    public Form getSearchForm(XMPPConnection con, String searchService) throws XMPPException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.GET);
        search.setTo(searchService);
        PacketCollector collector = con.createPacketCollector((PacketFilter)new PacketIDFilter(search.getPacketID()));
        con.sendPacket((Packet)search);
        IQ response = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        return Form.getFormFrom((Packet)response);
    }

    public ReportedData sendSearchForm(XMPPConnection con, Form searchForm, String searchService) throws XMPPException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.SET);
        search.setTo(searchService);
        search.addExtension(searchForm.getDataFormToSend());
        PacketCollector collector = con.createPacketCollector((PacketFilter)new PacketIDFilter(search.getPacketID()));
        con.sendPacket((Packet)search);
        IQ response = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            return this.sendSimpleSearchForm(con, searchForm, searchService);
        }
        return ReportedData.getReportedDataFrom((Packet)response);
    }

    public ReportedData sendSimpleSearchForm(XMPPConnection con, Form searchForm, String searchService) throws XMPPException {
        SimpleUserSearch search = new SimpleUserSearch();
        search.setForm(searchForm);
        search.setType(IQ.Type.SET);
        search.setTo(searchService);
        PacketCollector collector = con.createPacketCollector((PacketFilter)new PacketIDFilter(search.getPacketID()));
        con.sendPacket((Packet)search);
        IQ response = (IQ)collector.nextResult((long)SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        if (response instanceof SimpleUserSearch) {
            return ((SimpleUserSearch)response).getReportedData();
        }
        return null;
    }

    private static void buildDataForm(SimpleUserSearch search, String instructions, XmlPullParser parser) throws Exception {
        DataForm dataForm = new DataForm("form");
        boolean done = false;
        dataForm.setTitle("User Search");
        dataForm.addInstruction(instructions);
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2 && !parser.getNamespace().equals("jabber:x:data")) {
                String name = parser.getName();
                FormField field = new FormField(name);
                if (name.equals("first")) {
                    field.setLabel("First Name");
                } else if (name.equals("last")) {
                    field.setLabel("Last Name");
                } else if (name.equals("email")) {
                    field.setLabel("Email Address");
                } else if (name.equals("nick")) {
                    field.setLabel("Nickname");
                }
                field.setType("text-single");
                dataForm.addField(field);
                continue;
            }
            if (eventType == 3) {
                if (!parser.getName().equals("query")) continue;
                done = true;
                continue;
            }
            if (eventType != 2 || !parser.getNamespace().equals("jabber:x:data")) continue;
            search.addExtension(PacketParserUtils.parsePacketExtension((String)parser.getName(), (String)parser.getNamespace(), (XmlPullParser)parser));
            done = true;
        }
        if (search.getExtension("x", "jabber:x:data") == null) {
            search.addExtension(dataForm);
        }
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            UserSearch search = null;
            SimpleUserSearch simpleUserSearch = new SimpleUserSearch();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && parser.getName().equals("instructions")) {
                    UserSearch.buildDataForm(simpleUserSearch, parser.nextText(), parser);
                    return simpleUserSearch;
                }
                if (eventType == 2 && parser.getName().equals("item")) {
                    simpleUserSearch.parseItems(parser);
                    return simpleUserSearch;
                }
                if (eventType == 2 && parser.getNamespace().equals("jabber:x:data")) {
                    search = new UserSearch();
                    search.addExtension(PacketParserUtils.parsePacketExtension((String)parser.getName(), (String)parser.getNamespace(), (XmlPullParser)parser));
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("query")) continue;
                done = true;
            }
            if (search != null) {
                return search;
            }
            return simpleUserSearch;
        }
    }
}

