/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.rrdtool;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.StreamUtils;
import org.opennms.core.utils.StringUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.netmgt.rrd.rrdtool.Interface;

public class JniRrdStrategy
implements RrdStrategy {
    boolean initialized = false;
    boolean graphicsInitialized = false;

    public void closeFile(Object rrd) throws Exception {
        this.checkState("closeFile");
        this.log().debug((Object)("Executing: rrdtool " + rrd.toString()));
        String[] results = Interface.launch(rrd.toString());
        if (results[0] != null) {
            throw new Exception(results[0]);
        }
    }

    private void checkState(String methodName) {
        if (!this.initialized) {
            throw new IllegalStateException("the " + methodName + " method cannot be called before initialize");
        }
    }

    public Object createDefinition(String creator, String directory, String rrdName, int step, List dataSources, List rraList) throws Exception {
        this.checkState("createDefinition");
        File f = new File(directory);
        f.mkdirs();
        String fileName = directory + File.separator + rrdName + RrdUtils.getExtension();
        if (new File(fileName).exists()) {
            return null;
        }
        StringBuffer createCmd = new StringBuffer("create");
        createCmd.append(' ' + fileName);
        createCmd.append(" --start=" + (System.currentTimeMillis() / 1000L - 10L));
        createCmd.append(" --step=" + step);
        for (RrdDataSource dataSource : dataSources) {
            createCmd.append(" DS:");
            createCmd.append(dataSource.getName()).append(':');
            createCmd.append(dataSource.getType()).append(":");
            createCmd.append(dataSource.getHeartBeat()).append(':');
            createCmd.append(dataSource.getMin()).append(':');
            createCmd.append(dataSource.getMax());
        }
        for (String rra : rraList) {
            createCmd.append(' ');
            createCmd.append(rra);
        }
        return createCmd.toString();
    }

    public void createFile(Object rrdDef) throws Exception {
        this.checkState("createFile");
        if (rrdDef == null) {
            return;
        }
        this.log().debug((Object)("Executing: rrdtool " + rrdDef.toString()));
        Interface.launch((String)rrdDef);
    }

    public Object openFile(String fileName) throws Exception {
        this.checkState("openFile");
        return new StringBuffer("update " + fileName);
    }

    public void updateFile(Object rrd, String owner, String data) throws Exception {
        this.checkState("updateFile");
        StringBuffer cmd = (StringBuffer)rrd;
        cmd.append(' ');
        cmd.append(data);
    }

    public void initialize() throws Exception {
        Interface.init();
        this.initialized = true;
    }

    public void graphicsInitialize() throws Exception {
    }

    public Double fetchLastValue(String rrdFile, int interval) throws NumberFormatException, RrdException {
        String[] fetchStrings;
        this.checkState("fetchLastValue");
        Category log = ThreadCategory.getInstance(this.getClass());
        String fetchCmd = "fetch " + rrdFile + " AVERAGE -s now-" + interval / 1000 + " -e now-" + interval / 1000;
        if (log.isDebugEnabled()) {
            log.debug((Object)("fetch: Issuing RRD command: " + fetchCmd));
        }
        if ((fetchStrings = Interface.launch(fetchCmd)) == null) {
            log.error((Object)"fetch: Unexpected error issuing RRD 'fetch' command, no error text available.");
            return null;
        }
        if (fetchStrings[0] != null) {
            log.error((Object)("fetch: RRD database 'fetch' failed, reason: " + fetchStrings[0]));
            return null;
        }
        if (fetchStrings[1] == null || fetchStrings[2] == null) {
            log.error((Object)"fetch: RRD database 'fetch' failed, no data retrieved.");
            return null;
        }
        String dsName = fetchStrings[1].trim();
        Double dsValue = null;
        if (fetchStrings[2].trim().equalsIgnoreCase("nan")) {
            dsValue = new Double(Double.NaN);
        } else {
            try {
                dsValue = new Double(fetchStrings[2].trim());
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)("fetch: Unable to convert fetched value (" + fetchStrings[2].trim() + ") to Double for data source " + dsName));
                throw nfe;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("fetch: fetch successful: " + dsName + "= " + dsValue));
        }
        return dsValue;
    }

    public Double fetchLastValueInRange(String rrdFile, int interval, int range) throws NumberFormatException, RrdException {
        String fetchCmd;
        String[] fetchStrings;
        this.checkState("fetchLastValue");
        Category log = ThreadCategory.getInstance(this.getClass());
        long now = System.currentTimeMillis();
        long latestUpdateTime = (now - now % (long)interval) / 1000L;
        long earliestUpdateTime = (now - now % (long)interval - (long)range) / 1000L;
        if (log.isDebugEnabled()) {
            log.debug((Object)("fetchInRange: fetching data from " + earliestUpdateTime + " to " + latestUpdateTime));
        }
        if ((fetchStrings = Interface.launch(fetchCmd = "fetch " + rrdFile + " AVERAGE -s " + earliestUpdateTime + " -e " + latestUpdateTime)) == null) {
            log.error((Object)"fetchInRange: Unexpected error issuing RRD 'fetch' command, no error text available.");
            return null;
        }
        if (fetchStrings[0] != null) {
            log.error((Object)("fetchInRange: RRD database 'fetch' failed, reason: " + fetchStrings[0]));
            return null;
        }
        if (fetchStrings[1] == null || fetchStrings[2] == null) {
            log.error((Object)"fetchInRange: RRD database 'fetch' failed, no data retrieved.");
            return null;
        }
        int numFetched = fetchStrings.length;
        if (log.isDebugEnabled()) {
            log.debug((Object)("fetchInRange: got " + numFetched + " strings from RRD"));
        }
        String dsName = fetchStrings[1].trim();
        for (int i = fetchStrings.length - 2; i > 1; --i) {
            if (!fetchStrings[i].trim().equalsIgnoreCase("nan")) {
                try {
                    Double dsValue = new Double(fetchStrings[i].trim());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("fetchInRange: fetch successful: " + dsName + "= " + dsValue));
                    }
                    return dsValue;
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)("fetchInRange: Unable to convert fetched value (" + fetchStrings[2].trim() + ") to Double for data source " + dsName));
                    throw nfe;
                }
            }
            log.debug((Object)"fetchInRange: Got a NaN value - continuing back in time");
        }
        return null;
    }

    public InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        String[] commandArray = StringUtils.createCommandArray((String)command, (char)'@');
        Process process = Runtime.getRuntime().exec(commandArray, null, workDir);
        ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
        BufferedInputStream in = new BufferedInputStream(process.getInputStream());
        StreamUtils.streamToStream((InputStream)in, (OutputStream)tempOut);
        in.close();
        tempOut.close();
        BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String line = err.readLine();
        StringBuffer buffer = new StringBuffer();
        while (line != null) {
            buffer.append(line);
            line = err.readLine();
        }
        if (buffer.length() > 0) {
            throw new RrdException(buffer.toString());
        }
        byte[] byteArray = tempOut.toByteArray();
        ByteArrayInputStream tempIn = new ByteArrayInputStream(byteArray);
        return tempIn;
    }

    public String getStats() {
        return "";
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public int getGraphRightOffset() {
        return -15;
    }

    public int getGraphTopOffsetWithText() {
        return -75;
    }

    public String getDefaultFileExtension() {
        return ".rrd";
    }
}

