/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.rrdtool;

import org.opennms.core.utils.ThreadCategory;

public final class Interface {
    private static Interface m_singleton = null;
    private static boolean m_loaded = false;

    public static synchronized native String[] launch(String var0);

    public static synchronized void init() throws SecurityException, UnsatisfiedLinkError {
        if (m_loaded) {
            return;
        }
        ThreadCategory.getInstance(Interface.class).debug((Object)"init: loading jrrd library...");
        m_singleton = new Interface();
        m_loaded = true;
    }

    public static synchronized void reload() throws SecurityException, UnsatisfiedLinkError {
        m_singleton = null;
        m_loaded = false;
        Interface.init();
    }

    private Interface() throws SecurityException, UnsatisfiedLinkError {
        String property = System.getProperty("opennms.library.jrrd");
        if (property != null) {
            System.load(property);
        } else {
            System.loadLibrary("jrrd");
        }
    }

    public static synchronized Interface getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The RRD JNI interface has not been initialized");
        }
        return m_singleton;
    }

    public static void main(String[] argv) {
        try {
            Interface.reload();
            String filename = argv[0];
            System.out.println("filename=" + filename);
            String cmd = "create \"" + filename + "\" --start N" + " --step 900 DS:test:COUNTER:900:0:100 RRA:MIN:0.5:1:1000";
            System.out.println("issuing RRD cmd: " + cmd);
            Interface.launch(cmd);
            System.out.println("command completed.");
        }
        catch (Throwable t) {
            System.out.println("unexpected error, reason: " + t.getMessage());
        }
    }
}

