/*
 * Decompiled with CFR 0.152.
 */
package org.openoss.ossj.xml.junittests;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openoss.ossj.xml.gen.common.ApplicationContextXmlBean;
import org.openoss.ossj.xml.gen.common.ArrayOfSystemPropertiesXmlBean;
import org.openoss.ossj.xml.gen.common.SystemPropertyXmlBean;
import org.openoss.ossj.xml.gen.qos.fm.monitor.AlarmKeyXmlBean;
import org.openoss.ossj.xml.gen.qos.fm.monitor.NotifyNewAlarmEventDocumentXmlBean;
import org.openoss.ossj.xml.gen.qos.fm.monitor.NotifyNewAlarmEventTypeXmlBean;
import org.openoss.ossj.xml.gen.qos.fm.monitor.PerceivedAlarmSeverityXmlBean;

public class XmlValidatorJunitTests
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(XmlValidatorJunitTests.class);
    }

    public XmlValidatorJunitTests(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEventDocument() throws Exception {
        NotifyNewAlarmEventDocumentXmlBean xmlnnaeDocRX = NotifyNewAlarmEventDocumentXmlBean.Factory.newInstance();
        NotifyNewAlarmEventTypeXmlBean nnaet = xmlnnaeDocRX.addNewNotifyNewAlarmEvent().addNewEvent();
        nnaet.setApplicationDN("my application DN");
        nnaet.setAlarmType("CommunicationsAlarm");
        nnaet.setSpecificProblem("specific problem");
        nnaet.setAdditionalText("additional text");
        nnaet.setBasePerceivedAlarmSeverity(PerceivedAlarmSeverityXmlBean.CRITICAL.toString());
        nnaet.setBaseProbableAlarmCause("-1");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        nnaet.setEventTime(c);
        nnaet.setManagedObjectClass("this managed object");
        nnaet.setManagedObjectInstance("this instance");
        nnaet.setNotificationId("notification id 1");
        nnaet.setProposedRepairActions("proposed repair actions");
        ApplicationContextXmlBean ac = ApplicationContextXmlBean.Factory.newInstance();
        ac.setFactoryClass("factory class");
        ac.setURL("com.oss.uos");
        try {
            ArrayOfSystemPropertiesXmlBean a = ac.addNewSystemProperties();
            SystemPropertyXmlBean sp = a.addNewProperty();
            sp.setName("property1");
            sp.setValue("propertyvalue1");
            sp = a.addNewProperty();
            sp.setName("property2");
            sp.setValue("propertyvalue2");
        }
        catch (Exception ex) {
            System.out.println("exception creating array of system properties: " + ex);
        }
        AlarmKeyXmlBean ak = AlarmKeyXmlBean.Factory.newInstance();
        ak.setAlarmPrimaryKey("001");
        ak.setApplicationDN("this DN");
        ak.setApplicationContext(ac);
        ak.setType("");
        nnaet.setAlarmKey(ak);
        String received = xmlnnaeDocRX.toString();
        System.out.println("XML Generated:\n" + received);
        XmlObject xobj = XmlObject.Factory.parse((String)received);
        if (xobj instanceof NotifyNewAlarmEventDocumentXmlBean) {
            System.out.println("Received a NotifyNewAlarmEventDocument document");
            xmlnnaeDocRX = (NotifyNewAlarmEventDocumentXmlBean)xobj;
            XmlOptions validateOptions = new XmlOptions();
            ArrayList errorList = new ArrayList();
            validateOptions.setErrorListener(errorList);
            boolean isValid = xmlnnaeDocRX.validate(validateOptions);
            if (!isValid) {
                System.out.println("Not a valid NotifyNewAlarmEventDocument document ?");
                for (int i = 0; i < errorList.size(); ++i) {
                    XmlError error = (XmlError)errorList.get(i);
                    System.out.println("Message: " + error.getMessage());
                    System.out.println("Location of invalid XML: " + error.getCursorLocation().xmlText());
                }
            } else {
                System.out.println("is a valid NotifyNewAlarmEventDocument document");
            }
        } else {
            System.out.println("Not a NotifyNewAlarmEventDocument document");
        }
    }
}

