/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.util.Vector;

public class ThreadPool {
    protected Vector taskManagers;
    protected String name = "ThreadPool";
    protected volatile boolean stop = false;
    protected boolean respawnThreads = false;

    protected ThreadPool() {
    }

    protected String getTaskManagerName(String prefix, int index) {
        return prefix + "." + index;
    }

    protected void setup(String name, int size) {
        this.name = name;
        this.taskManagers = new Vector(size);
        for (int i = 0; i < size; ++i) {
            TaskManager tm = new TaskManager(this.getTaskManagerName(name, i));
            this.taskManagers.add(tm);
            tm.start();
        }
    }

    public static ThreadPool create(String name, int size) {
        ThreadPool pool = new ThreadPool();
        pool.setup(name, size);
        return pool;
    }

    public synchronized void execute(Runnable task) {
        while (true) {
            for (int i = 0; i < this.taskManagers.size(); ++i) {
                TaskManager tm = (TaskManager)this.taskManagers.get(i);
                if (this.respawnThreads && !tm.isAlive()) {
                    tm = new TaskManager(this.getTaskManagerName(this.name, i));
                }
                if (!tm.isIdle()) continue;
                tm.execute(task);
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public synchronized boolean tryToExecute(Runnable task) {
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            TaskManager tm = (TaskManager)this.taskManagers.get(i);
            if (this.respawnThreads && !tm.isAlive()) {
                tm = new TaskManager(this.getTaskManagerName(this.name, i));
            }
            if (!tm.isIdle()) continue;
            tm.execute(task);
            return true;
        }
        return false;
    }

    public boolean isRespawnThreads() {
        return this.respawnThreads;
    }

    public void setRespawnThreads(boolean respawnThreads) {
        this.respawnThreads = respawnThreads;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.stop = true;
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            TaskManager tm = (TaskManager)this.taskManagers.get(i);
            tm.terminate();
            TaskManager taskManager = tm;
            synchronized (taskManager) {
                tm.notify();
            }
            try {
                tm.join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized void cancel() {
        this.stop = true;
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            TaskManager tm = (TaskManager)this.taskManagers.get(i);
            tm.terminate();
            tm.interrupt();
        }
    }

    public synchronized void interrupt() {
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            TaskManager tm = (TaskManager)this.taskManagers.get(i);
            tm.interrupt();
        }
    }

    public synchronized boolean isIdle() {
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            TaskManager tm = (TaskManager)this.taskManagers.get(i);
            if (tm.isIdle()) continue;
            return false;
        }
        return true;
    }

    class TaskManager
    extends Thread {
        private Runnable task = null;
        private volatile boolean run = true;

        public TaskManager(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            while (!ThreadPool.this.stop && this.run) {
                if (this.task != null) {
                    this.task.run();
                    ThreadPool threadPool = ThreadPool.this;
                    synchronized (threadPool) {
                        this.task = null;
                        ThreadPool.this.notify();
                        continue;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.run = ThreadPool.this.respawnThreads;
                    break;
                }
            }
        }

        public boolean isIdle() {
            return this.task == null && this.run;
        }

        public boolean isStopped() {
            return ThreadPool.this.stop;
        }

        public void terminate() {
            ThreadPool.this.stop = true;
        }

        public synchronized void execute(Runnable task) {
            if (this.task != null) {
                throw new IllegalStateException("TaskManager is not idle");
            }
            this.task = task;
            this.notify();
        }
    }
}

