/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.UdpTransportMapping;

public class DefaultUdpTransportMapping
extends UdpTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$transport$DefaultUdpTransportMapping == null ? (class$org$snmp4j$transport$DefaultUdpTransportMapping = DefaultUdpTransportMapping.class$("org.snmp4j.transport.DefaultUdpTransportMapping")) : class$org$snmp4j$transport$DefaultUdpTransportMapping);
    protected DatagramSocket socket = null;
    protected ListenThread listener;
    private int socketTimeout = 1000;
    private int receiveBufferSize = 0;
    static /* synthetic */ Class class$org$snmp4j$transport$DefaultUdpTransportMapping;

    public DefaultUdpTransportMapping() throws IOException {
        super(new UdpAddress(InetAddress.getLocalHost(), 0));
        this.socket = new DatagramSocket(this.udpAddress.getPort());
    }

    public DefaultUdpTransportMapping(UdpAddress udpAddress) throws IOException {
        super(udpAddress);
        this.socket = new DatagramSocket(udpAddress.getPort(), udpAddress.getInetAddress());
    }

    public void sendMessage(Address targetAddress, byte[] message) throws IOException {
        InetSocketAddress targetSocketAddress = new InetSocketAddress(((UdpAddress)targetAddress).getInetAddress(), ((UdpAddress)targetAddress).getPort());
        if (logger.isDebugEnabled()) {
            logger.debug("Sending message to " + targetAddress + " with length " + message.length + ": " + new OctetString(message).toHexString());
        }
        this.socket.send(new DatagramPacket(message, message.length, targetSocketAddress));
    }

    public void close() throws IOException {
        ListenThread l = this.listener;
        if (l != null) {
            l.close();
            l.interrupt();
            if (this.socketTimeout > 0) {
                try {
                    l.join();
                }
                catch (InterruptedException ex) {
                    logger.warn(ex);
                }
            }
            this.listener = null;
        }
        if (!this.socket.isClosed()) {
            this.socket.disconnect();
            this.socket.close();
        }
    }

    public void listen() throws IOException {
        if (this.listener != null) {
            throw new SocketException("Port already listening");
        }
        this.listener = new ListenThread();
        this.listener.setDaemon(true);
        this.listener.start();
    }

    public void setPriority(int newPriority) {
        if (this.listener != null) {
            this.listener.setPriority(newPriority);
        }
    }

    public int getPriority() {
        if (this.listener != null) {
            return this.listener.getPriority();
        }
        return 5;
    }

    public void setThreadName(String name) {
        if (this.listener != null) {
            this.listener.setName(name);
        }
    }

    public String getThreadName() {
        if (this.listener != null) {
            return this.listener.getName();
        }
        return null;
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize <= 0) {
            throw new IllegalArgumentException("Receive buffer size must be > 0");
        }
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isListening() {
        return this.listener != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ListenThread
    extends Thread {
        private byte[] buf;
        private volatile boolean stop = false;

        public ListenThread() throws SocketException {
            this.buf = new byte[DefaultUdpTransportMapping.this.getMaxInboundMessageSize()];
            this.setName("DefaultUDPTransportMapping_" + DefaultUdpTransportMapping.this.getAddress());
        }

        public void run() {
            try {
                DefaultUdpTransportMapping.this.socket.setSoTimeout(DefaultUdpTransportMapping.this.getSocketTimeout());
                if (DefaultUdpTransportMapping.this.receiveBufferSize > 0) {
                    DefaultUdpTransportMapping.this.socket.setReceiveBufferSize(Math.max(DefaultUdpTransportMapping.this.receiveBufferSize, DefaultUdpTransportMapping.this.maxInboundMessageSize));
                }
                if (logger.isInfoEnabled()) {
                    logger.info("UDP receive buffer size for socket " + DefaultUdpTransportMapping.this.getAddress() + " is set to: " + DefaultUdpTransportMapping.this.socket.getReceiveBufferSize());
                }
            }
            catch (SocketException ex) {
                logger.error(ex);
                DefaultUdpTransportMapping.this.setSocketTimeout(0);
            }
            while (!this.stop) {
                DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length, DefaultUdpTransportMapping.this.udpAddress.getInetAddress(), DefaultUdpTransportMapping.this.udpAddress.getPort());
                try {
                    ByteBuffer bis;
                    DefaultUdpTransportMapping.this.socket.receive(packet);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received message from " + packet.getAddress() + "/" + packet.getPort() + " with length " + packet.getLength() + ": " + new OctetString(packet.getData(), 0, packet.getLength()).toHexString());
                    }
                    if (DefaultUdpTransportMapping.this.isAsyncMsgProcessingSupported()) {
                        byte[] bytes = new byte[packet.getLength()];
                        System.arraycopy(packet.getData(), 0, bytes, 0, bytes.length);
                        bis = ByteBuffer.wrap(bytes);
                    } else {
                        bis = ByteBuffer.wrap(packet.getData());
                    }
                    DefaultUdpTransportMapping.this.fireProcessMessage(new UdpAddress(packet.getAddress(), packet.getPort()), bis);
                }
                catch (SocketTimeoutException stex) {
                }
                catch (PortUnreachableException purex) {
                    DefaultUdpTransportMapping.this.listener = null;
                    logger.error(purex);
                    if (!logger.isDebugEnabled()) break;
                    purex.printStackTrace();
                    break;
                }
                catch (IOException iox) {
                    logger.warn(iox);
                    if (!logger.isDebugEnabled()) continue;
                    iox.printStackTrace();
                }
            }
            DefaultUdpTransportMapping.this.listener = null;
            this.stop = true;
            DefaultUdpTransportMapping.this.socket.close();
        }

        public void close() {
            this.stop = true;
        }
    }
}

