/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.transport.MessageLength;
import org.snmp4j.transport.MessageLengthDecoder;
import org.snmp4j.transport.TcpTransportMapping;
import org.snmp4j.transport.TransportStateEvent;

public class DefaultTcpTransportMapping
extends TcpTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$transport$DefaultTcpTransportMapping == null ? (class$org$snmp4j$transport$DefaultTcpTransportMapping = DefaultTcpTransportMapping.class$("org.snmp4j.transport.DefaultTcpTransportMapping")) : class$org$snmp4j$transport$DefaultTcpTransportMapping);
    private Hashtable sockets = new Hashtable();
    private ServerThread server;
    private Timer socketCleaner;
    private long connectionTimeout = 60000L;
    private boolean serverEnabled = false;
    private static final int MIN_SNMP_HEADER_LENGTH = 6;
    private MessageLengthDecoder messageLengthDecoder = new SnmpMesssageLengthDecoder();
    static /* synthetic */ Class class$org$snmp4j$transport$DefaultTcpTransportMapping;

    public DefaultTcpTransportMapping() throws UnknownHostException, IOException {
        super(new TcpAddress(InetAddress.getLocalHost(), 0));
    }

    public DefaultTcpTransportMapping(TcpAddress serverAddress) throws UnknownHostException, IOException {
        super(serverAddress);
        this.serverEnabled = true;
    }

    public void listen() throws IOException {
        if (this.server != null) {
            throw new SocketException("Port already listening");
        }
        this.server = new ServerThread();
        if (this.connectionTimeout > 0L) {
            this.socketCleaner = new Timer(true);
        }
        this.server.setDaemon(true);
        this.server.start();
    }

    public void setPriority(int newPriority) {
        if (this.server != null) {
            this.server.setPriority(newPriority);
        }
    }

    public int getPriority() {
        if (this.server != null) {
            return this.server.getPriority();
        }
        return 5;
    }

    public void setThreadName(String name) {
        if (this.server != null) {
            this.server.setName(name);
        }
    }

    public String getThreadName() {
        if (this.server != null) {
            return this.server.getName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.server != null) {
            this.server.close();
            try {
                this.server.join();
            }
            catch (InterruptedException ex) {
                logger.warn(ex);
            }
            this.server = null;
            Iterator it = this.sockets.values().iterator();
            while (it.hasNext()) {
                SocketEntry entry = (SocketEntry)it.next();
                try {
                    SocketEntry socketEntry = entry;
                    synchronized (socketEntry) {
                        entry.getSocket().close();
                    }
                    logger.debug("Socket to " + entry.getPeerAddress() + " closed");
                }
                catch (IOException iox) {
                    logger.debug(iox);
                }
            }
            if (this.socketCleaner != null) {
                this.socketCleaner.cancel();
            }
            this.socketCleaner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean close(Address remoteAddress) throws IOException {
        SocketEntry entry;
        if (logger.isDebugEnabled()) {
            logger.debug("Closing socket for peer address " + remoteAddress);
        }
        if ((entry = (SocketEntry)this.sockets.remove(remoteAddress)) != null) {
            SocketEntry socketEntry = entry;
            synchronized (socketEntry) {
                entry.getSocket().close();
            }
            logger.info("Socket to " + entry.getPeerAddress() + " closed");
            return true;
        }
        return false;
    }

    public void sendMessage(Address address, byte[] message) throws IOException {
        if (this.server == null) {
            this.listen();
        }
        this.server.sendMessage(address, message);
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public MessageLengthDecoder getMessageLengthDecoder() {
        return this.messageLengthDecoder;
    }

    public void setServerEnabled(boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
    }

    public void setMessageLengthDecoder(MessageLengthDecoder messageLengthDecoder) {
        if (messageLengthDecoder == null) {
            throw new NullPointerException();
        }
        this.messageLengthDecoder = messageLengthDecoder;
    }

    public int getMaxInboundMessageSize() {
        return super.getMaxInboundMessageSize();
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    private synchronized void timeoutSocket(SocketEntry entry) {
        if (this.connectionTimeout > 0L) {
            this.socketCleaner.schedule((TimerTask)new SocketTimeout(entry), this.connectionTimeout);
        }
    }

    public boolean isListening() {
        return this.server != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ServerThread
    extends Thread {
        private byte[] buf;
        private volatile boolean stop = false;
        private Throwable lastError = null;
        private ServerSocketChannel ssc;
        private Selector selector;
        private LinkedList pending = new LinkedList();

        public ServerThread() throws IOException {
            this.setName("DefaultTCPTransportMapping_" + DefaultTcpTransportMapping.this.getAddress());
            this.buf = new byte[DefaultTcpTransportMapping.this.getMaxInboundMessageSize()];
            this.selector = Selector.open();
            if (DefaultTcpTransportMapping.this.serverEnabled) {
                this.ssc = ServerSocketChannel.open();
                this.ssc.configureBlocking(false);
                InetSocketAddress isa = new InetSocketAddress(DefaultTcpTransportMapping.this.tcpAddress.getInetAddress(), DefaultTcpTransportMapping.this.tcpAddress.getPort());
                this.ssc.socket().bind(isa);
                this.ssc.register(this.selector, 16);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void processPending() {
            LinkedList linkedList = this.pending;
            synchronized (linkedList) {
                while (this.pending.size() > 0) {
                    SocketEntry entry = (SocketEntry)this.pending.removeFirst();
                    try {
                        if (entry.getSocket().isConnected()) {
                            entry.getSocket().getChannel().register(this.selector, 4, entry);
                            continue;
                        }
                        entry.getSocket().getChannel().register(this.selector, 8, entry);
                    }
                    catch (IOException iox) {
                        logger.error(iox);
                        try {
                            entry.getSocket().getChannel().close();
                            TransportStateEvent e = new TransportStateEvent(DefaultTcpTransportMapping.this, entry.getPeerAddress(), 4, iox);
                            DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                        }
                        catch (IOException ex) {
                            logger.error(ex);
                        }
                        this.lastError = iox;
                    }
                }
                return;
            }
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(Address address, byte[] message) throws IOException {
            Socket s = null;
            SocketEntry entry = (SocketEntry)DefaultTcpTransportMapping.this.sockets.get(address);
            if (logger.isDebugEnabled()) {
                logger.debug("Looking up connection for destination '" + address + "' returned: " + entry);
                logger.debug(DefaultTcpTransportMapping.this.sockets.toString());
            }
            if (entry != null) {
                s = entry.getSocket();
            }
            if (s == null || s.isClosed()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Socket for address '" + address + "' is closed, opening it...");
                }
                SocketChannel sc = null;
                try {
                    sc = SocketChannel.open();
                    sc.configureBlocking(false);
                    sc.connect(new InetSocketAddress(((TcpAddress)address).getInetAddress(), ((TcpAddress)address).getPort()));
                    s = sc.socket();
                    entry = new SocketEntry((TcpAddress)address, s);
                    entry.addMessage(message);
                    DefaultTcpTransportMapping.this.sockets.put(address, entry);
                    LinkedList linkedList = this.pending;
                    synchronized (linkedList) {
                        this.pending.add(entry);
                    }
                    this.selector.wakeup();
                    logger.debug("Trying to connect to " + address);
                }
                catch (IOException iox) {
                    logger.error(iox);
                    throw iox;
                }
            }
            entry.addMessage(message);
            LinkedList linkedList = this.pending;
            synchronized (linkedList) {
                this.pending.add(entry);
            }
            this.selector.wakeup();
        }

        public void run() {
            try {
                while (!this.stop) {
                    block25: {
                        try {
                            if (this.selector.select() <= 0) break block25;
                            if (this.stop) break;
                            Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                            Iterator<SelectionKey> it = readyKeys.iterator();
                            while (it.hasNext()) {
                                TransportStateEvent e;
                                SocketChannel sc;
                                SocketEntry entry;
                                SelectionKey sk = it.next();
                                it.remove();
                                SocketChannel readChannel = null;
                                TcpAddress incomingAddress = null;
                                if (sk.isAcceptable()) {
                                    ServerSocketChannel nextReady = (ServerSocketChannel)sk.channel();
                                    Socket s = nextReady.accept().socket();
                                    readChannel = s.getChannel();
                                    readChannel.configureBlocking(false);
                                    readChannel.register(this.selector, 1);
                                    incomingAddress = new TcpAddress(s.getInetAddress(), s.getPort());
                                    SocketEntry entry2 = new SocketEntry(incomingAddress, s);
                                    DefaultTcpTransportMapping.this.sockets.put(incomingAddress, entry2);
                                    DefaultTcpTransportMapping.this.timeoutSocket(entry2);
                                    TransportStateEvent e2 = new TransportStateEvent(DefaultTcpTransportMapping.this, incomingAddress, 1, null);
                                    DefaultTcpTransportMapping.this.fireConnectionStateChanged(e2);
                                } else if (sk.isReadable()) {
                                    readChannel = (SocketChannel)sk.channel();
                                    incomingAddress = new TcpAddress(readChannel.socket().getInetAddress(), readChannel.socket().getPort());
                                } else if (sk.isWritable()) {
                                    try {
                                        entry = (SocketEntry)sk.attachment();
                                        sc = (SocketChannel)sk.channel();
                                        if (entry != null) {
                                            this.writeMessage(entry, sc);
                                        }
                                    }
                                    catch (IOException iox) {
                                        if (logger.isDebugEnabled()) {
                                            iox.printStackTrace();
                                        }
                                        logger.warn(iox);
                                        e = new TransportStateEvent(DefaultTcpTransportMapping.this, incomingAddress, 2, iox);
                                        DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                                        sk.cancel();
                                    }
                                } else if (sk.isConnectable()) {
                                    try {
                                        entry = (SocketEntry)sk.attachment();
                                        sc = (SocketChannel)sk.channel();
                                        if (!sc.isConnected() && sc.finishConnect()) {
                                            sc.configureBlocking(false);
                                            logger.debug("Connected to " + entry.getPeerAddress());
                                            DefaultTcpTransportMapping.this.timeoutSocket(entry);
                                            sc.register(this.selector, 4, entry);
                                        }
                                        TransportStateEvent e3 = new TransportStateEvent(DefaultTcpTransportMapping.this, incomingAddress, 1, null);
                                        DefaultTcpTransportMapping.this.fireConnectionStateChanged(e3);
                                    }
                                    catch (IOException iox) {
                                        if (logger.isDebugEnabled()) {
                                            iox.printStackTrace();
                                        }
                                        logger.warn(iox);
                                        sk.cancel();
                                    }
                                }
                                if (readChannel == null) continue;
                                try {
                                    this.readMessage(sk, readChannel, incomingAddress);
                                }
                                catch (IOException iox) {
                                    if (logger.isDebugEnabled()) {
                                        iox.printStackTrace();
                                    }
                                    logger.warn(iox);
                                    sk.cancel();
                                    readChannel.close();
                                    e = new TransportStateEvent(DefaultTcpTransportMapping.this, incomingAddress, 2, iox);
                                    DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
                                }
                            }
                        }
                        catch (NullPointerException npex) {
                            npex.printStackTrace();
                            logger.warn("NullPointerException within select()?");
                        }
                    }
                    this.processPending();
                }
                if (this.ssc != null) {
                    this.ssc.close();
                }
            }
            catch (IOException iox) {
                logger.error(iox);
                this.lastError = iox;
            }
            this.stop = true;
            DefaultTcpTransportMapping.this.server = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readMessage(SelectionKey sk, SocketChannel readChannel, TcpAddress incomingAddress) throws IOException {
            SocketEntry entry = (SocketEntry)DefaultTcpTransportMapping.this.sockets.get(incomingAddress);
            if (entry != null) {
                entry.used();
                ByteBuffer readBuffer = entry.getReadBuffer();
                if (readBuffer != null) {
                    readChannel.read(readBuffer);
                    if (readBuffer.hasRemaining()) {
                        readChannel.register(this.selector, 1, entry);
                    } else {
                        this.dispatchMessage(incomingAddress, readBuffer, readBuffer.capacity());
                    }
                    return;
                }
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf);
            ((Buffer)byteBuffer).limit(DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength());
            long bytesRead = readChannel.read(byteBuffer);
            if (logger.isDebugEnabled()) {
                logger.debug("Reading header " + bytesRead + " bytes from " + incomingAddress);
            }
            MessageLength messageLength = new MessageLength(0, Integer.MIN_VALUE);
            if (bytesRead == (long)DefaultTcpTransportMapping.this.messageLengthDecoder.getMinHeaderLength()) {
                messageLength = DefaultTcpTransportMapping.this.messageLengthDecoder.getMessageLength(ByteBuffer.wrap(this.buf));
                if (logger.isDebugEnabled()) {
                    logger.debug("Message length is " + messageLength);
                }
                if (messageLength.getMessageLength() > DefaultTcpTransportMapping.this.getMaxInboundMessageSize() || messageLength.getMessageLength() <= 0) {
                    logger.error("Received message length " + messageLength + " is greater than inboundBufferSize " + DefaultTcpTransportMapping.this.getMaxInboundMessageSize());
                    SocketEntry socketEntry = entry;
                    synchronized (socketEntry) {
                        entry.getSocket().close();
                        logger.info("Socket to " + entry.getPeerAddress() + " closed due to an error");
                    }
                } else {
                    ((Buffer)byteBuffer).limit(messageLength.getMessageLength());
                    if ((bytesRead += (long)readChannel.read(byteBuffer)) == (long)messageLength.getMessageLength()) {
                        this.dispatchMessage(incomingAddress, byteBuffer, bytesRead);
                    } else {
                        byte[] message = new byte[byteBuffer.limit()];
                        ((Buffer)byteBuffer).flip();
                        byteBuffer.get(message, 0, byteBuffer.limit() - byteBuffer.remaining());
                        entry.setReadBuffer(ByteBuffer.wrap(message));
                    }
                    readChannel.register(this.selector, 1, entry);
                }
            } else if (bytesRead < 0L) {
                logger.debug("Socket closed remotely");
                sk.cancel();
                readChannel.close();
                TransportStateEvent e = new TransportStateEvent(DefaultTcpTransportMapping.this, incomingAddress, 2, null);
                DefaultTcpTransportMapping.this.fireConnectionStateChanged(e);
            }
        }

        private void dispatchMessage(TcpAddress incomingAddress, ByteBuffer byteBuffer, long bytesRead) {
            ByteBuffer bis;
            ((Buffer)byteBuffer).flip();
            if (logger.isDebugEnabled()) {
                logger.debug("Received message from " + incomingAddress + " with length " + bytesRead + ": " + new OctetString(byteBuffer.array(), 0, (int)bytesRead).toHexString());
            }
            if (DefaultTcpTransportMapping.this.isAsyncMsgProcessingSupported()) {
                byte[] bytes = new byte[(int)bytesRead];
                System.arraycopy(byteBuffer.array(), 0, bytes, 0, (int)bytesRead);
                bis = ByteBuffer.wrap(bytes);
            } else {
                bis = ByteBuffer.wrap(byteBuffer.array(), 0, (int)bytesRead);
            }
            DefaultTcpTransportMapping.this.fireProcessMessage(incomingAddress, bis);
        }

        private void writeMessage(SocketEntry entry, SocketChannel sc) throws IOException {
            byte[] message = entry.nextMessage();
            if (message != null) {
                ByteBuffer buffer = ByteBuffer.wrap(message);
                sc.write(buffer);
                if (logger.isDebugEnabled()) {
                    logger.debug("Send message with length " + message.length + " to " + entry.getPeerAddress() + ": " + new OctetString(message).toHexString());
                }
                sc.register(this.selector, 1);
            }
        }

        public void close() {
            this.stop = true;
            DefaultTcpTransportMapping.this.server.interrupt();
        }
    }

    class SocketTimeout
    extends TimerTask {
        private SocketEntry entry;

        public SocketTimeout(SocketEntry entry) {
            this.entry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long now = System.currentTimeMillis();
            if (DefaultTcpTransportMapping.this.socketCleaner == null || now - this.entry.getLastUse() >= DefaultTcpTransportMapping.this.connectionTimeout) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Socket has not been used for " + (now - this.entry.getLastUse()) + " micro seconds, closing it");
                }
                DefaultTcpTransportMapping.this.sockets.remove(this.entry.getPeerAddress());
                try {
                    SocketEntry socketEntry = this.entry;
                    synchronized (socketEntry) {
                        this.entry.getSocket().close();
                    }
                    logger.info("Socket to " + this.entry.getPeerAddress() + " closed due to timeout");
                }
                catch (IOException ex) {
                    logger.error(ex);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("Scheduling " + (this.entry.getLastUse() + DefaultTcpTransportMapping.this.connectionTimeout - now));
                }
                DefaultTcpTransportMapping.this.socketCleaner.schedule((TimerTask)new SocketTimeout(this.entry), this.entry.getLastUse() + DefaultTcpTransportMapping.this.connectionTimeout - now);
            }
        }
    }

    public static class SnmpMesssageLengthDecoder
    implements MessageLengthDecoder {
        public int getMinHeaderLength() {
            return 6;
        }

        public MessageLength getMessageLength(ByteBuffer buf) throws IOException {
            BER.MutableByte type = new BER.MutableByte();
            BERInputStream is = new BERInputStream(buf);
            int ml = BER.decodeHeader(is, type);
            int hl = (int)is.getPosition();
            MessageLength messageLength = new MessageLength(hl, ml);
            return messageLength;
        }
    }

    class SocketEntry {
        private Socket socket;
        private TcpAddress peerAddress;
        private long lastUse;
        private LinkedList message = new LinkedList();
        private ByteBuffer readBuffer = null;

        public SocketEntry(TcpAddress address, Socket socket) {
            this.peerAddress = address;
            this.socket = socket;
            this.lastUse = System.currentTimeMillis();
        }

        public long getLastUse() {
            return this.lastUse;
        }

        public void used() {
            this.lastUse = System.currentTimeMillis();
        }

        public Socket getSocket() {
            return this.socket;
        }

        public TcpAddress getPeerAddress() {
            return this.peerAddress;
        }

        public synchronized void addMessage(byte[] message) {
            this.message.add(message);
        }

        public byte[] nextMessage() {
            if (this.message.size() > 0) {
                return (byte[])this.message.removeFirst();
            }
            return null;
        }

        public void setReadBuffer(ByteBuffer byteBuffer) {
            this.readBuffer = byteBuffer;
        }

        public ByteBuffer getReadBuffer() {
            return this.readBuffer;
        }

        public String toString() {
            return "SocketEntry[peerAddress=" + this.peerAddress + ",socket=" + this.socket + ",lastUse=" + new Date(this.lastUse) + "]";
        }
    }
}

