/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Vector;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.TransportListener;

public abstract class AbstractTransportMapping
implements TransportMapping {
    protected Vector transportListener = new Vector(1);
    protected int maxInboundMessageSize = 65535;
    protected boolean asyncMsgProcessingSupported = true;

    public abstract Class getSupportedAddressClass();

    public abstract void sendMessage(Address var1, byte[] var2) throws IOException;

    public void addMessageDispatcher(MessageDispatcher dispatcher) {
        this.addTransportListener(dispatcher);
    }

    public void removeMessageDispatcher(MessageDispatcher dispatcher) {
        this.removeTransportListener(dispatcher);
    }

    public synchronized void addTransportListener(TransportListener l) {
        Vector v;
        Vector vector = v = this.transportListener == null ? new Vector(2) : (Vector)this.transportListener.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.transportListener = v;
        }
    }

    public synchronized void removeTransportListener(TransportListener l) {
        if (this.transportListener != null && this.transportListener.contains(l)) {
            Vector v = (Vector)this.transportListener.clone();
            v.removeElement(l);
            this.transportListener = v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProcessMessage(Address address, ByteBuffer buf) {
        if (this.transportListener != null) {
            for (int i = 0; i < this.transportListener.size(); ++i) {
                TransportListener l;
                AbstractTransportMapping abstractTransportMapping = this;
                synchronized (abstractTransportMapping) {
                    l = (TransportListener)this.transportListener.get(i);
                }
                l.processMessage(this, address, buf);
            }
        }
    }

    public abstract void close() throws IOException;

    public abstract void listen() throws IOException;

    public int getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public boolean isAsyncMsgProcessingSupported() {
        return this.asyncMsgProcessingSupported;
    }

    public void setAsyncMsgProcessingSupported(boolean asyncMsgProcessingSupported) {
        this.asyncMsgProcessingSupported = asyncMsgProcessingSupported;
    }

    public abstract /* synthetic */ boolean isListening();

    public abstract /* synthetic */ Address getListenAddress();
}

