/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;

public abstract class TransportIpAddress
extends IpAddress {
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$smi$TransportIpAddress == null ? (class$org$snmp4j$smi$TransportIpAddress = TransportIpAddress.class$("org.snmp4j.smi.TransportIpAddress")) : class$org$snmp4j$smi$TransportIpAddress);
    static final long serialVersionUID = 695596530250216972L;
    protected int port = 0;
    static /* synthetic */ Class class$org$snmp4j$smi$TransportIpAddress;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Illegal port specified: " + port);
        }
        this.port = port;
    }

    public boolean isValid() {
        return super.isValid() && this.port >= 0 && this.port <= 65535;
    }

    public int compareTo(Object o) {
        int result = super.compareTo(o);
        if (result == 0) {
            return this.port - ((TransportIpAddress)o).getPort();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof TransportIpAddress) {
            return super.equals(o) && ((TransportIpAddress)o).getPort() == this.port;
        }
        return false;
    }

    public boolean parseAddress(String address) {
        try {
            StringTokenizer st = new StringTokenizer(address, "/");
            String addr = st.nextToken();
            String port = st.nextToken();
            if (super.parseAddress(addr)) {
                this.port = Integer.parseInt(port);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Address parse(String address) {
        try {
            UdpAddress a = new UdpAddress();
            if (a.parseAddress(address)) {
                return a;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return super.toString() + "/" + this.port;
    }

    public int hashCode() {
        return super.hashCode() ^ 2 + this.port;
    }

    public void setTransportAddress(OctetString transportAddress) throws UnknownHostException {
        OctetString inetAddr = transportAddress.substring(0, transportAddress.length() - 2);
        this.setInetAddress(InetAddress.getByAddress(inetAddr.getValue()));
        this.port = (transportAddress.get(transportAddress.length() - 2) & 0xFF) << 8;
        this.port += transportAddress.get(transportAddress.length() - 1) & 0xFF;
    }

    public byte[] getValue() {
        byte[] addr = this.getInetAddress().getAddress();
        byte[] retval = new byte[addr.length + 2];
        System.arraycopy(addr, 0, retval, 0, addr.length);
        retval[addr.length] = (byte)(this.port >> 8 & 0xFF);
        retval[addr.length + 1] = (byte)(this.port & 0xFF);
        return retval;
    }

    public void decodeBER(BERInputStream inputStream) throws IOException {
        OctetString os = new OctetString();
        os.decodeBER(inputStream);
        try {
            this.setTransportAddress(os);
        }
        catch (Exception ex) {
            String txt = "Wrong encoding of TransportAddress";
            logger.error(txt);
            throw new IOException(txt + ": " + ex.getMessage());
        }
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        OctetString os = new OctetString(this.getValue());
        os.encodeBER(outputStream);
    }

    public int getBERLength() {
        return this.getInetAddress().getAddress().length + 2;
    }

    public int getBERPayloadLength() {
        return this.getBERLength();
    }

    public int getSyntax() {
        return 4;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

