/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.UnsignedInteger32;

public class TimeTicks
extends UnsignedInteger32 {
    private static final long serialVersionUID = 8663761323061572311L;
    private static final String FORMAT_PATTERN = "{0,choice,0#|1#1 day, |1<{0,number,integer} days, }{1,number,integer}:{2,number,00}:{3,number,00}.{4,number,00}";

    public TimeTicks() {
    }

    public TimeTicks(TimeTicks other) {
        this.value = other.value;
    }

    public TimeTicks(long value) {
        super(value);
    }

    public Object clone() {
        return new TimeTicks(this.value);
    }

    public int getSyntax() {
        return 67;
    }

    public void encodeBER(OutputStream os) throws IOException {
        BER.encodeUnsignedInteger(os, (byte)67, super.getValue());
    }

    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        long newValue = BER.decodeUnsignedInteger(inputStream, type);
        if (type.getValue() != 67) {
            throw new IOException("Wrong type encountered when decoding TimeTicks: " + type.getValue());
        }
        this.setValue(newValue);
    }

    public String toString() {
        return this.toString(FORMAT_PATTERN);
    }

    public String toString(String pattern) {
        long tt = this.getValue();
        long days = tt / 8640000L;
        long hours = (tt %= 8640000L) / 360000L;
        long minutes = (tt %= 360000L) / 6000L;
        long seconds = (tt %= 6000L) / 100L;
        long hseconds = tt %= 100L;
        Object[] values = new Long[]{new Long(days), new Long(hours), new Long(minutes), new Long(seconds), new Long(hseconds)};
        return MessageFormat.format(pattern, values);
    }

    public long toMilliseconds() {
        return this.value * 10L;
    }

    public void fromMilliseconds(long millis) {
        this.setValue(millis / 10L);
    }
}

