/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.Serializable;
import java.util.Hashtable;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.UsmTimeEntry;
import org.snmp4j.smi.OctetString;

public class UsmTimeTable
implements Serializable {
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$security$UsmTimeTable == null ? (class$org$snmp4j$security$UsmTimeTable = UsmTimeTable.class$("org.snmp4j.security.UsmTimeTable")) : class$org$snmp4j$security$UsmTimeTable);
    private Hashtable table = new Hashtable(10);
    private long lastLocalTimeChange = System.currentTimeMillis();
    private UsmTimeEntry localTime;
    static /* synthetic */ Class class$org$snmp4j$security$UsmTimeTable;

    public UsmTimeTable(OctetString localEngineID, int engineBoots) {
        this.setLocalTime(new UsmTimeEntry(localEngineID, engineBoots, 0));
    }

    public void addEntry(UsmTimeEntry entry) {
        this.table.put(entry.getEngineID(), entry);
    }

    public UsmTimeEntry getEntry(OctetString engineID) {
        return (UsmTimeEntry)this.table.get(engineID);
    }

    public UsmTimeEntry getLocalTime() {
        UsmTimeEntry entry = new UsmTimeEntry(this.localTime.getEngineID(), this.localTime.getEngineBoots(), this.getEngineTime());
        entry.setTimeDiff(entry.getTimeDiff() * -1 + this.localTime.getTimeDiff());
        return entry;
    }

    private void setLocalTime(UsmTimeEntry localTime) {
        this.localTime = localTime;
        this.lastLocalTimeChange = System.currentTimeMillis();
    }

    public void setEngineBoots(int engineBoots) {
        this.localTime.setEngineBoots(engineBoots);
    }

    public int getEngineTime() {
        return (int)((System.currentTimeMillis() - this.lastLocalTimeChange) / 1000L % 0x80000000L);
    }

    public int getEngineBoots() {
        return this.localTime.getEngineBoots();
    }

    public synchronized UsmTimeEntry getTime(OctetString engineID) {
        if (this.localTime.getEngineID().equals(engineID)) {
            return this.getLocalTime();
        }
        UsmTimeEntry found = (UsmTimeEntry)this.table.get(engineID);
        if (found == null) {
            return null;
        }
        return new UsmTimeEntry(engineID, found.getEngineBoots(), found.getTimeDiff() + (int)(System.currentTimeMillis() / 1000L));
    }

    public void removeEntry(OctetString engineID) {
        this.table.remove(engineID);
    }

    public synchronized int checkEngineID(OctetString engineID, boolean discoveryAllowed) {
        if (this.table.get(engineID) != null) {
            return 0;
        }
        if (discoveryAllowed) {
            this.addEntry(new UsmTimeEntry(engineID, 0, 0));
            return 0;
        }
        return 1410;
    }

    public synchronized int checkTime(UsmTimeEntry entry) {
        int now = (int)(System.currentTimeMillis() / 1000L);
        if (this.localTime.getEngineID().equals(entry.getEngineID())) {
            if (this.localTime.getEngineBoots() == Integer.MAX_VALUE || this.localTime.getEngineBoots() != entry.getEngineBoots() || Math.abs(now + this.localTime.getTimeDiff() - entry.getLatestReceivedTime()) > 150) {
                if (logger.isDebugEnabled()) {
                    logger.debug("CheckTime: received message outside time window (authorative):" + (this.localTime.getEngineBoots() != entry.getEngineBoots() ? "engineBoots differ" : "" + Math.abs(now + this.localTime.getTimeDiff() - entry.getLatestReceivedTime()) + " > 150"));
                }
                return 1411;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("CheckTime: time ok (authorative)");
            }
            return 0;
        }
        UsmTimeEntry time = (UsmTimeEntry)this.table.get(entry.getEngineID());
        if (time == null) {
            return 1410;
        }
        if (entry.getEngineBoots() < time.getEngineBoots() || entry.getEngineBoots() == time.getEngineBoots() && time.getTimeDiff() + now > entry.getLatestReceivedTime() + 150 || time.getEngineBoots() == Integer.MAX_VALUE) {
            if (logger.isDebugEnabled()) {
                logger.debug("CheckTime: received message outside time window (non authorative)");
            }
            return 1411;
        }
        if (entry.getEngineBoots() > time.getEngineBoots() || entry.getEngineBoots() == time.getEngineBoots() && entry.getLatestReceivedTime() > time.getLatestReceivedTime()) {
            time.setEngineBoots(entry.getEngineBoots());
            time.setLatestReceivedTime(entry.getLatestReceivedTime());
            time.setTimeDiff(entry.getLatestReceivedTime() - now);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CheckTime: time ok (non authorative)");
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

