/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.io.IOException;
import java.io.OutputStream;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityParameters;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OctetString;

public class UsmSecurityParameters
implements SecurityParameters {
    private static final int MAX_BER_LENGTH_WITHOU_SEC_PARAMS = 80;
    private OctetString authoritativeEngineID = new OctetString();
    private Integer32 authoritativeEngineBoots = new Integer32();
    private Integer32 authoritativeEngineTime = new Integer32();
    private OctetString userName = new OctetString();
    private AuthenticationProtocol authenticationProtocol = null;
    private PrivacyProtocol privacyProtocol = null;
    private byte[] authenticationKey;
    private byte[] privacyKey;
    private OctetString privacyParameters = new OctetString();
    private OctetString authenticationParameters = new OctetString();
    private int securityParametersPosition = -1;
    private int authParametersPosition = -1;
    private int decodedLength = -1;

    public UsmSecurityParameters() {
    }

    public UsmSecurityParameters(OctetString authoritativeEngineID, Integer32 authoritativeEngineBoots, Integer32 authoritativeEngineTime, OctetString userName, AuthenticationProtocol authenticationProtocol, PrivacyProtocol privacyProtocol) {
        this.authoritativeEngineID = authoritativeEngineID;
        this.authoritativeEngineBoots = authoritativeEngineBoots;
        this.authoritativeEngineTime = authoritativeEngineTime;
        this.privacyProtocol = privacyProtocol;
        this.userName = userName;
        this.authenticationProtocol = authenticationProtocol;
    }

    public byte[] getAuthoritativeEngineID() {
        return this.authoritativeEngineID.getValue();
    }

    public void setAuthoritativeEngineID(byte[] authoritativeEngineID) {
        if (authoritativeEngineID == null) {
            throw new NullPointerException("Authoritative engine ID must not be null");
        }
        this.authoritativeEngineID.setValue(authoritativeEngineID);
    }

    public void setAuthoritativeEngineBoots(int authoritativeEngineBoots) {
        this.authoritativeEngineBoots.setValue(authoritativeEngineBoots);
    }

    public int getAuthoritativeEngineBoots() {
        return this.authoritativeEngineBoots.getValue();
    }

    public void setAuthoritativeEngineTime(int authoritativeEngineTime) {
        this.authoritativeEngineTime.setValue(authoritativeEngineTime);
    }

    public int getAuthoritativeEngineTime() {
        return this.authoritativeEngineTime.getValue();
    }

    public void setUserName(OctetString userName) {
        this.userName = userName;
    }

    public OctetString getUserName() {
        return this.userName;
    }

    public void setAuthenticationProtocol(AuthenticationProtocol authenticationProtocol) {
        this.authenticationProtocol = authenticationProtocol;
    }

    public AuthenticationProtocol getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public void setPrivacyProtocol(PrivacyProtocol privacyProtocol) {
        this.privacyProtocol = privacyProtocol;
    }

    public PrivacyProtocol getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public int getBERLength() {
        int length = this.getBERPayloadLength();
        return length + BER.getBERLengthOfLength(length) + 1;
    }

    public int getBERPayloadLength() {
        int length = this.getBERUsmPayloadLength();
        length += BER.getBERLengthOfLength(length) + 1;
        return length;
    }

    public void decodeBER(BERInputStream inputStream) throws IOException {
        int pos;
        this.decodedLength = pos = (int)inputStream.getPosition();
        BER.MutableByte mutableByte = new BER.MutableByte();
        int octetLength = BER.decodeHeader(inputStream, mutableByte);
        long startPos = inputStream.getPosition();
        if (mutableByte.getValue() != 4) {
            throw new IOException("Expected BER OCTETSTRING but found: " + mutableByte.getValue());
        }
        int length = BER.decodeHeader(inputStream, mutableByte);
        if (mutableByte.getValue() != 48) {
            throw new IOException("Expected BER SEQUENCE but found: " + mutableByte.getValue());
        }
        this.authoritativeEngineID.decodeBER(inputStream);
        this.authoritativeEngineBoots.decodeBER(inputStream);
        this.authoritativeEngineTime.decodeBER(inputStream);
        this.userName.decodeBER(inputStream);
        this.authParametersPosition = (int)(inputStream.getPosition() - (long)pos);
        pos = (int)inputStream.getPosition();
        this.authenticationParameters.decodeBER(inputStream);
        this.authParametersPosition = (int)((long)this.authParametersPosition + (inputStream.getPosition() - (long)pos - (long)this.authenticationParameters.getBERPayloadLength()));
        this.privacyParameters.decodeBER(inputStream);
        this.decodedLength = (int)(inputStream.getPosition() - (long)this.decodedLength);
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength(octetLength, (int)(inputStream.getPosition() - startPos), this);
        }
    }

    private int getBEREncodedAuthParamsPosition() {
        int length = this.getBERLength() - (this.authenticationParameters.getBERPayloadLength() + this.privacyParameters.getBERLength());
        return length;
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeHeader(outputStream, 4, this.getBERPayloadLength());
        BER.encodeHeader(outputStream, 48, this.getBERUsmPayloadLength());
        this.authoritativeEngineID.encodeBER(outputStream);
        this.authoritativeEngineBoots.encodeBER(outputStream);
        this.authoritativeEngineTime.encodeBER(outputStream);
        this.userName.encodeBER(outputStream);
        this.authenticationParameters.encodeBER(outputStream);
        this.privacyParameters.encodeBER(outputStream);
    }

    public int getBERUsmPayloadLength() {
        int length = this.authoritativeEngineID.getBERLength();
        length += this.authoritativeEngineBoots.getBERLength();
        length += this.authoritativeEngineTime.getBERLength();
        length += this.userName.getBERLength();
        length += this.authenticationParameters.getBERLength();
        return length += this.privacyParameters.getBERLength();
    }

    public int getBERMaxLength(int securityLevel) {
        SecurityProtocols secProtocol = SecurityProtocols.getInstance();
        int securityParamsLength = 2;
        if (securityLevel > 1) {
            securityParamsLength = secProtocol.getMaxAuthDigestLength() + BER.getBERLengthOfLength(secProtocol.getMaxAuthDigestLength()) + 1;
            if (securityLevel == 3) {
                securityParamsLength += secProtocol.getMaxPrivDecryptParamsLength() + BER.getBERLengthOfLength(secProtocol.getMaxPrivDecryptParamsLength()) + 1;
            }
        }
        return 80 + securityParamsLength + BER.getBERLengthOfLength(80 + securityParamsLength) + 1;
    }

    public byte[] getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setAuthenticationKey(byte[] authenticationKey) {
        this.authenticationKey = authenticationKey;
    }

    public byte[] getPrivacyKey() {
        return this.privacyKey;
    }

    public void setPrivacyKey(byte[] privacyKey) {
        this.privacyKey = privacyKey;
    }

    public OctetString getPrivacyParameters() {
        return this.privacyParameters;
    }

    public void setPrivacyParameters(OctetString privacyParameters) {
        this.privacyParameters = privacyParameters;
    }

    public OctetString getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    public void setAuthenticationParameters(OctetString authenticationParameters) {
        this.authenticationParameters = authenticationParameters;
    }

    public int getSecurityParametersPosition() {
        return this.securityParametersPosition;
    }

    public void setSecurityParametersPosition(int securityParametersPosition) {
        this.securityParametersPosition = securityParametersPosition;
    }

    public int getAuthParametersPosition() {
        if (this.authParametersPosition >= 0) {
            return this.authParametersPosition;
        }
        return this.getBEREncodedAuthParamsPosition();
    }

    public int getScopedPduPosition() {
        if (this.decodedLength >= 0) {
            return this.decodedLength + this.getSecurityParametersPosition();
        }
        return this.getSecurityParametersPosition() + this.getBERLength();
    }
}

