/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.ByteArrayWindow;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;

public abstract class AuthGeneric
implements AuthenticationProtocol {
    private static final LogAdapter logger = LogFactory.getLogger(class$org$snmp4j$security$AuthGeneric == null ? (class$org$snmp4j$security$AuthGeneric = AuthGeneric.class$("org.snmp4j.security.AuthGeneric")) : class$org$snmp4j$security$AuthGeneric);
    private int digestLength;
    private String protoName;
    static /* synthetic */ Class class$org$snmp4j$security$AuthGeneric;

    public AuthGeneric(String protoName, int digestLength) {
        this.protoName = protoName;
        this.digestLength = digestLength;
    }

    public int getDigestLength() {
        return this.digestLength;
    }

    protected MessageDigest getDigestObject() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(this.protoName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalError(this.protoName + " not supported in this VM.");
        }
        return md;
    }

    public boolean authenticate(byte[] authenticationKey, byte[] message, int messageOffset, int messageLength, ByteArrayWindow digest) {
        int i;
        MessageDigest md = this.getDigestObject();
        byte[] k_ipad = new byte[64];
        byte[] k_opad = new byte[64];
        for (i = 0; i < 12; ++i) {
            digest.set(i, (byte)0);
        }
        for (i = 0; i < authenticationKey.length; ++i) {
            k_ipad[i] = (byte)(authenticationKey[i] ^ 0x36);
            k_opad[i] = (byte)(authenticationKey[i] ^ 0x5C);
        }
        for (i = authenticationKey.length; i < 64; ++i) {
            k_ipad[i] = 54;
            k_opad[i] = 92;
        }
        md.update(k_ipad);
        md.update(message, messageOffset, messageLength);
        byte[] newDigest = md.digest();
        md.reset();
        md.update(k_opad);
        md.update(newDigest);
        newDigest = md.digest();
        for (i = 0; i < 12; ++i) {
            digest.set(i, newDigest[i]);
        }
        return true;
    }

    public boolean isAuthentic(byte[] authenticationKey, byte[] message, int messageOffset, int messageLength, ByteArrayWindow digest) {
        ByteArrayWindow origDigest = new ByteArrayWindow(new byte[12], 0, 12);
        System.arraycopy(digest.getValue(), digest.getOffset(), origDigest.getValue(), 0, 12);
        if (!this.authenticate(authenticationKey, message, messageOffset, messageLength, digest)) {
            return false;
        }
        return digest.equals(origDigest, 12);
    }

    public byte[] changeDelta(byte[] oldKey, byte[] newKey, byte[] random) {
        int i;
        MessageDigest md5 = this.getDigestObject();
        if (logger.isDebugEnabled()) {
            logger.debug(this.protoName + "oldKey: " + new OctetString(oldKey).toHexString());
            logger.debug(this.protoName + "newKey: " + new OctetString(newKey).toHexString());
            logger.debug(this.protoName + "random: " + new OctetString(random).toHexString());
        }
        md5.update(oldKey);
        md5.update(random);
        byte[] digest = md5.digest();
        byte[] keyChange = new byte[random.length + newKey.length];
        for (i = 0; i < random.length; ++i) {
            keyChange[i] = random[i];
        }
        for (i = random.length; i < random.length + newKey.length; ++i) {
            keyChange[i] = newKey[i - random.length];
        }
        for (int j = oldKey.length; j < keyChange.length; ++j) {
            int n = j;
            keyChange[n] = (byte)(keyChange[n] ^ digest[j - oldKey.length]);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.protoName + "keyChange:" + new OctetString(keyChange).toHexString());
        }
        return keyChange;
    }

    public byte[] passwordToKey(OctetString passwordString, byte[] engineID) {
        MessageDigest md = this.getDigestObject();
        byte[] buf = new byte[64];
        int password_index = 0;
        byte[] password = passwordString.getValue();
        for (int count = 0; count < 0x100000; count += 64) {
            for (int i = 0; i < 64; ++i) {
                buf[i] = password[password_index++ % password.length];
            }
            md.update(buf);
        }
        byte[] digest = md.digest();
        if (logger.isDebugEnabled()) {
            logger.debug(this.protoName + "First digest: " + new OctetString(digest).toHexString());
        }
        md.reset();
        md.update(digest);
        md.update(engineID);
        md.update(digest);
        digest = md.digest();
        if (logger.isDebugEnabled()) {
            logger.debug(this.protoName + "localized key: " + new OctetString(digest).toHexString());
        }
        return digest;
    }

    public byte[] hash(byte[] data) {
        MessageDigest md = this.getDigestObject();
        md.update(data);
        return md.digest();
    }

    public byte[] hash(byte[] data, int offset, int length) {
        MessageDigest md = this.getDigestObject();
        md.update(data, offset, length);
        return md.digest();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ OID getID();
}

