/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Arrays;

public class LogLevel {
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_OFF = 1;
    public static final int LEVEL_ALL = 2;
    public static final int LEVEL_TRACE = 3;
    public static final int LEVEL_DEBUG = 4;
    public static final int LEVEL_INFO = 5;
    public static final int LEVEL_WARN = 6;
    public static final int LEVEL_ERROR = 7;
    public static final int LEVEL_FATAL = 8;
    private static final String[] LEVEL_STRINGS = new String[]{"NONE", "OFF", "ALL", "TRACE", "DEBUG", "INFO", "WARN", "INFO", "ERROR", "FATAL"};
    public static final LogLevel NONE = new LogLevel(0);
    public static final LogLevel OFF = new LogLevel(1);
    public static final LogLevel ALL = new LogLevel(2);
    public static final LogLevel TRACE = new LogLevel(3);
    public static final LogLevel DEBUG = new LogLevel(4);
    public static final LogLevel INFO = new LogLevel(5);
    public static final LogLevel WARN = new LogLevel(6);
    public static final LogLevel ERROR = new LogLevel(7);
    public static final LogLevel FATAL = new LogLevel(8);
    private int level;

    public LogLevel(int level) {
        if (level < 0 || level > 8) {
            throw new IllegalArgumentException("Unknown log level " + level);
        }
        this.level = level;
    }

    public LogLevel(String levelString) {
        this(LogLevel.levelFromString(levelString));
    }

    public static int levelFromString(String levelString) {
        int ind = Arrays.binarySearch(LEVEL_STRINGS, levelString);
        if (ind >= 0) {
            return ind + 1;
        }
        return 0;
    }

    public static LogLevel toLevel(String levelString) {
        return new LogLevel(LogLevel.levelFromString(levelString));
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return LEVEL_STRINGS[this.level - 1];
    }
}

