/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class JavaLogAdapter
implements LogAdapter {
    private final Logger logger;

    public JavaLogAdapter(Logger logger) {
        this.logger = logger;
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(LogLevel.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isLoggable(LogLevel.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isLoggable(LogLevel.WARN);
    }

    public void debug(Object message) {
        this.log(LogLevel.DEBUG, message.toString(), null);
    }

    public void info(Object message) {
        this.log(LogLevel.INFO, message.toString(), null);
    }

    public void warn(Object message) {
        this.log(LogLevel.WARN, message.toString(), null);
    }

    public void error(Object message) {
        this.log(LogLevel.ERROR, message.toString(), null);
    }

    public void error(Object message, Throwable t) {
        this.log(LogLevel.ERROR, message.toString(), t);
    }

    public void fatal(Object message) {
        this.log(LogLevel.FATAL, message.toString(), null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(LogLevel.FATAL, message.toString(), t);
    }

    public LogLevel getEffectiveLogLevel() {
        return JavaLogAdapter.fromJavaToSnmp4jLevel(this.logger.getLevel());
    }

    public Iterator getLogHandler() {
        return Arrays.asList(this.logger.getHandlers()).iterator();
    }

    public LogLevel getLogLevel() {
        return this.getEffectiveLogLevel();
    }

    public String getName() {
        return this.logger.getName();
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logger.setLevel(JavaLogAdapter.fromSnmp4jToJdk(logLevel));
    }

    private boolean isLoggable(LogLevel logLevel) {
        return this.logger.isLoggable(JavaLogAdapter.fromSnmp4jToJdk(logLevel));
    }

    private void log(LogLevel logLevel, String msg, Throwable t) {
        this.logger.log(JavaLogAdapter.fromSnmp4jToJdk(logLevel), msg, t);
    }

    private static Level fromSnmp4jToJdk(LogLevel logLevel) {
        if (logLevel == null) {
            return null;
        }
        switch (logLevel.getLevel()) {
            case 2: {
                return Level.ALL;
            }
            case 4: {
                return Level.CONFIG;
            }
            case 3: {
                return Level.CONFIG;
            }
            case 5: {
                return Level.INFO;
            }
            case 6: {
                return Level.WARNING;
            }
            case 7: {
                return Level.SEVERE;
            }
            case 8: {
                return Level.SEVERE;
            }
            case 1: {
                return Level.OFF;
            }
            case 0: {
                return Level.OFF;
            }
        }
        throw new IllegalArgumentException("Mapping not defined from SNMP4J level " + logLevel + " to Java logging level");
    }

    private static LogLevel fromJavaToSnmp4jLevel(Level level) {
        if (level == null) {
            return null;
        }
        if (Level.ALL.equals(level)) {
            return LogLevel.ALL;
        }
        if (Level.SEVERE.equals(level)) {
            return LogLevel.FATAL;
        }
        if (Level.WARNING.equals(level)) {
            return LogLevel.WARN;
        }
        if (Level.INFO.equals(level)) {
            return LogLevel.INFO;
        }
        if (Level.CONFIG.equals(level)) {
            return LogLevel.DEBUG;
        }
        if (Level.FINE.equals(level)) {
            return LogLevel.TRACE;
        }
        if (Level.FINER.equals(level)) {
            return LogLevel.TRACE;
        }
        if (Level.FINEST.equals(level)) {
            return LogLevel.TRACE;
        }
        if (Level.OFF.equals(level)) {
            return LogLevel.DEBUG;
        }
        throw new IllegalArgumentException("Mapping not defined from Java level " + level.getName() + " to SNMP4J logging level");
    }
}

